var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TdfManagerBl = require('../../bll/tdfManagerBl');
var Connection = require('Connection');
var Dao = require('Dao');

/**
 * 获得文件内容
 */
var SaveFileContent = function () {
  Service.call(this);
  this.sqlInject.exclude = ['filePath', 'data'];
  this.xssInject.exclude = ['data'];
};

util.inherits(SaveFileContent, Service);

module.exports = SaveFileContent;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} req.filePath 文件路径
 * @param  {Object} req.data 文件内容
 * @param  {'Form'|'Query'} req.type 保存类型
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SaveFileContent.prototype.process = function (req, res) {
  if (!req.filePath) {
    this.onLogicError(1, '请提供文件路径！');
    return;
  }
  if (!req.data) {
    this.onLogicError(1, '请提供文件内容！');
    return;
  }
  req.type = req.type || 'Form';

  const self = this;
  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  const filePath = utils.getPath(req.filePath);
  this.tdf = JSON.parse(fs.readFileSync(filePath, "utf-8"));
  const oldTdf = { ...this.tdf };
  this.tdfManagerBl = new TdfManagerBl(this);

  if (req.type == 'Form') {
    this.changeFormData(req, res, function (json) {
      self.tdf.models = json;
      if (req.notCheckLogin) self.tdf.info.notCheckLogin = req.notCheckLogin;
      if (req.notCheckSQLInject) self.tdf.info.notCheckSQLInject = req.notCheckSQLInject;
      self.changeQueryData(req, res);
      self.changeMFormData(req, res);
      self.changeMQueryData(req, res);
      self.compareItems(oldTdf, self.tdf, () => {
        // 删除不涉及的前后台(查询选项卡改名后会保留历史残留)
        self.tdf = self.tdfManagerBl.deleteNotInvolve(self.tdf);
        saveFile();
      });
    });

  }
  if (req.type == 'Query') {
    this.changeQueryData(req, res);
    saveFile();
  }
  if (req.type == 'MForm') {
    this.changeMFormData(req, res);
    saveFile();
  }
  if (req.type == 'MQuery') {
    this.changeMQueryData(req, res);
    saveFile();
  }

  function saveFile() {
    fs.writeFile(filePath, JSON.stringify(self.tdf, null, "  "), function (err) {
      if (err) {
        res.code = 3;
        res.message = err.message;
      }

      res.tdf = self.tdf;
      res.defaultTFP = self.getDefaultTFP(req, res);
      res.defaultMListTFP = self.getDefaultMListTFP(req, res);
      self.end(res);
    });
  }
};

SaveFileContent.prototype.changeFormData = function (req, res, cb) {
  const { tdf, tdfManagerBl } = this;

  tdf.views.edit.tfp = JSON.parse(req.data);

  tdf.views.edit.tfp.projName = tdf.info.projName;
  tdf.views.edit.tfp.tableName = tdf.info.projName + '_' + tdf.info.tableName;

  tdf.items = tdfManagerBl.parseItems({
    "items": tdf.items,
    "tfp": tdf.views.edit.tfp,
    "changeVerifies": req.changeVerifies,
    "changeUniqueVerify": req.changeUniqueVerify,
  });

  if (!tdf.info.viewParam) {
    tdf.info.viewParam = {
      client: tdf.views.edit.tfp.client,
      mobileType: tdf.views.edit.tfp.mobileType,
      framework: tdf.views.edit.tfp.framework,
      positionType: tdf.views.edit.tfp.positionType,
      pageType: tdf.views.edit.tfp.pageType,
      bgColorMode: tdf.views.edit.tfp.bgColorMode,
      title: tdf.views.edit.tfp.title
    }
  }
  tdf.info.viewParam.title = tdf.views.edit.tfp.title;

  tdf.services.save.tbs = tdfManagerBl.transformTBS({
    "type": "save",
    // "tbs": tdfManagerBl.defaultTBS({
    //   "type": "save",
    //   "info": tdf.info
    // }),
    "info": tdf.info,
    "items": tdf.items,
  });
  tdf.services.get.tbs = tdfManagerBl.transformTBS({
    "type": "get",
    // "tbs": tdfManagerBl.defaultTBS({
    //   "type": "get",
    //   "info": tdf.info
    // }),
    "info": tdf.info,
    "items": tdf.items,
  });
  tdf.services.remove.tbs = tdfManagerBl.transformTBS({
    "type": "remove",
    "tbs": tdfManagerBl.defaultTBS({
      "type": "remove",
      "info": tdf.info
    }),
    "info": tdf.info,
    "items": tdf.items,
  });

  tdfManagerBl.transformModels({
    // tdfManagerBl.transformTDM({
    "info": tdf.info,
    // "tdm": tdf.models[tdf.info.tableName].tdm,
    "models": tdf.models,
    // "items": tdf.items.main,
    "items": tdf.items
  }, cb);
}

SaveFileContent.prototype.changeQueryData = function (req, res) {
  const { tdf, tdfManagerBl } = this;
  if (req.type == 'Query') tdf.tabs = JSON.parse(req.data);
  if (!tdf.tabs) {
    tdf.tabs = {
      "enable": false,
      "default": "",
      "pages": [{
        "name": "",
        "param": {
          "autoFields": true,
          "isCreate": true,
          "isDelete": true,
        },
        "query": [],
        "fields": []
      }],
    }
  }
  const tabsInfo = tdf.tabs;

  for (const key in tdf.views) {
    if (/index\d+/.test(key)) delete tdf.views[key];
    if (/list\d+/.test(key)) delete tdf.services[key];
  }

  tdf.views.index.tfp = tdfManagerBl.transformTFP({
    "type": "tab",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "tab",
      "info": tdf.info
    }),
    "tabs": tabsInfo,
  });

  tabsInfo.pages.forEach((page, index) => {
    let pageIndex = page.code;
    tdf.views[pageIndex] = {
      "type": pageIndex,
      "tdf": {},
      "tfp": {}
    }

    tdf.views[pageIndex].tfp = tdfManagerBl.transformTFP({
      "type": "index",
      "info": tdf.info,
      "param": {
        client: tdf.views.edit.tfp.client,
        mobileType: tdf.views.edit.tfp.mobileType,
        framework: tdf.views.edit.tfp.framework,
        positionType: tdf.views.edit.tfp.positionType,
        pageType: tdf.views.edit.tfp.pageType,
        bgColorMode: tdf.views.edit.tfp.bgColorMode,
        title: tdf.views.edit.tfp.title
      },
      "tfp": tdfManagerBl.defaultTFP({
        "type": "index",
        "info": tdf.info
      }),
      "items": tdf.items,
      "page": page,
      "pageIndex": index
    });

    pageIndex = page.code;
    tdf.services[pageIndex] = {
      "type": 'index',
      "tdf": {},
      "tbs": {}
    }
    tdf.services[pageIndex].tbs = tdfManagerBl.transformTBS({
      "type": "list",
      "tbs": tdfManagerBl.defaultTBS({
        "type": "list",
        "info": tdf.info
      }),
      "info": tdf.info,
      "items": tdf.items,
      "page": page,
      "pageIndex": index,
    }, req.session);
  });

  // 删除不涉及的前后台(查询选项卡改名后会保留历史残留)
  this.tdf = this.tdfManagerBl.deleteNotInvolve(this.tdf);

  this.tdf = tdf;
}

SaveFileContent.prototype.changeMFormData = function (req, res) {
  const { tdf, tdfManagerBl } = this;
  if (req.type == 'MForm') tdf.phoneEdit = JSON.parse(req.data);

  if (!tdf.views.mEdit) tdf.views.mEdit = {
    "type": "edit",
    "tdf": {},
    "tfp": {}
  };

  const info = JSON.parse(JSON.stringify(tdf.info));
  info.viewParam.client = 'phone';
  tdf.views.mEdit.tfp = tdfManagerBl.transformTFP({
    "type": "mEdit",
    "info": info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "mEdit",
      "info": info
    }),
    "items": tdf.items,
    "editTfp": tdf.views.edit.tfp,
    "phoneEdit": tdf.phoneEdit
  });

  // 删除不涉及的前后台(查询选项卡改名后会保留历史残留)
  this.tdf = this.tdfManagerBl.deleteNotInvolve(this.tdf);

  this.tdf = tdf;
}

SaveFileContent.prototype.changeMQueryData = function (req, res) {
  const { tdf, tdfManagerBl } = this;
  if (req.type == 'MQuery') tdf.phoneTabs = JSON.parse(req.data);
  if (!tdf.phoneTabs) {
    tdf.phoneTabs = {
      "enable": false,
      "default": "",
      "pages": [{
        "name": "",
        "param": {
          "autoFields": true,
          "isCreate": true,
          "isDelete": true,
        },
        "query": [],
        "fields": []
      }],
    }
  }
  const tabsInfo = tdf.phoneTabs;

  const info = JSON.parse(JSON.stringify(tdf.info));
  info.viewParam.client = 'phone';
  tdf.views.mIndex.tfp = tdfManagerBl.transformTFP({
    "type": "tab",
    "info": info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "tab",
      "info": info
    }),
    "tabs": tdf.phoneTabs,
  });

  tabsInfo.pages.forEach((page, index) => {
    pageIndex = page.code;
    
    tdf.views[pageIndex] = {
      "type": pageIndex,
      "tdf": {},
      "tfp": {}
    }
    tdf.views[pageIndex].tfp = tdfManagerBl.transformTFP({
      "type": "mList",
      "info": info,
      "tfp": tdfManagerBl.defaultTFP({
        "type": "mList",
        "info": info
      }),
      "items": tdf.items,
      "page": page,
    });
  
    tdf.services[pageIndex] = {
      "type": pageIndex,
      "tdf": {},
      "tbs": {}
    }
    tdf.services[pageIndex].tbs = tdfManagerBl.transformTBS({
      "type": "list",
      "tbs": tdfManagerBl.defaultTBS({
        "type": "list",
        "info": info
      }),
      "info": info,
      "items": tdf.items,
      "page": page,
      "pageIndex": index,
    }, req.session);
  });

  // 删除不涉及的前后台(查询选项卡改名后会保留历史残留)
  this.tdf = this.tdfManagerBl.deleteNotInvolve(this.tdf);

  this.tdf = tdf;
}

SaveFileContent.prototype.getDefaultTFP = function (req, res) {
  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  const tdfManagerBl = new TdfManagerBl(this);
  const tdf = res.tdf;

  if (!tdf.info.viewParam) {
    tdf.info.viewParam = {
      client: tdf.views.edit.tfp.client,
      mobileType: tdf.views.edit.tfp.mobileType,
      framework: tdf.views.edit.tfp.framework,
      positionType: tdf.views.edit.tfp.positionType,
      pageType: tdf.views.edit.tfp.pageType,
      bgColorMode: tdf.views.edit.tfp.bgColorMode,
      title: tdf.views.edit.tfp.title
    }
  }

  return tdfManagerBl.transformTFP({
    "type": "index",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "index",
      "info": tdf.info
    }),
    "items": tdf.items,
    "page": {
      "name": "",
      "param": {
        "autoFields": true
      },
      "query": [],
      "fields": []
    },
    "pageIndex": 0
  });
}

SaveFileContent.prototype.getDefaultMListTFP = function (req, res) {
  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  const tdfManagerBl = new TdfManagerBl(this);
  const tdf = JSON.parse(JSON.stringify(res.tdf));

  if (!tdf.info.viewParam) {
    tdf.info.viewParam = {
      client: 'phone',
      mobileType: tdf.views.edit.tfp.mobileType,
      framework: tdf.views.edit.tfp.framework,
      positionType: tdf.views.edit.tfp.positionType,
      pageType: tdf.views.edit.tfp.pageType,
      bgColorMode: tdf.views.edit.tfp.bgColorMode,
      title: tdf.views.edit.tfp.title
    }
  }
  tdf.info.viewParam.client = 'phone';

  return tdfManagerBl.transformTFP({
    "type": "mList",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "mList",
      "info": tdf.info
    }),
    "items": tdf.items,
    "page": {
      "name": "",
      "param": {
        "autoFields": true
      },
      "query": [],
      "fields": []
    },
  });
}

SaveFileContent.prototype.compareItems = function (oldTdf, newTdf, cb) {
  const dao = new Dao(this);
  const mainTableName = `${newTdf.info.projName}/${newTdf.info.dataPath ? newTdf.info.dataPath + '/' : ''}${newTdf.info.dataName}`.replaceAll('/', "_");
  const connection = new Connection(server.config.Database);
  const sqlList = [];
  for (const key in oldTdf.items) {
    if (key == 'main') compareMainItems();
    else compareSubItems(key);
  }
  dao.exeSqls(sqlList, 0, cb);


  function compareMainItems() {
    const itemDict = {};
    newTdf.items.main.forEach(item => { itemDict[item.uid] = item; });
    oldTdf.items.main.forEach(item => {
      if (!itemDict[item.uid]) {
        const args = {
          tableName: mainTableName,
          oldColumnName: item.fieldName,
          columnName: `drop_${item.fieldName}_${new Date().getTime()}`,
          dataType: item.fieldType,
          length: item.length,
          precision: item.precision,
          scale: item.scale,
        };
        const sql = connection.getObjectDDL('COLUMN_RENAME', args);
        sqlList.push(...sql);
      }
    });
  }

  function compareSubItems(key) {
    const subTableName = `${mainTableName}_${oldTdf.items[key].id}`;
    // 如果新tdf中没有子表则删除表
    let isExist = false;
    for (const _key in newTdf.items) {
      if (key == _key) isExist = true;
    }
    if (isExist) {
      const itemDict = {};
      newTdf.items[key].fields.forEach(item => { itemDict[item.uid] = item; });
      oldTdf.items[key].fields.forEach(item => {
        if (!itemDict[item.uid]) {
          const args = {
            tableName: subTableName,
            oldColumnName: item.fieldName,
            columnName: `drop_${item.fieldName}_${new Date().getTime()}`,
            dataType: item.fieldType,
            length: item.length,
            precision: item.precision,
            scale: item.scale,
          };
          const sql = connection.getObjectDDL('COLUMN_RENAME', args);
          sqlList.push(...sql);
        }
      });
    }
    else {
      const args = {
        oldTableName: subTableName,
        tableName: `drop_${subTableName}_${new Date().getTime()}`,
      };
      const sql = connection.getObjectDDL('TABLE_RENAME', args);
      sqlList.push(...sql);
    }
  }
}