const util = require('util');
const fs = require('fs');
const utils = require('utils');
const Service = require('Service');

/**
 * 分解tdf文件为tdm、tbs、tfp前的服务
 * 主要校验分解出的文件是否存在，存在多少，前端确认是否继续
 */
const PrevSplitTDF = function () {
    Service.call(this);
};

util.inherits(PrevSplitTDF, Service);

module.exports = PrevSplitTDF;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {String} req.filePath 文件路径
 * @param  {Object} res 服务响应对象
 * @param  {Boolean} res.isExists 文件是否存在
 */
PrevSplitTDF.prototype.process = function (req, res) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');

    const filePath = utils.getPath(req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, ''));
    const fileName = filePath.split('/').pop();
    const tdf = JSON.parse(fs.readFileSync(filePath, "utf-8"));
    const templateFilePath = {
        'tdm': filePath.replaceWithEnd('/tdf/', '/model/').replaceWithEnd(fileName, tdf.info.dataName + '/'),
        'tbs': filePath.replaceWithEnd('/tdf/', '/service/').replaceWithEnd(fileName, tdf.info.dataName + '/'),
        'tfp': filePath.replace(/\/app\/(.*)tdf\//, '/web/app/$1').replaceWithEnd(fileName, tdf.info.dataName + '/'),
    };

    const { views, services, models } = tdf;
    const splitFiles = {};
    for (const modelName in models) {
        const path = `${templateFilePath.tdm}${modelName}.tdm`;
        splitFiles[path] = fs.existsSync(path);
    }
    for (const serviceName in services) {
        const path = `${templateFilePath.tbs}${serviceName}.tbs`;
        splitFiles[path] = fs.existsSync(path);
    }
    for (const viewName in views) {
        const path = `${templateFilePath.tfp}${viewName}.tfp`;
        splitFiles[path] = fs.existsSync(path);
    }
    res.isExists = Object.values(splitFiles).includes(true);
    this.end(res);
};

String.prototype.replaceWithEnd = function (searchValue, replaceValue) {
    const reg = new RegExp(`(.*)${searchValue}`);
    return this.replace(reg, `$1${replaceValue}`);
}