var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var Connection = require('Connection');
var Dao = require('Dao');

/**
 * 删除文件前的操作（修改所用数据表名）
 */
var PrevDeleteTDF = function () {
    Service.call(this);
    this.sqlInject.exclude = ['filePath'];
    this.xssInject.exclude = ['filePath'];
};

util.inherits(PrevDeleteTDF, Service);

module.exports = PrevDeleteTDF;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} req.filePath 文件路径
 * @param  {Object} res 服务响应对象
 */
PrevDeleteTDF.prototype.process = function (req, res) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');

    const dao = new Dao(this);
    const connection = new Connection(server.config.Database);
    const filePath = utils.getPath(req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, ''));
    const tdf = JSON.parse(fs.readFileSync(filePath, "utf-8"));
    const sqlList = [];

    for (const model in tdf.models) {
        const tableName = `${tdf.info.projName}_${model}`;
        const args = {
            oldTableName: tableName,
            tableName: `drop_${tableName}_${new Date().getTime()}`,
        };
        const sql = connection.getObjectDDL('TABLE_RENAME', args);
        sqlList.push(...sql);
    }

    dao.exeSqls(sqlList, 0, () => {
        this.end(res);
    });
}