var Service = require('Service');
var util = require('util');
var utils = require('utils');
var fs = require('fs');

/**
 * 导入文件
 */
var GetCode = function () {
    Service.call(this);
    this.sqlInject.exclude = ['filePath', 'data'];
    this.xssInject.exclude = ['filePath', 'data'];
};

util.inherits(GetCode, Service);

module.exports = GetCode;

/**
 * 处理服务请求
 * @param  {Object} req             服务请求对象
 * @param  {String} req.path 		文件路径
 * @param  {String} req.data		文件内容
 * @param  {Object} res             服务响应对象
 */
GetCode.prototype.process = function (req, res, cb) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');
    if (!req.data) return this.onLogicError(2, '请提供文件内容！');

    const filePath = utils.getPath(req.filePath);

    var self = this;
    fs.writeFile(filePath, req.data, function () {
        self.pipe(require('./transformTdf'), {
            filePath: req.filePath,
            mode: 'create'
        }, res, function (_req, _res) {
            if (_res.code == 0) self.end({ code: res.code });
            else return self.onLogicError(_res.code, _res.message);
        })
    });
};