var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');

/**
 * 获得数据模型
 */
var GetModels = function () {
    Service.call(this);
};

util.inherits(GetModels, Service);

module.exports = GetModels;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetModels.prototype.process = function (req, res) {
    var self = this;
    if (!req.tdfPath) {
        this.onLogicError(1, '请提供数据表单路径！');
        return;
    }
    var filePath = utils.getPath("/app/" + req.tdfPath);
    if (!fs.existsSync(filePath)) {
        this.onLogicError(2, '文件不存在！');
        return;
    }
    fs.readFile(filePath, "utf-8", function (err, data) {
        res.models = JSON.parse(data).models;
        self.end(res);
    });
};