var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TdfManagerBl = require('../../bll/tdfManagerBl')

/**
 * 获得文件内容
 */
var GetFileContent = function () {
  Service.call(this);
  //this.checkLogin = false;
  this.sqlInject.exclude = ['filePath'];
  this.xssInject.exclude = ['filePath'];
};

util.inherits(GetFileContent, Service);

module.exports = GetFileContent;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetFileContent.prototype.process = function (req, res) {
  if (!req.filePath) {
    this.onLogicError(1, '请提供文件路径！');
    return;
  }

  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  //****************************************************** */
  //TODO  这里只能访问tasgine目录有关的文件，不能随意访问其他文件
  //****************************************************** */
  var filePath = utils.getPath(req.filePath);
  if (!fs.existsSync(filePath)) {
    this.onLogicError(2, '文件不存在！');
    return;
  }
  var self = this;
  fs.readFile(filePath, "utf-8", function (err, data) {
    var tdfData = JSON.parse(data);
    res.data = data;
    res.isAccurate = tdfData && ('/app' + tdfData.info.filePath) == req.filePath;

    // 检查文件完整性
    self.checkFileIntegrity(filePath, tdfData, req, res, function (data) {
      res.data = JSON.stringify(data, null, "  ");
      res.defaultTFP = self.getDefaultTFP(req, res);
      res.defaultMListTFP = self.getDefaultMListTFP(req, res, data);
      self.end(res);
    });
  });
};

/**
 * 检查文件完整性，如果缺少相应数据，将使用默认数据
 * @param {String} filePath 文件路径
 * @param {Object} tdfData tdf数据
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 * @param {Function} cb 回调函数
 */
GetFileContent.prototype.checkFileIntegrity = function (filePath, tdfData, req, res, cb) {
  const self = this;
  const tdfManagerBl = new TdfManagerBl(this);
  const defaultTdf = tdfManagerBl.defaultTDF(tdfData.info);
  let check = true;

  // 添加PC端列表设计的选项卡code
  tdfData.tabs.pages.forEach((page, index) => {
    if(!page.code) {
      tdfData.tabs.pages[index].code = ('list' + index);
      check = false;
    }
  });

  // 添加移动端填报设计参数
  if (!tdfData.phoneEdit) {
    tdfData.phoneEdit = defaultTdf.phoneEdit;
    check = false;
  }

  // 添加移动端查询设计参数
  if (!tdfData.phoneTabs) {
    tdfData.phoneTabs = defaultTdf.phoneTabs;
    check = false;
  }

  // 添加移动端填报设计页面
  if (!tdfData.views.mEdit) {
    tdfData.views.mEdit = defaultTdf.views.mEdit;
    tdfData.views.mEdit.tfp = self.getDefaultMEditTFP(req, res, tdfData);
    check = false;
  }

  // 添加移动端查询设计页面
  if (!tdfData.views.mIndex) {
    tdfData.views.mIndex = defaultTdf.views.mIndex;
    tdfData.views.mIndex.tfp = self.getDefaultMIndexTFP(req, res, tdfData);
    tdfData.views.mList = defaultTdf.views.mList;
    tdfData.views.mList.tfp = self.getDefaultMListTFP(req, res, tdfData);
    check = false;
  }

  if (!check) {
    fs.writeFile(filePath, JSON.stringify(tdfData, null, "  "), function (err) {
      if (err) {
        res.code = 3;
        res.message = err.message;
        return self.end(res);
      }

      cb && cb(tdfData);
    });
  } else cb && cb(tdfData);
}

GetFileContent.prototype.getDefaultTFP = function (req, res) {
  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  const tdfManagerBl = new TdfManagerBl(this);
  const tdf = JSON.parse(res.data);

  if (!tdf.info.viewParam) {
    tdf.info.viewParam = {
      client: tdf.views.edit.tfp.client,
      mobileType: tdf.views.edit.tfp.mobileType,
      framework: tdf.views.edit.tfp.framework,
      positionType: tdf.views.edit.tfp.positionType,
      pageType: tdf.views.edit.tfp.pageType,
      bgColorMode: tdf.views.edit.tfp.bgColorMode,
      title: tdf.views.edit.tfp.title
    }
  }

  return tdfManagerBl.transformTFP({
    "type": "index",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "index",
      "info": tdf.info
    }),
    "items": tdf.items,
    "page": {
      "name": "",
      "param": {
        "autoFields": true
      },
      "query": [],
      "fields": []
    },
    "pageIndex": 0
  });
}

GetFileContent.prototype.getDefaultMEditTFP = function (req, res, tdfData) {
  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  const tdfManagerBl = new TdfManagerBl(this);
  const tdf = tdfData ? JSON.parse(JSON.stringify(tdfData)) : JSON.parse(res.data);

  if (!tdf.info.viewParam) {
    tdf.info.viewParam = {
      client: 'phone',
      mobileType: tdf.views.edit.tfp.mobileType,
      framework: tdf.views.edit.tfp.framework,
      positionType: tdf.views.edit.tfp.positionType,
      pageType: tdf.views.edit.tfp.pageType,
      bgColorMode: tdf.views.edit.tfp.bgColorMode,
      title: tdf.views.edit.tfp.title
    }
  }

  return tdfManagerBl.transformTFP({
    "type": "mEdit",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "mEdit",
      "info": tdf.info
    }),
    "items": tdf.items,
    "editTfp": tdf.views.edit.tfp,
    "phoneEdit": tdf.phoneEdit
  });
}

GetFileContent.prototype.getDefaultMIndexTFP = function (req, res, tdfData) {
  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  const tdfManagerBl = new TdfManagerBl(this);
  const tdf = tdfData ? JSON.parse(JSON.stringify(tdfData)) : JSON.parse(res.data);

  if (!tdf.info.viewParam) {
    tdf.info.viewParam = {
      client: 'phone',
      mobileType: tdf.views.edit.tfp.mobileType,
      framework: tdf.views.edit.tfp.framework,
      positionType: tdf.views.edit.tfp.positionType,
      pageType: tdf.views.edit.tfp.pageType,
      bgColorMode: tdf.views.edit.tfp.bgColorMode,
      title: tdf.views.edit.tfp.title
    }
  }
  tdf.info.viewParam.client = 'phone';

  return  tdfManagerBl.transformTFP({
    "type": "tab",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "tab",
      "info": tdf.info
    }),
    "tabs": tdf.phoneTabs,
  });
}

GetFileContent.prototype.getDefaultMListTFP = function (req, res, tdfData) {
  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  const tdfManagerBl = new TdfManagerBl(this);
  const tdf = tdfData ? JSON.parse(JSON.stringify(tdfData)) : JSON.parse(res.data);

  if (!tdf.info.viewParam) {
    tdf.info.viewParam = {
      client: 'phone',
      mobileType: tdf.views.edit.tfp.mobileType,
      framework: tdf.views.edit.tfp.framework,
      positionType: tdf.views.edit.tfp.positionType,
      pageType: tdf.views.edit.tfp.pageType,
      bgColorMode: tdf.views.edit.tfp.bgColorMode,
      title: tdf.views.edit.tfp.title
    }
  }
  tdf.info.viewParam.client = 'phone';
  return  tdfManagerBl.transformTFP({
    "type": "mList",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "mList",
      "info": tdf.info
    }),
    "items": tdf.items,
    "page": tdf.phoneTabs.pages[0],
  });
}