var Service = require('Service');
var util = require('util');
var utils = require('utils');
var fs = require('fs');
var TBSCompiler = require('TBSCompiler');
var TFPHandler = require('TFPHandler');
var Connection = require('Connection');

/**
 * 生成代码
 */
var GetCode = function () {
  Service.call(this);
};

util.inherits(GetCode, Service);

module.exports = GetCode;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetCode.prototype.process = function (req, res, cb) {
  // if (!req.srcMold) {
  //   this.onLogicError(1, '请提供模式！');
  //   return;
  // }

  // if (!req.srcType) {
  //   this.onLogicError(1, '请提供类型！');
  //   return;
  // }

  if (!req.filePath) {
    this.onLogicError(1, '请提供文件路径！');
    return;
  }

  req.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
  //****************************************************** */
  //TODO  这里只能访问tasgine目录有关的文件，不能随意访问其他文件
  //****************************************************** */
  var filePath = utils.getPath(req.filePath);
  if (!fs.existsSync(filePath)) {
    this.onLogicError(2, '文件不存在！');
    return;
  }

  var self = this;
  fs.readFile(filePath, "utf-8", function (err, data) {
    let dd = JSON.parse(data);
    if (!req.srcMold && !req.srcType) res.data = dd;
    if (!req.srcMold) req.srcMold = "view";
    if (!req.srcType) req.srcType = "index";
    res.text = "";
    if (req.srcMold == "view") {
      let options = {
        urlPath: req.filePath.replace('.tdf', 'views.' + req.srcType + '.tdf'),
        pageDataModel: dd.views[req.srcType].tfp,
        createFile: false
      };
      let tfpHandler = new TFPHandler();
      tfpHandler.compileTfp(options, function (err, html) {
        res.text += html;
        self.end(res);
      });
    }
    else if (req.srcMold == "service") {
      var compiler = new TBSCompiler();
      compiler.process({ tbs: dd.services[req.srcType].tbs, filePath: req.filePath }, { code: 0 }, function (res2) {
        res.text += res2.jsCode;
        self.end(res);
      });
    }
    else if (req.srcMold == "model") {
      var connection = new Connection(server.config.Database);
      var sss = connection.getCreateTableDDL(dd.models[req.srcType].tdm);
      for (let i = 0; i < sss.length; i++) {
        res.text += sss[i];
      }
      self.end(res);
    }
    else {
      self.end(res);
    }
  });

};