var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var uuid = require('node-uuid');
var TdfManagerBl = require('../../bll/tdfManagerBl');

/**
 * 创建
 */
var CreateTAD = function () {
  Service.call(this);
};

util.inherits(CreateTAD, Service);

module.exports = CreateTAD;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateTAD.prototype.process = function (req, res) {
  if (!req.path) {
    this.onLogicError(1, "请提供路径！");
    return;
  }
  if (!req.filename) {
    this.onLogicError(2, "请提供文件名称！");
    return;
  }
  if (req.filename.match(/[^\w]/g)) {
    this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  let pageType = "page";
  if (req.pageType == "dialog") pageType = "dialog";
  if (req.pageType == "dialog") {
    if (!req.dialogWidth) {
      this.onLogicError(9, "请提供窗口宽度！");
      return;
    }
    req.dialogWidth += "";
    if (!req.dialogHeight) {
      this.onLogicError(10, "请提供窗口高度！");
      return;
    }
    req.dialogHeight += "";
  }
  let positionType = "float";
  if (req.positionType) positionType = req.positionType;
  let bgColorMode = "light";
  if (req.bgColorMode == "dark") bgColorMode = "dark";

  if (!fs.existsSync(utils.getPath(req.path))) {
    fs.mkdirSync(utils.getPath(req.path));
  }

  let fileName = req.filename.endWith(".tdf") ? req.filename : req.filename + ".tdf";
  let filePath = utils.getPath(req.path + "/" + fileName);

  if (fs.existsSync(filePath)) {
    this.onLogicError(11, "文件已存在！");
    return;
  }

  let mobileType = "H5";
  if (req.client == "taskmsg") {
    mobileType = "TaskMsg";
    req.client = "phone";
  } else if (req.client == "dingding") {
    mobileType = "dingding";
    req.client = "phone";
  } else if (req.client == "workweixin") {
    mobileType = "workweixin";
    req.client = "phone";
  }

  var self = this;
  var tdfManagerBl = new TdfManagerBl(this);
  var tdf = tdfManagerBl.defaultTDF({
    "filePath": req.path + "/" + fileName,
    "viewParam": {
      client: req.client,
      mobileType: mobileType,
      framework: "tfp",
      positionType: positionType,
      pageType: pageType,
      bgColorMode: bgColorMode,
      title: req.title
    }
  });
  tdf.items = tdfManagerBl.defaultItems();

  tdf.views.edit.tfp = tdfManagerBl.transformTFP({
    "type": "edit",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "edit",
      "info": tdf.info
    }),
    "items": tdf.items
  });

  tdf.views.index.tfp = tdfManagerBl.transformTFP({
    "type": "tab",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "tab",
      "info": tdf.info
    }),
    "tabs": tdf.tabs
  });

  tdf.views.list.tfp = tdfManagerBl.transformTFP({
    "type": "index",
    "info": tdf.info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "index",
      "info": tdf.info
    }),
    "info": tdf.info,
    "items": tdf.items,
    "page": tdf.tabs.pages[0],
    "pageIndex": 0
  });


  tdf.services.save.tbs = tdfManagerBl.transformTBS({
    "type": "save",
    // "tbs": tdfManagerBl.defaultTBS({
    //   "type": "save",
    //   "info": tdf.info
    // }),
    "info": tdf.info,
    "items": tdf.items
  });
  tdf.services.get.tbs = tdfManagerBl.transformTBS({
    "type": "get",
    // "tbs": tdfManagerBl.defaultTBS({
    //   "type": "get",
    //   "info": tdf.info
    // }),
    "info": tdf.info,
    "items": tdf.items
  });
  tdf.services.list.tbs = tdfManagerBl.transformTBS({
    "type": "list",
    // "tbs": tdfManagerBl.defaultTBS({
    //   "type": "list",
    //   "info": tdf.info
    // }),
    "info": tdf.info,
    "items": tdf.items,
    "page": tdf.tabs.pages[0],
    "pageIndex": 0
  });
  tdf.services.remove.tbs = tdfManagerBl.transformTBS({
    "type": "remove",
    // "tbs": tdfManagerBl.defaultTBS({
    //   "type": "remove",
    //   "info": tdf.info
    // }),
    "info": tdf.info,
    "items": tdf.items
  });

  const info = JSON.parse(JSON.stringify(tdf.info));
  info.viewParam.client = 'phone';
  tdf.views.mEdit.tfp = tdfManagerBl.transformTFP({
    "type": "mEdit",
    "info": info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "mEdit",
      "info": info
    }),
    "items": tdf.items,
    "editTfp": tdf.views.edit.tfp,
    "phoneEdit": tdf.phoneEdit
  });
  
  tdf.views.mIndex.tfp = tdfManagerBl.transformTFP({
    "type": "tab",
    "info": info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "tab",
      "info": info
    }),
    "tabs": tdf.phoneTabs,
  });

  tdf.views.mList.tfp = tdfManagerBl.transformTFP({
    "type": "mList",
    "info": info,
    "tfp": tdfManagerBl.defaultTFP({
      "type": "mList",
      "info": info
    }),
    "items": tdf.items,
    "page": tdf.phoneTabs.pages[0],
  });

  tdf.services.mList.tbs = tdfManagerBl.transformTBS({
    "type": "list",
    // "tbs": tdfManagerBl.defaultTBS({
    //   "type": "list",
    //   "info": tdf.info
    // }),
    "info": info,
    "items": tdf.items,
    "page": tdf.phoneTabs.pages[0],
    "pageIndex": 0
  });

  tdfManagerBl.transformTDM({
    "mode": "create",
    "tdm": tdfManagerBl.defaultTDM({
      "info": tdf.info
    }),
    "fields": tdf.items.main
  }, function (json) {
    tdf.models[tdf.info.tableName].tdm = json;

    fs.writeFileSync(filePath, JSON.stringify(tdf, null, "  "));

    self.end(res);
  });
};





















// var tfp = {
//   client: req.client,
//   mobileType: mobileType,
//   framework: "tfp",
//   positionType: positionType,
//   pageType: pageType,
//   bgColorMode: bgColorMode,
//   title: req.title,
//   type: "Page"
// };
// // if (req.pageType == "dialog") {
// //   tfp.width = req.dialogWidth + "";
// //   tfp.width = tfp.width.indexOf("px") > 0 ? tfp.width : tfp.width + "px";
// //   tfp.height = req.dialogHeight + "";
// //   tfp.height = tfp.height.indexOf("px") > 0 ? tfp.height : tfp.height + "px";
// //   tfp.components.push({
// //     id: "panel_bottom",
// //     type: "Panel",
// //     styles: {
// //       "left": "0",
// //       "height": "50px",
// //       "right": "0",
// //       "bottom": "0",
// //       "position": "absolute",
// //       "overflow": "auto"
// //     },
// //     components: [{
// //       id: "button_cancel",
// //       type: "Button",
// //       buttonType: "default",
// //       value: "取消",
// //       theme: "rect",
// //       onClick: "tfp.closeCurDialog()",
// //       styles: {
// //         "float": "right",
// //         "margin-top": "10px",
// //         "margin-right": "20px",
// //         "cursor": "pointer",
// //         "text-align": "center"
// //       }
// //     }, {
// //       id: "button_submit",
// //       type: "Button",
// //       buttonType: "primary",
// //       value: "确定",
// //       theme: "rect",
// //       styles: {
// //         "float": "right",
// //         "margin-top": "10px",
// //         "margin-right": "10px",
// //         "cursor": "pointer",
// //         "text-align": "center"
// //       },
// //       onClick: "form1.submit()"
// //     }]
// //   });
// // }






// var tfpEdit = tdfManagerBl.transformTFP({
//   "type": "edit",
//   "tfp": tfp
// })

// var tdf = {
//   "framework": "tdf",
//   "dataId": uuid.v1().replace(/-/g, ''),
//   "dataName": req.title,
//   "createTime": new Date,
//   "views": {
//     "index": {
//       "type": "index",
//       "tdf": {},
//       "tfp": {}
//     },
//     "edit": {
//       "type": "edit",
//       "tdf": {},
//       "tfp": tfpEdit
//     }
//   },
//   "services": {
//     "save": {
//       "type": "save",
//       "tdf": {},
//       "tbs": {}
//     },
//     "get": {
//       "type": "get",
//       "tdf": {},
//       "tbs": {}
//     },
//     "list": {
//       "type": "list",
//       "tdf": {},
//       "tbs": {}
//     },
//     "remove": {
//       "type": "remove",
//       "tdf": {},
//       "tbs": {}
//     }
//   },
//   "models": {}
// }
