var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var TBSCompiler = require('TBSCompiler');
var PackageManager = require('../proj/packageManager.js');

/**
 * 创建数据导入服务
 */
var CreateImportTBS = function() { 
  Service.call(this);
  this.pkManager = new PackageManager();
};

util.inherits(CreateImportTBS, Service);

module.exports = CreateImportTBS;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateImportTBS.prototype.process =  function(req, res) {
  if(!req.path) {
    this.onLogicError(1, '请提供服务路径！');
    return;
  }
  if(!req.type) {
    this.onLogicError(2, '请提供服务类型！');
    return;
  }
  if(!req.model) {
    this.onLogicError(3, '请提供数据模型名称！');
    return;
  }
  
  let modelName = "";
  let modelPath = "";
  if(req.model.indexOf("/")<0) {
    modelName = req.model;
    modelPath = "/app/"+req.proj+"/model/"+req.model+".tdm";
  } else {
    modelName = req.model.substr(req.model.lastIndexOf("/")+1);
    modelName = modelName.substr(0, modelName.lastIndexOf("."));
    modelPath = "/app/"+req.model;
  }

  if(!req.fields) {
    this.onLogicError(4, '请提供字段信息！');
    return;
  }
  if(!req.fileCode) {
    this.onLogicError(4, '请提供文件代码参数名！');
    return;
  }
  let titleRowIndex = 1;
  if(req.titleRowIndex) titleRowIndex = parseInt(req.titleRowIndex);
  let importType = 1;
  if(req.importType) importType = parseInt(req.importType);
  var filePath = utils.getPath(req.path);
  if(fs.existsSync(filePath)) {
    this.onLogicError(5, '文件已存在！');
    return;
  }
  let tbsName = req.path.substr(req.path.lastIndexOf("/")+1);
  tbsName = tbsName.substr(0, tbsName.lastIndexOf("."));
  tbsName = tbsName.substr(0, 1).toUpperCase()+tbsName.substr(1);
  var tbs = {
    name: tbsName,
    comment: "导入"+modelName+"数据",
    reqArgs: [{
      name: req.fileCode,
      type: "string",
      notNull: true
    }],
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      },{
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [{ 
        category: "import-export",
        type: "excelImport",
        model: {
          name: modelName,
          path: modelPath
        },
        fields: req.fields,
        titleRowIndex: titleRowIndex,
        importType: importType,
        fileCode: req.fileCode,
        cbArg: "ret", 
        statements: [{
          category: "common",
          type: "end"
        }]
      }]
    }]
  };

  if(req.comment) tbs.comment = req.comment;

  //更新项目包信息
  var self = this;
  this.pkManager.setServiceInfo(req, req.path, tbs, function() {
    if(req.type=="tbs") {
      fs.writeFileSync(filePath, JSON.stringify(tbs, null, "\t"));
      self.end(res);
    } else {
      var compiler = new TBSCompiler();
      compiler.process({tbs: tbs}, {code: 0}, function(res2) {
        if(res2.code!=0) {
          self.onLogicError(6, "TBS文件编译失败："+res2.message);
          return;
        }
        fs.writeFileSync(filePath, res2.jsCode);
        self.end(res);
      });
    }
  });
};