var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var TBSCompiler = require('TBSCompiler');
var PackageManager = require('../proj/packageManager.js');

/**
 * 创建数据删除服务
 */
var CreateDataDeleteTBS = function() { 
  Service.call(this);
  this.sqlInject = {
    check: false   
  };
  this.pkManager = new PackageManager();
};

util.inherits(CreateDataDeleteTBS, Service);

module.exports = CreateDataDeleteTBS;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataDeleteTBS.prototype.process =  function(req, res) {
  if(!req.path) {
    this.onLogicError(1, '请提供服务路径！');
    return;
  }
  if(!req.type) {
    this.onLogicError(2, '请提供服务类型！');
    return;
  }
  if(!req.model) {
    this.onLogicError(3, '请提供数据模型名称！');
    return;
  }
  let modelName = "";
  let modelPath = "";
  if(req.model.indexOf("/")<0) {
    modelName = req.model;
    modelPath = "/app/"+req.proj+"/model/"+req.model+".tdm";
  } else {
    modelName = req.model.substr(req.model.lastIndexOf("/")+1);
    modelName = modelName.substr(0, modelName.lastIndexOf("."));
    modelPath = "/app/"+req.model;
  }
  if(!req.where) {
    this.onLogicError(5, '请设置修改条件！');
    return;
  }
  var filePath = utils.getPath(req.path);
  if(fs.existsSync(filePath)) {
    this.onLogicError(6, '文件已存在！');
    return;
  }
  //加载数据模型
  let dataModel = server.loadModule(modelPath);
  var reqArgs = [];
  //解析where条件里的请求参数
  let whereTmp = req.where;
  var patt = new RegExp("{req.\\S+}", "g");
  var result = patt.exec(whereTmp);
  while (result != null)  {
    let argWhere = result[0];
    argWhere = argWhere.substring(5, argWhere.length-1);
    let isExists = false;
    for(var i=0;i<reqArgs.length;i++) {
      if(reqArgs[i].name==argWhere) {
        isExists = true;
        break;
      }
    }
    if(!isExists) {
      let reqArg = {
        name: argWhere,
        type: "string",
        notNull: true
      };
      let field = dataModel.fields[reqArg.name];
      //如果查询参数是模型的字段，则根据字段信息设置查询参数的备注和类型
      if(field) {
        reqArg.comment = field.comment;
        reqArg.type = field.type;
      }
      reqArgs.push(reqArg);
    }
    whereTmp = whereTmp.replace("{req."+argWhere+"}", "");
    result = patt.exec(whereTmp);
  }
  let tbsName = req.path.substr(req.path.lastIndexOf("/")+1);
  tbsName = tbsName.substr(0, tbsName.lastIndexOf("."));
  tbsName = tbsName.substr(0, 1).toUpperCase()+tbsName.substr(1);
  var tbs = {
    name: tbsName,
    comment: "删除"+modelName,
    reqArgs: reqArgs,
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      },{
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [{ 
        category: "db",
        type: "delete",
        model: {
          name: modelName,
          path: modelPath
        },
        where: req.where,
        statements: [{
          category: "common",
          type: "end"
        }]
      }]
    }]
  };

  if(req.comment) tbs.comment = req.comment;

  //更新项目包信息
  var self = this;
  this.pkManager.setServiceInfo(req, req.path, tbs, function() {
    if(req.type=="tbs") {
      fs.writeFileSync(filePath, JSON.stringify(tbs, null, "\t"));
      self.end(res);
    } else {
      var compiler = new TBSCompiler();
      compiler.process({tbs: tbs}, {code: 0}, function(res2) {
        if(res2.code!=0) {
          self.onLogicError(6, "TBS文件编译失败："+res2.message);
          return;
        }
        fs.writeFileSync(filePath, res2.jsCode);
        self.end(res);
      });
    }
  });
};