var Service = require('Service');
var util = require('util');
var utils = require('utils');
//var TBSCompiler = require('../../../../sersrc/TBSCompiler');
var TBSCompiler = require('TBSCompiler');

/**
 * 编译TBS文件
 */
var Compile = function () {
  Service.call(this);
  this.sqlInject = {
    check: false   
  };
};

util.inherits(Compile, Service);

module.exports = Compile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Compile.prototype.process = function (req, res, cb) {
  if (!req.filePath && !req.tbs) {
    this.onLogicError(1, '请提供TBS服务信息！');
    return;
  }
  var self = this;
  var compiler = new TBSCompiler();
  compiler.process({ tbs: req.tbs, filePath: req.filePath }, { code: 0 }, function (res2) {
    if (res2.code != 0) {
      self.onLogicError(2, "编译失败：" + res2.message);
      return;
    }
    self.end(res2);
  });
};