var Service = require('Service');
var utils = require('utils');
var util = require('util');
var Dao = require('Dao');
var fs = require('fs');
const path = require('path');
const { requestOperationSync } = server.loadModule("/app/dev/service/requestUtils");

var GetSysInfo = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(GetSysInfo, Service);

module.exports = GetSysInfo;

/**
 * 安装许可证书
 * @param  {Object} req 服务请求对象
 * @param  {String} req.lc 许可证书
 * @param  {Object} res 服务响应对象
 */
GetSysInfo.prototype.process = async function (req, res) {
    try {
        const { lc } = req;

        // 在根目录将许可证书写入lc.dat文件
        const lcPath = path.join(process.cwd(), 'lc.dat');
        fs.writeFileSync(lcPath, lc);

        this.end(res);
    } catch (error) {
        this.onError(error);
    }
};