var Service = require('Service');
var utils = require('utils');
var util = require('util');
var Dao = require('Dao');
var fs = require('fs');
const path = require('path');
const { requestOperationSync } = server.loadModule("/app/dev/service/requestUtils");

var GetSysInfo = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(GetSysInfo, Service);

module.exports = GetSysInfo;

/**
 * 获取组织信息
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetSysInfo.prototype.process = async function (req, res) {
    try {
        const dao = new Dao(this);
        const lcInfo = server.lcManager.getLcInfo();

        const [org] = await dao.executeSync('select * from sys_org where code=?', [server.config.OrgCode]);
        const siPath = path.join(process.cwd(), 'si.dat');
        const lcPath = path.join(process.cwd(), 'lc.dat');
        const si = fs.existsSync(siPath) ? fs.readFileSync(siPath, 'utf8') : null;
        const lc = fs.existsSync(lcPath) ? fs.readFileSync(lcPath, 'utf8') : null;

        const licenseRes = await requestOperationSync(this, {
            orgCode: server.config.OrgCode,
            service: 'dp/service/organize/getLicenseInfo',
        });
        if(licenseRes.code !=0) return this.onLogicError(1, licenseRes.message);

        res.data = {
            serverId: server.id,
            serverName: server.name,
            serverEdition: server.edition,
            serverVersion: server.version,
            serverPath: server.serverPath,
            serverStartTime: server.startTime,
            orgCode: server.config.OrgCode,
            orgName: org.name,
            authKey: org.auth_key,
            orgCreateTime: org.createtime,
            orgLastUpdate: org.last_update,
            orgUserCountAuth: lcInfo.userCount,
            orgAuthEndDate: lcInfo.timeLimit,
            si: si,
            lc: lc,
            license: licenseRes.license,
        };
        this.end(res);
    } catch (error) {
        this.onError(error);
    }
};