var util = require('util');
var Service = require('Service');
var utils = require('utils');
const { requestOperation } = server.loadModule("/app/dev/service/requestUtils");

var ApplyLicense = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(ApplyLicense, Service);

module.exports = ApplyLicense;

/**
 * 申请系统授权
 * @param {Object} req 服务请求对象
 * @param {String} req.systemCode 系统代码
 * @param {Number} req.userCount 用户数
 * @param {String} req.authorize 授权时间 授权模式+月数
 * @param {String} req.si 系统信息
 * @param {String} req.mobile 用户编号
 * @param {String} req.svgcaptchaUUID 用户编号
 * @param {String} req.svgcaptcha 用户编号
 * @param {String} req.mobileCode 用户编号
 * @param {String} [req.remarks] 备注
 * @param {Object} res 服务响应对象
 */
ApplyLicense.prototype.process = function (req, res) {
    requestOperation(this, {
        ...req, service: 'dp/service/license/apply',
    }, (_res) => { this.end(_res) });
};