const Service = require('Service');
const util = require('util');
const utils = require('utils');
const Dao = require('Dao');

const SelectApps = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(SelectApps, Service);

module.exports = SelectApps;

/**
 * 获取选择商品列表
 * @param  {object} req 服务请求对象
 * @param  {String} keyword 搜索
 * @param  {object} res 服务响应对象
 */
SelectApps.prototype.process = async function (req, res) {
    try {
        const { keyword } = req;

        const itemDao = new Dao(this);
        itemDao.model = server.loadModule('/app/sys/model/vorg_app.json');

        const args = {
            fields: 'app_id as id,app_code as code,app_name as name',
            where: 'status=0 and org_id=1',
            params: []
        }
        if (keyword) {
            args.where += ' and (app_code like ? or app_name like ?)';
            args.params.push(`%${keyword}%`, `%${keyword}%`);
        }

        res.data = await itemDao.queryDataPageSync(req, args);
        this.end(res);
    } catch (error) {
        this.onError(error);
    }
}