const Service = require('Service');
const util = require('util');
const utils = require('utils');
const Dao = require('Dao');

const CheckApp = function () {
    Service.call(this);
};

util.inherits(CheckApp, Service);

module.exports = CheckApp;

/**
 * 校验点击的应用
 * @param  {object} req 服务请求对象
 * @param  {object} req.appId 应用编号
 * @param  {object} res 服务响应对象
 */
CheckApp.prototype.process = function (req, res) {
    const self = this;
    const { appId } = req;

    req.session.cache.get('app', appId, function (err, app) {
        if (err) return self.onError(err);
        if (app.expiration_time) {
            const expirationTime = new Date(app.expiration_time);
            const now = new Date();
            res.success = expirationTime.getTime() - now.getTime() > 0;
        } else res.success = true;
        self.end(res);
    });
}