const Service = require('Service');
const util = require('util');
const utils = require('utils');
const Dao = require('Dao');

const ChangeAppStatus = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(ChangeAppStatus, Service);

module.exports = ChangeAppStatus;

/**
 * 校验点击的应用
 * @param  {object} req 服务请求对象
 * @param  {String} req.orgCode 应用编号
 * @param  {Number[]} req.appIds 应用编号列表
 * @param  {Number} req.status 状态
 * @param  {object} res 服务响应对象
 */
ChangeAppStatus.prototype.process = async function (req, res) {
    const { orgCode, appIds, status } = req;

    if (!orgCode) return this.onLogicError(4, '请提供组织代码！');
    if (!Array.isArray(appIds)) return this.onLogicError(4, '请提供应用列表');
    if (!['0', '1'].includes(status.toString())) return this.onLogicError(4, '请提供正确的状态！');

    const dao = new Dao(this);

    // 修改应用状态
    const [orgInfo] = await dao.executeSync(
        `select * from sys_org where code=?`,
        [orgCode]
    );
    if (!orgCode) return this.onLogicError(4, '请提供组织代码！');

    // 修改应用状态
    await dao.executeSync(
        `update sys_org_app set status=? where org_id=? and app_id in (?)`,
        [status, orgInfo.id, appIds]
    );

    this.end(res);

    // 结束服务后重新加载当前组织缓存
    server.cache.loadOrgData(orgInfo.id, function (errCache) {
        if (errCache) return logger.log(errCache);
    });
}