exports.getMarketUrl = getMarketUrl;
exports.getMarketUrlList = getMarketUrlList;
exports.getMarketServiceUrl = getMarketServiceUrl;
exports.getMarketDownloadUrl = getMarketDownloadUrl;
exports.getMarketTcpAddress = getMarketTcpAddress;
exports.requestMarket = requestMarket;
exports.requestMarketSync = requestMarketSync;

exports.getBusinessUrl = getBusinessUrl;
exports.getBusinessServiceUrl = getBusinessServiceUrl;
exports.getBusinessDownloadUrl = getBusinessDownloadUrl;
exports.requestBusiness = requestBusiness;
exports.requestBusinessSync = requestBusinessSync;

exports.getOperationUrl = getOperationUrl;
exports.getOperationServiceUrl = getOperationServiceUrl;
exports.getOperationDownloadUrl = getOperationDownloadUrl;
exports.requestOperation = requestOperation;
exports.requestOperationSync = requestOperationSync;

exports.request = request;
exports.requestSync = requestSync;

// 获取请求配置文件
const requestConfig = require('./requestConfig.json');

/***************************************************************************************
 * 应用市场
 **************************************************************************************/

/**
 * 获取应用市场地址
 * @param {Number} [index] 地址下标
 * @returns {String}
 */
function getMarketUrl(index = 0) {
    if (!Array.isArray(requestConfig.market)) return null;
    return requestConfig.market[index].url;
}

/**
 * 获取应用市场地址列表
 * @returns {String}
 */
function getMarketUrlList() {
    if (!Array.isArray(requestConfig.market)) return null;
    return requestConfig.market.map(item => {
        return { name: item.name, url: item.url }
    });
}

/**
 * 获取应用市场服务地址
 * @returns {String}
 */
function getMarketServiceUrl() {
    return getMarketUrl() + '/Service';
}

/**
 * 获取应用市场下载地址
 * @returns {String}
 */
function getMarketDownloadUrl() {
    return getMarketUrl() + '/Download';
}

/**
 * 获取应用市场tcp地址端口
 * @param {Number} [index] 地址下标
 * @returns {Object}
 */
function getMarketTcpAddress(index = 0) {
    if (!Array.isArray(requestConfig.market)) return null;
    return requestConfig.market[index].tcp;
}

/**
 * 异步请求应用市场
 * @param {Object} service 服务对象
 * @param {Object} req 请求参数
 * @param {Function} cb 回调函数
 */
function requestMarket(service, req, cb) {
    const {
        sessionId, remoteAddress, remotePort, _requestId, _requestTime, servicePath,
        socket, session, _auth_ts, _auth_org, _auth_data, ...args
    } = req;
    service.sendHttpRequest({
        urlPath: getMarketServiceUrl(),
        method: 'post',
        json: true,
        headers: {
            'Content-Type': 'application/json',
        },
        postdata: getRequestArgs(req)
    }, function (reqHttp, resHttp, errHttp, retHttp) {
        errHttp = errHttp ? JSON.parse(errHttp) : errHttp;
        retHttp = retHttp ? JSON.parse(retHttp) : retHttp;
        cb(errHttp || retHttp);
    });
};

/**
 * 同步请求应用市场
 * @param {Object} service 服务对象
 * @param {Object} req 请求参数
 */
function requestMarketSync(service, req) {
    return new Promise((resolve, reject) => {
        requestMarket(service, req, resolve);
    });
};

/***************************************************************************************
 * 开发者平台
 **************************************************************************************/

/**
 * 获取开发者平台地址
 * @returns {String}
 */
function getBusinessUrl(index = 0) {
    if (!Array.isArray(requestConfig.business)) return null;
    return requestConfig.business[index].url;
}

/**
 * 获取开发者平台服务地址
 * @returns {String}
 */
function getBusinessServiceUrl() {
    return getBusinessUrl() + '/Service';
}

/**
 * 获取开发者平台下载地址
 * @returns {String}
 */
function getBusinessDownloadUrl() {
    return getBusinessUrl() + '/Download';
}

/**
 * 异步请求开发者平台
 * @param {Object} service 服务对象
 * @param {Object} req 请求参数
 * @param {Function} cb 回调函数
 */
function requestBusiness(service, req, cb) {
    const { sessionId, remoteAddress, remotePort, _requestId, _requestTime, servicePath, socket, session, ...args } = req;
    service.sendHttpRequest({
        urlPath: getBusinessServiceUrl(),
        method: 'post',
        json: true,
        headers: {
            'Content-Type': 'application/json',
        },
        postdata: getRequestArgs(req)
    }, function (reqHttp, resHttp, errHttp, retHttp) {
        errHttp = errHttp ? JSON.parse(errHttp) : errHttp;
        retHttp = retHttp ? JSON.parse(retHttp) : retHttp;
        cb(errHttp || retHttp);
    });
};

/**
 * 同步请求开发者平台
 * @param {Object} service 服务对象
 * @param {Object} req 请求参数
 */
function requestBusinessSync(service, req) {
    return new Promise((resolve, reject) => {
        requestMarket(service, req, resolve);
    });
};

/***************************************************************************************
 * 运营平台
 **************************************************************************************/

/**
 * 获取运营平台地址
 * @param {Number} [index] 地址下标
 * @returns {String}
 */
function getOperationUrl(index = 0) {
    if (!Array.isArray(requestConfig.operation)) return null;
    return requestConfig.operation[index].url;
}

/**
 * 获取运营平台服务地址
 * @returns {String}
 */
function getOperationServiceUrl() {
    return getOperationUrl() + '/Service';
}

/**
 * 获取运营平台下载地址
 * @returns {String}
 */
function getOperationDownloadUrl() {
    return getOperationUrl() + '/Download';
}

/**
 * 异步请求运营平台
 * @param {Object} service 服务对象
 * @param {Object} req 请求参数
 * @param {Function} cb 回调函数
 */
function requestOperation(service, req, cb) {
    service.sendHttpRequest({
        urlPath: getOperationServiceUrl(),
        method: 'post',
        json: true,
        headers: {
            'Content-Type': 'application/json',
        },
        postdata: getRequestArgs(req)
    }, function (reqHttp, resHttp, errHttp, retHttp) {
        errHttp = errHttp ? JSON.parse(errHttp) : errHttp;
        retHttp = retHttp ? JSON.parse(retHttp) : retHttp;
        cb(errHttp || retHttp);
    });
};

/**
 * 同步请求运营平台
 * @param {Object} service 服务对象
 * @param {Object} req 请求参数
 */
function requestOperationSync(service, req) {
    return new Promise((resolve, reject) => {
        requestMarket(service, req, resolve);
    });
};

function getRequestArgs(req) {
    const {
        sessionId, remoteAddress, remotePort, servicePath, socket, session,
        _requestId, _requestTime, _auth_ts, _auth_org, _auth_data,
        serviceProjName, ...args
    } = req;
    return args;
}

/***************************************************************************************
 * 公共方法
 **************************************************************************************/

/**
 * 异步请求
 * @param {Object} service 服务对象
 * @param {String} url 请求地址
 * @param {Object} req 请求参数
 * @param {Function} cb 回调函数
 */
function request(service, url, req, cb) {
    service.sendHttpRequest({
        urlPath: url,
        method: 'post',
        json: true,
        headers: {
            'Content-Type': 'application/json',
        },
        postdata: getRequestArgs(req)
    }, function (reqHttp, resHttp, errHttp, retHttp) {
        errHttp = errHttp ? JSON.parse(errHttp) : errHttp;
        retHttp = retHttp ? JSON.parse(retHttp) : retHttp;
        cb(errHttp || retHttp);
    });
};

/**
 * 同步请求运营平台
 * @param {Object} service 服务对象
 * @param {String} url 请求地址
 * @param {Object} req 请求参数
 */
function requestSync(service, url, req) {
    return new Promise((resolve, reject) => {
        request(service, url, req, resolve);
    });
};