var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TFPHandler = require('TFPHandler');
var TBSCompiler = require('TBSCompiler');
var TESCompiler = require('TESCompiler');
var UglifyJS = server.loadModule('/node_modules/uglify-js/tools/node.js');

/**
 * 编译项目
 */
var Compiler = function () {
  Service.call(this);
  //rootPath encryptConfig
  //compress encrypt
  //tmp_files{ext src | dist}
};

util.inherits(Compiler, Service);

module.exports = Compiler;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Compiler.prototype.process = function (req, res, cb) {
  //proj type(html service model tdf all) src 

  var self = this;
  self.rootPath = utils.getPath("");
  self.compress = true;
  self.encrypt = false;

  //前台
  if (req.type == "html" || req.type == "web") {
    this.tmp_files = [];
    this.tmp_index = 0;
    this.getFileList("html", req.src);

    this.compileHtml(function () {
      if (cb) return cb(res);
      self.end(res);
    });
    return;
  }
  //后台
  else if (req.type == "service") {
    this.tmp_files = [];
    this.tmp_index = 0;
    this.getFileList("service", req.src);

    this.compileService(function () {
      if (cb) return cb(res);
      self.end(res);
    });
    return;
  }
  //模型
  else if (req.type == "model") {
    this.tmp_files = [];
    this.tmp_index = 0;
    this.getFileList("model", req.src);

    this.compileModel(function () {
      if (cb) return cb(res);
      self.end(res);
    });
    return;
  }
  //
  else if (req.type == "tdf") {
    self.tmp_files = [];
    self.tmp_index = 0;
    self.getFileList("service", req.src);
    self.compileService(function () {
      self.tmp_files = [];
      self.tmp_index = 0;
      self.getFileList("model", req.src);
      self.compileModel(function () {
        self.tmp_files = [];
        self.tmp_index = 0;
        self.getFileList("html", req.src);
        self.compileHtml(function () {
          if (cb) return cb(res);
          self.end(res);
        });
      });
    });
    return;
  }
  else if (req.type == "all") {
    var bSrc = req.src;
    var fSrc = "/web" + req.src;
    self.tmp_files = [];
    self.tmp_index = 0;
    self.getFileList("service", bSrc);
    self.compileService(function () {
      self.tmp_files = [];
      self.tmp_index = 0;
      self.getFileList("model", bSrc);
      self.compileModel(function () {
        self.tmp_files = [];
        self.tmp_index = 0;
        self.getFileList("html", bSrc);
        self.compileHtml(function () {

          self.tmp_files = [];
          self.tmp_index = 0;
          self.getFileList("html", fSrc);
          self.compileHtml(function () {
            if (cb) return cb(res);
            self.end(res);
          });

        });
      });
    });
    return;
  }
  else {
    this.onLogicError(1, '不支持编译该类型！' + req.src, req, res);
    return;
  }
};

/**
 * 编译后台
 * tmp_files:{ext,path,src,dist}
 * @param {*} cb 
 * @returns 
 */
Compiler.prototype.compileService = function (cb) {
  //files:{src,ext,dist,compress encrypt}
  var self = this;
  if (self.tmp_files.length == self.tmp_index) {
    cb();
  }
  else {
    var file = self.tmp_files[self.tmp_index];
    let srcContent = fs.readFileSync(file.path, 'utf8');
    let jsCode = "";
    let src = "";
    let dist = "";
    if (file.ext == ".tbs") {
      // if (!self.tbsCompiler) self.tbsCompiler = new TBSCompiler();
      const tbsCompiler = new TBSCompiler();
      try {
        src = file.src;
        dist = src.replace("/app/", "/dist/") + ".js";
        tbsCompiler.tbs = JSON.parse(srcContent);
        tbsCompiler.tbs.srcUrl = src;

        jsCode = tbsCompiler.getTbsCode();

        self.compileServiceFile({
          "compress": self.compress,
          "encrypt": self.encrypt,
          "src": src,
          "dist": dist
        }, jsCode);
      } catch (e) {
        logger.log(e);
        return;
      }
    }
    else if (file.ext == ".tdf") {
      // if (!self.tbsCompiler) self.tbsCompiler = new TBSCompiler();
      const tbsCompiler = new TBSCompiler();
      try {
        let d = JSON.parse(srcContent);
        for (var srcType in d.services) {
          src = file.src.replace(".tdf", ".service." + srcType + ".tdf");
          dist = src.replace("/app/", "/dist/") + ".js";
          tbsCompiler.tbs = d.services[srcType].tbs;
          tbsCompiler.tbs.srcUrl = src;

          jsCode = tbsCompiler.getTbsCode();

          self.compileServiceFile({
            "compress": self.compress,
            "encrypt": self.encrypt,
            "src": src,
            "dist": dist
          }, jsCode);
        }
      } catch (e) {
        logger.log(e);
        return;
      }
    }
    else {
      jsCode = srcContent;
      src = file.src;
      dist = src.replace("/app/", "/dist/");
      self.compileServiceFile({
        "compress": self.compress,
        "encrypt": self.encrypt,
        "src": src,
        "dist": dist
      }, jsCode);
    }

    self.tmp_index++;
    self.compileService(cb);
  }
};

/**
 * 编译模型
 * tmp_files:{ext,path,src,dist}
 * @param {*} cb 
 * @returns 
 */
Compiler.prototype.compileHtml = function (cb) {
  //files:{src,ext,dist,compress encrypt}
  var self = this;
  if (self.tmp_files.length == self.tmp_index) {
    cb();
  }
  else {
    var file = self.tmp_files[self.tmp_index];

    if (file.ext == ".tfp") {
      let srcContent = fs.readFileSync(file.path, 'utf8');
      let htmlCode = "";
      let src = "";
      let dist = "";
      try {
        src = file.src;
        dist = src.replace("/app/", "/dist/") + ".html";
        htmlCode = JSON.parse(srcContent);

        self.compileHtmlFile({
          "ext": ".tfp",
          "src": src,
          "dist": dist
        }, htmlCode, function () {
          self.tmp_index++;
          self.compileHtml(cb);
        });
      } catch (e) {
        logger.log(e);
        return;
      }
    }
    else if (file.ext == ".tdf") {
      let srcContent = fs.readFileSync(file.path, 'utf8');
      let htmlCode = "";
      let src = "";
      let dist = "";
      try {
        this.tmp_view_files = [];
        this.tmp_view_index = 0;

        let d = JSON.parse(srcContent);
        for (var srcType in d.views) {
          src = file.src.replace(".tdf", ".view." + srcType + ".tdf");
          dist = src.replace("/app/", "/dist/") + ".html";
          htmlCode = d.views[srcType].tfp;
          this.tmp_view_files.push({
            "src": src,
            "dist": dist,
            "htmlCode": htmlCode
          });
        }

        self.compileHtmlFiles(function () {
          self.tmp_index++;
          self.compileHtml(cb);
        });
      } catch (e) {
        logger.log(e);
        return;
      }
    }
    else if (file.ext == ".tbs") {
      self.tmp_index++;
      self.compileHtml(cb);
    }
    else if (file.ext == ".tdm") {
      self.tmp_index++;
      self.compileHtml(cb);
    }
    else if (file.ext == ".html") {
      let srcContent = fs.readFileSync(file.path, 'utf8');
      let htmlCode = "";
      let src = "";
      let dist = "";
      htmlCode = srcContent;
      src = file.src;
      dist = src.replace("/app/", "/dist/");

      self.compileHtmlFile({
        "src": src,
        "dist": dist
      }, htmlCode, function () {
        self.tmp_index++;
        self.compileHtml(cb);
      });
    }
    else {
      let src = "";
      let dist = "";
      src = file.src;
      dist = src.replace("/app/", "/dist/");
      self.compileHtmlFile({
        "src": src,
        "dist": dist
      }, null, function () {
        self.tmp_index++;
        self.compileHtml(cb);
      });
    }

    // self.tmp_index++;
    // self.compileHtml(cb);
  }
};

/**
 * 编译模型
 * tmp_files:{ext,path,src,dist}
 * @param {*} cb 
 * @returns 
 */
Compiler.prototype.compileModel = function (cb) {
  //files:{src,ext,dist,compress encrypt}
  var self = this;
  if (self.tmp_files.length == self.tmp_index) {
    cb();
  }
  else {
    var file = self.tmp_files[self.tmp_index];
    let srcContent = fs.readFileSync(file.path, 'utf8');
    let jsonCode = "";
    let src = "";
    let dist = "";
    if (file.ext == ".tdm") {
      jsonCode = srcContent;
      src = file.src;
      dist = src.replace("/app/", "/dist/") + ".json";
      self.compileModelFile({
        "src": src,
        "dist": dist
      }, jsonCode);
    }
    else if (file.ext == ".tdf") {
      try {
        let d = JSON.parse(srcContent);
        for (var srcType in d.models) {
          src = file.src.replace(".tdf", ".model." + srcType + ".tdf");
          dist = src.replace("/app/", "/dist/") + ".json";
          jsonCode = JSON.stringify(d.models[srcType].tdm);

          self.compileModelFile({
            "src": src,
            "dist": dist
          }, jsonCode);
        }
      } catch (e) {
        logger.log(e);
        return;
      }

    }
    else {
      jsonCode = srcContent;
      src = file.src;
      dist = src.replace("/app/", "/dist/");
      self.compileModelFile({
        "src": src,
        "dist": dist
      }, jsonCode);
    }

    self.tmp_index++;
    self.compileModel(cb);
  }
};

Compiler.prototype.compileTDF = function (cb) {
  var self = this;
  if (self.tmp_files.length == self.tmp_index) {
    cb();
  }
  else {

  }
};

/**
 * 获取文件集合
 * @param {*} type 类型
 * @param {*} dirPath 地址
 */
Compiler.prototype.getFileList = function (type, dirPath) {
  var stat0 = fs.statSync(this.rootPath + dirPath);
  if (stat0.isFile()) {
    let pathName = path.join(this.rootPath + dirPath);
    let src = dirPath;
    let ext = path.extname(this.rootPath + dirPath);
    if (type == "html" || type == "web") {
      if (ext == ".html" || ext == ".tfp" || ext == ".tdf") {
        this.tmp_files.push({
          "type": "web",
          "path": pathName,
          "src": src,
          "ext": ext
        });
      }
      else {
        this.tmp_files.push({
          "type": "web",
          "path": pathName,
          "src": src,
          "ext": ext
        });
      }
    }
    else if (type == "service") {
      if (ext == ".js" || ext == ".tbs" || ext == ".tdf") {
        this.tmp_files.push({
          "type": "service",
          "path": pathName,
          "src": src,
          "ext": ext
        });
      }
    }
    else if (type == "model") {
      if (ext == ".json" || ext == ".tdm" || ext == ".tdf") {
        this.tmp_files.push({
          "type": "model",
          "path": pathName,
          "src": src,
          "ext": ext
        });
      }
    }
  }
  else {
    let fileList = fs.readdirSync(this.rootPath + dirPath);
    if (fileList.length == 0) return;
    for (var i = 0; i < fileList.length; i++) {
      let pathName = path.join(this.rootPath + dirPath, "/" + fileList[i]);
      let src = dirPath + "/" + fileList[i];
      let ext = path.extname(this.rootPath + dirPath, "/" + fileList[i]);
      let stat = fs.statSync(pathName);
      if (stat.isFile()) {
        let ext = path.extname(pathName);
        if (type == "html" || type == "web") {
          if (ext == ".html" || ext == ".tfp" || ext == ".tdf") {
            this.tmp_files.push({
              "type": "web",
              "path": pathName,
              "src": src,
              "ext": ext
            });
          }
          else {
            this.tmp_files.push({
              "type": "web",
              "path": pathName,
              "src": src,
              "ext": ext
            });
          }
        }
        else if (type == "service") {
          if (ext == ".js" || ext == ".tbs" || ext == ".tdf") {
            this.tmp_files.push({
              "type": "service",
              "path": pathName,
              "src": src,
              "ext": ext
            });
          }
        }
        else if (type == "model") {
          if (ext == ".json" || ext == ".tdm" || ext == ".tdf") {
            this.tmp_files.push({
              "type": "model",
              "path": pathName,
              "src": src,
              "ext": ext
            });
          }
        }
      }
      else {
        this.getFileList(type, src);
      }
    }
  }
};

/**
 * 编译后台
 * @param {*} args.compress 是否压缩
 * @param {*} args.encrypt 是否加密
 * @param {*} args.src 源码地址
 * @param {*} args.dist 编译地址
 * @param {*} jsCode 代码
 * @returns 
 */
Compiler.prototype.compileServiceFile = function (args, jsCode) {
  let resultCode = "";
  //压缩
  if (args.compress) {
    try {
      resultCode = UglifyJS.minify(jsCode).code;
    } catch (e) {
      logger.log(e);
      return;
    }
  }
  //加密
  if (args.encrypt) {
  }

  var dist = this.rootPath + args.dist;
  var rdir = dist.substr(0, dist.indexOf("/dist/") + 5);
  var dirs = dist.substr(dist.indexOf("/dist/") + 6).split("/");
  var ddir = rdir;
  for (let i = 0; i < dirs.length - 1; i++) {
    ddir = path.normalize(ddir + "/" + dirs[i]);
    if (!fs.existsSync(ddir)) fs.mkdirSync(ddir);
  }

  fs.writeFileSync(dist, resultCode);
};

/**
 * 
 * @param {*} args 
 * @param {*} htmlCode 
 */
Compiler.prototype.compileHtmlFile = function (args, htmlCode, cb) {
  var self = this;

  if (args.ext == ".tfp") {
    // if (!self.tfpHandler) self.tfpHandler = new TFPHandler();
    const tfpHandler = new TFPHandler();

    let urlPath = args.src.substr(args.src.indexOf("/web") + 4).replace(/\\/g, '/');
    tfpHandler.compileTfp({
      urlPath: urlPath,
      pageDataModel: htmlCode,
      createFile: true
    }, function (err, html) {
      if (err) {
        logger.log(err);
        self.onLogicError(500, '编译TFP文件失败。');
        return;
      }

      cb();
    });
  }
  else if (args.ext == ".tdf") {
    // if (!self.tfpHandler) self.tfpHandler = new TFPHandler();
    const tfpHandler = new TFPHandler();

    tfpHandler.compileTfp({
      urlPath: args.src,
      pageDataModel: htmlCode,
      createFile: true
    }, function (err, html) {
      if (err) {
        logger.log(err);
        self.onLogicError(500, '编译TFP文件失败。');
        return;
      }

      cb();
    });
  }
  else if (args.ext == ".html") {
    let resultCode = htmlCode;

    var dist = this.rootPath + args.dist;
    var rdir = dist.substr(0, dist.indexOf("/dist/") + 5);
    var dirs = dist.substr(dist.indexOf("/dist/") + 6).split("/");
    var ddir = rdir;
    for (let i = 0; i < dirs.length - 1; i++) {
      ddir = path.normalize(ddir + "/" + dirs[i]);
      if (!fs.existsSync(ddir)) fs.mkdirSync(ddir);
    }

    fs.writeFileSync(dist, resultCode);
    cb();
  }
  else {
    var src = this.rootPath + args.src;
    var dist = this.rootPath + args.dist;
    var rdir = dist.substr(0, dist.indexOf("/dist/") + 5);
    var dirs = dist.substr(dist.indexOf("/dist/") + 6).split("/");
    var ddir = rdir;
    for (let i = 0; i < dirs.length - 1; i++) {
      ddir = path.normalize(ddir + "/" + dirs[i]);
      if (!fs.existsSync(ddir)) fs.mkdirSync(ddir);
    }

    fs.copyFileSync(src, dist);
    cb(); 
  }
};


Compiler.prototype.compileHtmlFiles = function (cb) {
  var self = this;
  if (self.tmp_view_files.length == self.tmp_view_index) {
    cb();
  }
  else {
    var f = self.tmp_view_files[self.tmp_view_index];
    self.compileHtmlFile({
      "ext": ".tdf",
      "src": f.src,
      "dist": f.dist,
    }, f.htmlCode, function () {
      self.tmp_view_index++;
      self.compileHtmlFiles(cb);
    })
  }
};


Compiler.prototype.compileModelFile = function (args, jsonCode) {
  let resultCode = jsonCode;

  var dist = this.rootPath + args.dist;
  var rdir = dist.substr(0, dist.indexOf("/dist/") + 5);
  var dirs = dist.substr(dist.indexOf("/dist/") + 6).split("/");
  var ddir = rdir;
  for (let i = 0; i < dirs.length - 1; i++) {
    ddir = path.normalize(ddir + "/" + dirs[i]);
    if (!fs.existsSync(ddir)) fs.mkdirSync(ddir);
  }

  fs.writeFileSync(dist, resultCode);
};


