var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs');

/**
 * 设置项目信息
 */
var SetProj = function () {
    Service.call(this);
};

util.inherits(SetProj, Service);

module.exports = SetProj;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SetProj.prototype.process = function (req, res) {
    var self = this;
    if(!req.filepath){
        this.onLogicError(1, '请提供文件路径！', req, res);
        return;
    }
    if (!req.args) {
        this.onLogicError(1, '请提供设置参数！', req, res);
        return;
    }
    var args = req.args;
    //将javascript对象转换为json字符串
    args = JSON.stringify(args, undefined, 4);
    //  writeFile()可以接收四个参数，第一个是路径，第二个是文件内容，
    //第三个可选项代表权限，第四个是回调函数。这里第三个参数通常省略
    fs.writeFile('./app/'+req.filepath+'/setting.json', args, err => {
        if (err) {
            console.log('写入出错了');
        } else {
            console.log('文件写入成功');
        }
        let packageFilePath = utils.getPath('/app/' + req.filepath + "/package.json");
        if(fs.existsSync(packageFilePath)) {
            fs.readFile(packageFilePath,"utf-8",function(err, data) {
                let pkInfo = JSON.parse(data);
                pkInfo.comment = "";
                pkInfo.serviceLanguage = req.serviceLanguage;
                self.savePkInfo(req, res, packageFilePath, pkInfo);
            });
        } else {
            let pkInfo = {
                name: req.code,
                comment: "",
                serviceLanguage: req.serviceLanguage,
                models: {},
                services: {},
                pages: {}
            };
            self.savePkInfo(req, res, packageFilePath, pkInfo);
        }
    })
};

SetProj.prototype.savePkInfo = function (req, res, packageFilePath, pkInfo) {
    if(req.comment) pkInfo.comment = req.comment;
    pkInfo.lastUpdateTime = new Date();
    pkInfo.lastUpdateUser = req.session.userName;
    utils.saveJSONToFile(packageFilePath, pkInfo);

    var projects = {};
    var self = this;
    var projectsFilePath = utils.getPath("/app/projects.json");
    if (fs.existsSync(projectsFilePath)) {
        fs.readFile(projectsFilePath,"utf-8",function(err, data) {
            projects = JSON.parse(data);
            self.setProjectsFile(req, res, projectsFilePath, projects);
        });
    } else {
        self.setProjectsFile(req, res, projectsFilePath, projects);
    }
};

SetProj.prototype.setProjectsFile = function (req, res, projectsFilePath, projects) {
    projects[req.code] = {
        name: req.code,
        comment: req.comment,
        lastUpdateTime: new Date(),
        lastUpdateUser: req.session.userName
    };
    fs.writeFileSync(projectsFilePath, JSON.stringify(projects, null, 2));
    this.end(res);
};