var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var PackageManager = require('./packageManager.js');

/**
 * 获得文件内容
 */
var SaveFileContent = function() { 
  Service.call(this);
  this.sqlInject = {check: false};
  this.xssInject.exclude = ['data'];
  this.pkManager = new PackageManager();
};

util.inherits(SaveFileContent, Service);

module.exports = SaveFileContent;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SaveFileContent.prototype.process =  function(req, res) {
  if(!req.filePath) {
    this.onLogicError(1, '请提供文件路径！');
    return;
  }
  if(!req.data) {
    this.onLogicError(1, '请提供文件内容！');
    return;
  }

  req.filePath = req.filePath.replace(/\.\.\//g,'').replace(/\.\//g,'');
  var filePath = utils.getPath(req.filePath);

  let fileContent = req.data;
  let jsonContent = {};
  if(filePath.endWith(".tfp") || filePath.endWith(".tpr") || filePath.endWith(".tbs")) {
    jsonContent = JSON.parse(req.data);
    if((filePath.endWith(".tbs") && req.formatJSON) || filePath.endWith(".tpr")) {
      fileContent = JSON.stringify(jsonContent, null, "\t");
    }
    let projCode = "";
    //如果是前端文件
    if(filePath.endWith(".tfp") || filePath.endWith(".tpr")) {
      projCode = req.filePath.substring(9);
      projCode = projCode.substring(0, projCode.indexOf("/"));
    } else {  //如果是后台服务
      projCode = req.filePath.substring(5);
      projCode = projCode.substring(0, projCode.indexOf("/"));
    }
    //更新项目包信息
    this.setProjPackage(req, res, filePath, fileContent, jsonContent);
  } else {
    this.saveFile(req, res, filePath, fileContent);
  }
};

SaveFileContent.prototype.createDir = function (dirPath, cb) {
  let arrDir = dirPath.split("/");
  try {
    let dir = utils.getPath("/");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      dir += "/" + arrDir[i];
      if (!fs.existsSync(dir)) fs.mkdirSync(dir);
    }
    cb();
  } catch (err) {
    logger.log(err);
    cb(err);
  }
};

SaveFileContent.prototype.setProjPackage =  function(req, res, filePath, fileContent, jsonContent) {
  var self = this;
  //如果是前端文件
  if(filePath.endWith(".tfp") || filePath.endWith(".tpr")) {
    this.pkManager.setPageInfo(req, req.filePath, jsonContent, function() {
      let dataBindSettings = [];
      if(jsonContent.cptDataBindSetting) {
        self.cptDataBindSetting = jsonContent.cptDataBindSetting;
        for(let cptId in jsonContent.cptDataBindSetting) {
          let cptSetting = jsonContent.cptDataBindSetting[cptId];
          for(let settingId in cptSetting) {
            let setting = cptSetting[settingId];
            //如果是表单里的可编辑表格，不用单独处理，合并到表单里统一处理
            if(setting.formId) continue;
            //不能直接把setting对象放到dataBindSettings，因为后面要删haveModified标识
            let settingNew = JSON.parse(JSON.stringify(setting));
            settingNew.id = settingId;
            settingNew.cptId = cptId;
            dataBindSettings.push(settingNew);
            //删除数据绑定设置的已修改标志，否则再次打开tfp文件时，该设置默认还是会被标识为已修改，导致每次保存tfp都会重新生成tbs代码
            delete setting["haveModified"];
          }
        }
      }
      self.createDir(req.filePath.substring(0, filePath.lastIndexOf("/")), function(err){
        if(err) {
          self.end(res);
          return;
        }
        self.saveFile(req, res, filePath, JSON.stringify(jsonContent, null, "\t"), function() {
          if(dataBindSettings.length==0) {
            self.end(res);
            return;
          }
          self.createTBS(req, res, dataBindSettings, 0);
        });
      });
    });
  } else {  //如果是后台服务
    this.pkManager.setServiceInfo(req, req.filePath, jsonContent, function() {
      self.saveFile(req, res, filePath, fileContent);
    });
  }
}

SaveFileContent.prototype.createServiceDir = function (req, res, servicePath, cb) {
  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
    cb();
  } catch (err) {
    logger.log(err);
    cb(err);
  }
};

SaveFileContent.prototype.saveFile =  function(req, res, filePath, fileContent, cb) {
  var self = this;
  fs.writeFile(filePath,fileContent,function(err) {
    if(err) {
      res.code = 3;
      res.message = err.message;
      self.end(res);
      return;
    }
    if(cb) {
      cb();
      return;
    }
    self.end(res);
  });
}

SaveFileContent.prototype.createTBS =  function(req, res, dataBindSettings, index) {
  if(index>=dataBindSettings.length) {
    this.end(res);
    return;
  }
  let setting = dataBindSettings[index];
  //如果数据绑定设置没有修改，则不重新生成后台服务代码
  if(!setting.haveModified) {
    this.createTBS(req, res, dataBindSettings, index+1);
    return;
  }
  let tbsObj = {
    "name": setting.serviceName,
    "comment": setting.serviceComment,
    "reqArgs": [],
    "resArgs": [],
    "notCheckLogin": false,
    "notCheckSQLInject": false,
    "notCheckXSSInject": false,
    "methods": [
      {
        "name": "process",
        "comment": "处理服务请求",
        "args": [
          {
            "name": "req",
            "type": "object",
            "comment": "服务请求对象"
          },
          {
            "name": "res",
            "type": "object",
            "comment": "服务响应对象"
          }
        ],
        "statements": []
      }
    ]
  };
  if(setting.notCheckLogin) tbsObj.notCheckLogin = true;
  if(setting.notCheckSQLInject) tbsObj.notCheckSQLInject = true;
  if(setting.notCheckXSSInject) tbsObj.notCheckXSSInject = true;
  if(setting.encryptRequestArgs) tbsObj.encryptRequestArgs = setting.encryptRequestArgs;
  if(setting.encryptResponseArgs) tbsObj.encryptResponseArgs = setting.encryptResponseArgs;
  if(setting.reqArgs) tbsObj.reqArgs = setting.reqArgs;
  if(setting.type=="query") {
    //数据表格的树形节点的数据查询和整个表格的数据查询合并到一个服务里，不需要单独建服务
    if(setting.id=="gridNodeDataQuerySetting") {
      this.createTBS(req, res, dataBindSettings, index+1);
      return;
    }
    this.setDataQueryTBS(req, res, setting, tbsObj, dataBindSettings);
  } else if(setting.type=="submit") {
    if(setting.cptType=="Form") {
      this.setDataSubmitTBS(req, res, setting, tbsObj);
    } else if(setting.cptType=="DataSet") {
      //如果可编辑表格在表单组件里，则不需要单独创建数据提交的后台服务，合并到表单里一起提交
      if(setting.formId) {
        this.createTBS(req, res, dataBindSettings, index+1);
        return;
      }
      this.setDataSetSubmitTBS(req, res, tbsObj, tbsObj.methods[0], [setting], 0);
    }
  } else if(setting.type=="delete") {
    this.setDataDeleteTBS(req, res, setting, tbsObj);
  } else if(setting.type=="import") {
    this.setDataImportTBS(req, res, setting, tbsObj);
  } else if(setting.type=="export") {
    this.setDataExportTBS(req, res, setting, tbsObj);
  } else if(setting.type=="stat") {
    this.setDataStatTBS(req, res, setting, tbsObj);
  }
  
  var self = this;
  this.createServiceDir(req, res, setting.servicePath, function() {
    let tbsFilePath = utils.getPath("/app/"+setting.servicePath);
    self.saveFile(req, res, tbsFilePath, JSON.stringify(tbsObj, null, "\t"), function(){
      self.createTBS(req, res, dataBindSettings, index+1);
    });
  });
};

SaveFileContent.prototype.setDataQueryTBS =  function(req, res, setting, tbsObj, dataBindSettings, isGetRet) {
  let subStatement =  {
    "category": "common",
    "type": "end"
  };
  let varSuffix = "";
  if(isGetRet) varSuffix = "_node";
  //如果不是获得返回结果，且该组件的数据绑定设置数量超过1
  if(setting.id=="dataQuerySetting" && dataBindSettings && dataBindSettings.length>1) {
    for(let i=0;i<dataBindSettings.length;i++) {
      let settingTmp = dataBindSettings[i];
      if(settingTmp.id=="gridNodeDataQuerySetting") {
        subStatement = this.setDataQueryTBS(req, res, settingTmp, tbsObj, null, true);
        break;
      }
    }
  }
  let queryStatement = {};
  if(setting.requestMode=="model" || setting.requestMode=="dataForm") {
    queryStatement = {
      "category": "db",
      "type": "query",
      "model": {
        "name": "",
        "path": "/app/"+setting.modelPath
      },
      "enableDataPage": false,
      "pageSize": 20,
      "cbArg": "rows"+varSuffix,
      "fields": setting.fields,
      "orders": [],
      "groups": [],
      "queryArgs": [],
      "where": "",
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data"+varSuffix,
          "value": "rows"+varSuffix
        }
      ]
    };
    queryStatement.statements.push(subStatement);
    if(setting.modelName) {
      queryStatement.model.name = setting.modelName;
    } else {
      let modelName = setting.modelPath.substring(setting.modelPath.lastIndexOf("/")+1, setting.modelPath.lastIndexOf("."));
      queryStatement.model.name = modelName;
    }
    if(setting.dataMember) queryStatement.statements[0].value = "res."+setting.dataMember;
    if(setting.conditions) queryStatement.queryArgs = setting.conditions;
    if(setting.where) queryStatement.where = setting.where;
    if(setting.groups) queryStatement.groups = setting.groups;
    if(setting.orders) queryStatement.orders = setting.orders;
    if(setting.count) queryStatement.count = setting.count;
    if(setting.distinct) queryStatement.distinct = setting.distinct;
    if(setting.orderByGridId) queryStatement.orderByGridId = setting.orderByGridId;
    if(setting.enableDataPage) queryStatement.enableDataPage = true;
    if(setting.queryOne) queryStatement.statements[0].value = "rows[0]";
  } else if(setting.requestMode=="sql") {
    queryStatement = {
      "category": "db",
      "type": "execute",
      "sql": setting.sql,
      "dsId": setting.dsId,
      "enableDataPage": false,
      "pageSize": 20,
      "retArg": "rows"+varSuffix,
      "queryArgs": [],
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data"+varSuffix,
          "value": "rows"+varSuffix
        }
      ]
    };
    queryStatement.statements.push(subStatement);
  } else if(setting.requestMode=="http") {
    queryStatement = {
      "category": "common",
      "type": "sendHttpRequest",
      "urlPath": setting.httpRequest.urlPath,
      "cbErr": "errHttp"+varSuffix,
      "cbRet": "retHttp"+varSuffix,
      "method": setting.httpRequest.method,
      "dataType": setting.httpRequest.postDataType,
      "retToJson": true,
      "postData": setting.httpRequest.postData,
      "headers": setting.httpRequest.headers,
      "cookies": setting.httpRequest.cookies,
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data"+varSuffix,
          "value": "retHttp"+varSuffix+"."+setting.httpRequest.retArg
        }
      ]
    };
    queryStatement.statements.push(subStatement);
  }
  if(isGetRet) return queryStatement;
  tbsObj.methods[0].statements.push(queryStatement);
};

SaveFileContent.prototype.addSetAttachFunc =  function(setting, tbsObj, parentSM) {
  let sm = {
    "name": "setAttach",
    "comment": "设置附件信息",
    "args": [
      {
        "name": "req",
        "type": "object",
        "required": false
      },
      {
        "name": "res",
        "type": "object",
        "required": false
      },
      {
        "name": "uploaders",
        "type": "array",
        "required": false
      },
      {
        "name": "index",
        "type": "int",
        "required": false
      },
      {
        "name": "appDataId",
        "type": "int",
        "required": false
      }
    ],
    "statements": [
      {
        "category": "common",
        "type": "if",
        "condition": "index>=uploaders.length",
        "statements": [
          {
            "category": "common",
            "type": "end"
          },
          {
            "category": "common",
            "type": "return"
          }
        ]
      },
      {
        "category": "common",
        "type": "declare",
        "varName": "uploader",
        "varType": "array",
        "defaultVal": "req[uploaders[index]] "
      },
      {
        "category": "common",
        "type": "if",
        "condition": "uploader&& uploader.length>0",
        "statements": [
          {
            "category": "attach",
            "type": setting.submitType=="update" ? "updateAttach" : "addAttach" ,
            "argFiles": "uploader",
            "appCode": "uploader[0].appCode",
            "appDataId": "appDataId",
            "statements": [
              {
                "category": "common",
                "type": "func",
                "statement": "self.setAttach( req , res , uploaders , index+1 , appDataId )"
              }
            ]
          }
        ],
        "elseStatements": [
          {
            "category": "common",
            "type": "func",
            "statement": "self.setAttach( req , res , uploaders , index+1 , appDataId )"
          }
        ]
      }
    ]
  };
  tbsObj.methods.push(sm);
  parentSM.statements.push({
    "category": "common",
    "type": "declare",
    "varName": "uploaders",
    "varType": "array",
    "defaultVal": JSON.stringify(setting.uploaders)
  });
  parentSM.statements.push({
    "category": "common",
    "type": "func",
    "statement": "self.setAttach( req , res , uploaders , 0 , "+ (setting.submitType=="update" ? "req.id" : "ret.insertId") +" )"
  });
};

SaveFileContent.prototype.setDataSubmitTBS =  function(req, res, setting, tbsObj) {
  let submitStatement = {};
  if(setting.requestMode=="model" || setting.requestMode=="dataForm") {
    submitStatement = {
      "category": "db",
      "type": setting.submitType=="update" ? "update" : "insert",
      "model": {
        "name": "",
        "path": "/app/"+setting.modelPath
      },
      "fields": setting.fields,
      "cbArg": "ret",
      "statements": []
    };
    if(setting.modelName) {
      submitStatement.model.name = setting.modelName;
    } else {
      let modelName = setting.modelPath.substring(setting.modelPath.lastIndexOf("/")+1, setting.modelPath.lastIndexOf("."));
      submitStatement.model.name = modelName;
    }

    if(setting.submitType=="update") {
      submitStatement.where = setting.where;
    } else {
      submitStatement.cbArg = "ret";
      submitStatement.statements.push({
        "category": "common",
        "type": "assign",
        "operator": "=",
        "varName": "res.id",
        "value": "ret.insertId"
      });
    }
  } else if(setting.requestMode=="sql") {
    submitStatement = {
      "category": "db",
      "type": "execute",
      "sql": setting.sql,
      "dsId": setting.dsId,
      "retArg": "ret",
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data",
          "value": "ret"
        }
      ]
    };
  } else if(setting.requestMode=="http") {
    submitStatement = {
      "category": "common",
      "type": "sendHttpRequest",
      "urlPath": setting.httpRequest.urlPath,
      "cbErr": "errHttp",
      "cbRet": "retHttp",
      "method": setting.httpRequest.method,
      "dataType": setting.httpRequest.postDataType,
      "retToJson": true,
      "postData": setting.httpRequest.postData,
      "headers": setting.httpRequest.headers,
      "cookies": setting.httpRequest.cookies,
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data",
          "value": "retHttp"
        }
      ]
    };
  }
    
  if(setting.dataSets && setting.dataSets.length>0) {
    this.formSetting = setting;
    let settings = [];
    for(let i=0;i<setting.dataSets.length;i++) {
      let dataSetId = setting.dataSets[i];
      let dsSetting = this.cptDataBindSetting[dataSetId];
      if(dsSetting && dsSetting.dataSubmitSetting) {
        dsSetting.dataSubmitSetting.cptId = dataSetId;
        settings.push(dsSetting.dataSubmitSetting);
      }
    }
    this.setDataSetSubmitTBS(req, res, tbsObj, submitStatement, settings, 0);
  } else {
    if(setting.uploaders && setting.uploaders.length>0) {
      this.addSetAttachFunc(setting, tbsObj, submitStatement);
    } else {
      submitStatement.statements.push({
        "category": "common",
        "type": "end"
      });
    }
  }
  tbsObj.methods[0].statements.push(submitStatement);
};

SaveFileContent.prototype.setDataSetSubmitTBS =  function(req, res, tbsObj, parentSM, settings, index) {
  if(index>=settings.length) {
    if(this.formSetting && this.formSetting.uploaders && this.formSetting.uploaders.length>0) {
      this.addSetAttachFunc(this.formSetting, tbsObj, parentSM);
    } else {
      let endSm = {
        "category": "common",
        "type": "end"
      };
      if(parentSM.statements.length>0 && parentSM.statements[0].statements) {
        parentSM.statements[0].statements.push(endSm);
      } else {
        parentSM.statements.push(endSm);
      }
    }
    return;
  }
  let setting = settings[index];
  let submitStatement = {};
  if(setting.requestMode=="model" || setting.requestMode=="dataForm") {
    let modelName = null;
    if(setting.modelName) {
      modelName = setting.modelName;
    } else {
      modelName = setting.modelPath.substring(setting.modelPath.lastIndexOf("/")+1, setting.modelPath.lastIndexOf("."));
    }

    if(setting.submitType=="insert" || setting.submitType=="add") {
      submitStatement = {
        "category": "db",
        "type": "batchinsert",
        "model": {
          "name": modelName,
          "path": "/app/"+setting.modelPath
        },
        "fields": setting.fields,
        "dataListVar": "req."+setting.cptId,
        "statements": []
      };
    } else if(setting.submitType=="update") {
      //如果是先删除后新增
      if(setting.delOldData) {
        submitStatement = {
          "category": "db",
          "type": "delete",
          "model": {
            "name": modelName,
            "path": "/app/"+setting.modelPath
          },
          "where": setting.where,
          "statements": [
            {
              "category": "db",
              "type": "batchinsert",
              "model": {
                "name": modelName,
                "path": "/app/"+setting.modelPath
              },
              "fields": setting.fields,
              "dataListVar": "req."+setting.cptId,
              "statements": []
            }
          ]
        };
      } else {
        submitStatement = {
          "category": "db",
          "type": "batchupdate",
          "model": {
            "name": modelName,
            "path": "/app/"+setting.modelPath
          },
          "where": setting.where,
          "keys": setting.keys,
          "fields": setting.fields,
          "dataListVar": "req."+setting.cptId,
          "statements": []
        };
      }
    }
  } else if(setting.requestMode=="sql") {
    submitStatement = {
      "category": "db",
      "type": "execute",
      "sql": setting.sql,
      "dsId": setting.dsId,
      "retArg": "ret_"+setting.cptId,
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data",
          "value": "ret_"+setting.cptId
        }
      ]
    };
  } else if(setting.requestMode=="http") {
    submitStatement = {
      "category": "common",
      "type": "sendHttpRequest",
      "urlPath": setting.httpRequest.urlPath,
      "cbErr": "errHttp_"+setting.cptId,
      "cbRet": "retHttp_"+setting.cptId,
      "method": setting.httpRequest.method,
      "dataType": setting.httpRequest.postDataType,
      "retToJson": true,
      "postData": setting.httpRequest.postData,
      "headers": setting.httpRequest.headers,
      "cookies": setting.httpRequest.cookies,
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data",
          "value": "retHttp_"+setting.cptId
        }
      ]
    };
  }
  this.setDataSetSubmitTBS(req, res, tbsObj, submitStatement, settings, index+1);
  parentSM.statements.push(submitStatement);
};

SaveFileContent.prototype.setDataDeleteTBS =  function(req, res, setting, tbsObj) {
  if(setting.requestMode=="model") {
    let deleteStatement = {
      "category": "db",
      "type": "delete",
      "model": {
        "name": "",
        "path": "/app/"+setting.modelPath
      },
      "where": setting.where,
      "statements": []
    };
    if(setting.deleteType=="update") {
      deleteStatement = {
        "category": "db",
        "type": "update",
        "model": {
          "name": "",
          "path": "/app/"+setting.modelPath
        },
        "fields": setting.updateFields,
        "where": setting.where,
        "cbArg": "ret",
        "statements": []
      };
    }
    if(setting.modelName) {
      deleteStatement.model.name = setting.modelName;
    } else {
      let modelName = setting.modelPath.substring(setting.modelPath.lastIndexOf("/")+1, setting.modelPath.lastIndexOf("."));
      deleteStatement.model.name = modelName;
    }
    deleteStatement.statements.push({
      "category": "common",
      "type": "end"
    });
    tbsObj.methods[0].statements.push(deleteStatement);
  } else if(setting.requestMode=="dataForm") {
    let deleteStatement = {
      "category": "db",
      "type": "execute",
      "sql": "delete from "+setting.tableName+" where "+setting.where,
      "statements": [
        {
          "category": "common",
          "type": "end"
        }
      ]
    };
    tbsObj.methods[0].statements.push(deleteStatement);
  } else if(setting.requestMode=="sql") {
    let deleteStatement = {
      "category": "db",
      "type": "execute",
      "sql": setting.sql,
      "dsId": setting.dsId,
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data",
          "value": "ret"
        },
        {
          "category": "common",
          "type": "end"
        }
      ]
    };
    tbsObj.methods[0].statements.push(deleteStatement);
  } else if(setting.requestMode=="http") {
    let deleteStatement = {
      "category": "common",
      "type": "sendHttpRequest",
      "urlPath": setting.httpRequest.urlPath,
      "cbErr": "errHttp",
      "cbRet": "retHttp",
      "method": setting.httpRequest.method,
      "dataType": setting.httpRequest.postDataType,
      "retToJson": true,
      "postData": setting.httpRequest.postData,
      "headers": setting.httpRequest.headers,
      "cookies": setting.httpRequest.cookies,
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "res.data",
          "value": "retHttp"
        },
        {
          "category": "common",
          "type": "end"
        }
      ]
    };
    tbsObj.methods[0].statements.push(deleteStatement);
  }
};

SaveFileContent.prototype.setDataImportTBS =  function(req, res, setting, tbsObj) {
  let statement = {};
  if(setting.requestMode=="model" || setting.requestMode=="dataForm") {
    statement = {
      "category": "import-export",
      "type": "excelImport",
      "model": {
        "name": "",
        "path": "/app/"+setting.modelPath
      },
      "fields": setting.fields,
      "titleRowIndex": setting.titleRowIndex,
      "fileCode": setting.fileCode,
      "importType": setting.importType,
      "statements": []
    };
    if(setting.modelName) {
      statement.model.name = setting.modelName;
    } else {
      let modelName = setting.modelPath.substring(setting.modelPath.lastIndexOf("/")+1, setting.modelPath.lastIndexOf("."));
      statement.model.name = modelName;
    }
    if(setting.updateWhere) statement.updateWhere = setting.updateWhere;
    if(setting.updateNullData) statement.updateNullData = setting.updateNullData;
    if(setting.processRowDataService) statement.processRowDataService = setting.processRowDataService;
  }
    
  statement.statements.push({
    "category": "common",
    "type": "end"
  });

  tbsObj.methods[0].statements.push(statement);
};

SaveFileContent.prototype.setDataExportTBS =  function(req, res, setting, tbsObj) {
  let queryStatement = {};
  let queryFields = [];
  let exportFields = [];
  if(setting.fields) {
    setting.fields.forEach((field, index) => {
      let ff = {
          name: field.name
      };
      if (field.format) ff.format = field.format;
      if (field.dataDic) ff.dataDic = field.dataDic;
      if (field.alias) ff.alias = field.alias;
      queryFields.push(ff);
      exportFields.push({
        name: field.name,
        column: field.column,
        width: field.width
      });
    });
  }
  if(setting.requestMode=="model" || setting.requestMode=="dataForm") {
    queryStatement = {
      "category": "db",
      "type": "query",
      "model": {
        "name": "",
        "path": "/app/"+setting.modelPath
      },
      "enableDataPage": false,
      "cbArg": "rows",
      "fields": queryFields,
      "orders": [],
      "groups": [],
      "queryArgs": [],
      "where": "",
      "statements": []
    };

    if(setting.modelName) {
      queryStatement.model.name = setting.modelName;
    } else {
      let modelName = setting.modelPath.substring(setting.modelPath.lastIndexOf("/")+1, setting.modelPath.lastIndexOf("."));
      queryStatement.model.name = modelName;
    }
    if(setting.conditions) queryStatement.queryArgs = setting.conditions;
    if(setting.where) queryStatement.where = setting.where;
    if(setting.groups) queryStatement.groups = setting.groups;
    if(setting.orders) queryStatement.orders = setting.orders;
    if(setting.having) queryStatement.having = setting.having;
    if(setting.count) queryStatement.count = setting.count;
    if(setting.distinct) queryStatement.distinct = setting.distinct;
  } else if(setting.requestMode=="sql") {
    queryStatement = {
      "category": "db",
      "type": "execute",
      "sql": setting.sql,
      "dsId": setting.dsId,
      "retArg": "rows",
      "queryArgs": [],
      "statements": []
    };
  } else if(setting.requestMode=="http") {
    queryStatement = {
      "category": "common",
      "type": "sendHttpRequest",
      "urlPath": setting.httpRequest.urlPath,
      "cbErr": "errHttp",
      "cbRet": "retHttp",
      "method": setting.httpRequest.method,
      "dataType": setting.httpRequest.postDataType,
      "retToJson": true,
      "postData": setting.httpRequest.postData,
      "headers": setting.httpRequest.headers,
      "cookies": setting.httpRequest.cookies,
      "statements": []
    };
  }
  queryStatement.statements.push({
    "category": "import-export",
    "type": "excelExport",
    "dataVarName": (setting.requestMode=="http") ? "retHttp."+setting.httpRequest.retArg : "rows",
    "appCode": setting.appCode,
    "fileName": setting.fileName,
    "fields": exportFields,
    "statements": [{
      "category": "common",
      "type": "end"
    }]
  });
  tbsObj.methods[0].statements.push(queryStatement);
};
