var util = require('util');
var fs = require('fs');
var utils = require('utils');

/**
 * 包管理器
 */
var PackageManager = function () {
    //
};

module.exports = PackageManager;

/**
 * 获得包信息
 * @param  {Object} projCode 项目代码
 * @param  {Object} cb 回调函数
 */
PackageManager.prototype.getPackageInfo = function (projCode, cb) {
    let packageFilePath = utils.getPath('/app/' + projCode+"/package.json");
    let pkInfo = {
        name: projCode,
        models: {},
        services: {},
        pages: {}
    };
    if(fs.existsSync(packageFilePath)) {
      var self = this;
      fs.readFile(packageFilePath,"utf-8",function(err, data) {
        data = JSON.parse(data);
        pkInfo = {...pkInfo, ...data};
        cb(pkInfo);
      });
    } else {
      cb(pkInfo);
    }
};

/**
 * 保存包信息
 * @param {*} req 
 * @param  {Object} pkInfo 包信息
 */
PackageManager.prototype.savePackageInfo = function (req, pkInfo, cb) {
  let packageFilePath = utils.getPath('/app/' + pkInfo.name+"/package.json");
  pkInfo.lastUpdateTime = new Date();
  pkInfo.lastUpdateUser = req.session.userName;
  fs.writeFile(packageFilePath, JSON.stringify(pkInfo, null, "\t"), function(err) {
    if(err) {
      logger.log(err);
      cb(err);
      return;
    }
    cb();
  });
};

/**
 * 设置数据模型信息
 * @param {*} req 
 * @param {*} modelPath 
 * @param {*} modelData 
 */
PackageManager.prototype.setModelInfo = function (req, modelPath, modelData, cb) {
  var self = this;
  let projCode = modelPath.substring(0, modelPath.indexOf("/"));
  this.getPackageInfo(projCode, function(pkInfo) {
    let modelInfo = {
      type: modelData.type,
      table: modelData.table,
      dbType: modelData.dbType,
      version: modelData.version,
      comment: null
    };
    if(modelData.comment) modelInfo.comment = modelData.comment;
    let modelPathShort = modelPath.substring(projCode.length+7);
    pkInfo.models[modelPathShort] = modelInfo;
    self.savePackageInfo(req, pkInfo, (err)=> {
      if(err) {
        if(cb) cb(err);
        return;
      }
      if(cb) cb();
    });
  });
};

/**
 * 设置后台服务信息
 * @param {*} req 
 * @param {*} servicePath 
 * @param {*} serviceData 
 */
PackageManager.prototype.setServiceInfo = function (req, servicePath, serviceData, cb) {
  var self = this;
  let projCode = servicePath.substring(5);
  projCode = projCode.substring(0, projCode.indexOf("/"));
  this.getPackageInfo(projCode, function(pkInfo) {
    let serviceInfo = {
      name: serviceData.name,
      type: serviceData.type,
      notCheckLogin: serviceData.notCheckLogin,
      notCheckSQLInject: serviceData.notCheckSQLInject,
      comment: null
    };
    if(serviceData.comment) serviceInfo.comment = serviceData.comment;
    let servicePathShort = servicePath.substring(projCode.length+14);
    pkInfo.services[servicePathShort] = serviceInfo;
    self.savePackageInfo(req, pkInfo, (err)=> {
      if(err) {
        if(cb) cb(err);
        return;
      }
      if(cb) cb();
    });
  });
};

/**
 * 设置页面信息
 * @param {*} req 
 * @param {*} pagePath 
 * @param {*} pageData 
 */
PackageManager.prototype.setPageInfo = function (req, pagePath, pageData, cb) {
  var self = this;
  let projCode = pagePath.substring(9);
  projCode = projCode.substring(0, projCode.indexOf("/"));
  this.getPackageInfo(projCode, function(pkInfo) {
    let pageInfo = {
      client: pageData.client,
      mobileType: pageData.mobileType,
      framework: pageData.framework,
      positionType: pageData.positionType,
      bgColorMode: pageData.bgColorMode,
      pageType: pageData.pageType,
      title: pageData.title
    };
    let pagePathShort = pagePath.substring(projCode.length+10);
    pkInfo.pages[pagePathShort] = pageInfo;
    self.savePackageInfo(req, pkInfo, (err)=> {
      if(err) {
        if(cb) cb(err);
        return;
      }
      if(cb) cb();
    });
  });
};

/**
 * 设置生成式应用信息
 * @param {*} req 
 * @param {*} tgaPath 
 * @param {*} tgaData 
 */
PackageManager.prototype.setTGAInfo = function (req, tgaPath, tgaData, cb) {
  var self = this;
  let projCode = tgaPath.substring(5);
  projCode = projCode.substring(0, projCode.indexOf("/"));
  this.getPackageInfo(projCode, function(pkInfo) {
    let tgaInfo = {
      name: tgaData.name,
      comment: null
    };
    if(tgaData.comment) tgaInfo.comment = tgaData.comment;
    let tgaPathShort = tgaPath.substring(projCode.length+10);
    if(!pkInfo.tgas) pkInfo.tgas = {};
    pkInfo.tgas[tgaPathShort] = tgaInfo;
    self.savePackageInfo(req, pkInfo, (err)=> {
      if(err) {
        if(cb) cb(err);
        return;
      }
      if(cb) cb();
    });
  });
};