var util = require('util');
var utils = require('utils');
var Service = require('Service');

var GetTdfFileList = function () {
    Service.call(this);
    this.sqlInject.exclude = ['dir'];
    this.xssInject.exclude = ['dir'];
};

util.inherits(GetTdfFileList, Service);

module.exports = GetTdfFileList;

/**
 * 获得tdf文件列表
 * @param  {Object} req                     服务请求对象
 * @param  {String} req.filePath            文件路径
 * @param  {String} [req.listServerFile]    是否返回后端路径
 * @param  {String} [req.listClientFile]    是否返回前端路径
 * @param  {String} [req.listModelsFile]    是否返回模型路径
 * @param  {Object} res                     服务响应对象
 */
GetTdfFileList.prototype.process = async function (req, res) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');

    const filePath = req.filePath;
    const listServerFile = req.listServerFile || false;
    const listClientFile = req.listClientFile || false;
    const listModelsFile = req.listModelsFile || false;
    const fileInfo = await this.getFileContent(req, res).catch((err) => {
        return this.onError(err);
    });
    const tdfInfo = JSON.parse(fileInfo);

    const fileList = [];
    if (listServerFile) {
        for (const serviceName in tdfInfo.services) {
            fileList.push(filePath.replace(/(.*)\.tdf/, `$1.service.${serviceName}.tdf`));
        }
    }
    if (listClientFile) {
        for (const viewName in tdfInfo.views) {
            fileList.push(filePath.replace(/(.*)\.tdf/, `$1.view.${viewName}.tdf`));
        }
    }
    if (listModelsFile) {
        for (const viewName in tdfInfo.models) {
            fileList.push(filePath.replace(/(.*)\.tdf/, `$1.model.${viewName}.tdf`));
        }
    }
    return this.end({ ...res, fileList });
};

GetTdfFileList.prototype.getFileContent = function (req, res) {
    return new Promise((resolve, reject) => {
        try {
            this.pipe(require('../tdf/getFileContent'), {
                filePath: req.filePath,
                session: req.session
            }, { ...res }, (_req, _res) => {
                if (_res.code == 0) resolve(_res.data);
                else return reject(_res);
            });
        } catch (error) {
            return reject(error);
        }
    });
}