var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获得所有后台服务列表
 */
var GetServices = function () {
  Service.call(this);
};

util.inherits(GetServices, Service);

module.exports = GetServices;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetServices.prototype.process = function (req, res) {
  if (!req.projCode) {
    this.onLogicError(1, '请提供项目代码！');
    return;
  }
  
  const rootPath = utils.getPath("/app/"+req.projCode+"/service");
  
  if(!fs.existsSync(rootPath)) {
    this.onLogicError(1, '请提供正确的项目代码！');
    return;
  }
  
  let projInfo = {
    services: {}
  };
  res.services = [];
  let curPath = "";
  if(req.curPath) curPath = req.curPath;

  let pkPath = utils.getPath("/app/"+req.projCode+"/package.json");
  if(fs.existsSync(pkPath)) {
    var self = this;
    fs.readFile(pkPath,"utf-8",function(err, data) {
      projInfo = JSON.parse(data);
      self.getServices(req, res, projInfo, rootPath, curPath);
    });
  } else {
    this.getServices(req, res, projInfo, rootPath, curPath);
  }
};

GetServices.prototype.getServices = function (req, res, projInfo, rootPath, curPath) {
    let dirPath = rootPath;
    if(curPath!="") dirPath = rootPath+"/"+curPath;
    if(!fs.existsSync(dirPath)) {
      this.onLogicError(2, '请提供正确的路径！');
      return;
    }
    let list = fs.readdirSync(dirPath);
    let dirs = [];
    let files = [];
    for (let i = 0; i < list.length; i++) {
        const fileName = list[i];
        let filePath = dirPath+"/"+fileName;
        let stat = fs.statSync(filePath);
        if (!stat) continue;
        if (stat.isDirectory()) {
            let dirInfo = {
                path: fileName,
                dir: true
            };
            dirs.push(dirInfo);
        }
        if (stat.isFile()) {
            let service = {
                path: fileName
            };
            let servicePath = curPath + (curPath=="" ? "" : "/") + service.path;
            let serviceInfo = projInfo.services[servicePath];
            if(serviceInfo) {
                if(serviceInfo.name) service.name = serviceInfo.name;
                if(serviceInfo.comment) service.comment = serviceInfo.comment;
                if(serviceInfo.type) service.type = serviceInfo.type;
                if(serviceInfo.notCheckLogin) service.notCheckLogin = serviceInfo.notCheckLogin;
                if(serviceInfo.notCheckSQLInject) service.notCheckSQLInject = serviceInfo.notCheckSQLInject;
            }
            files.push(service);
        }
    }
    //按照先目录，后文件的排序
    for (let i = 0; i < dirs.length; i++) {
        let dirInfo = dirs[i];
        res.services.push(dirInfo);
        //this.getServices(req, res, projInfo, rootPath, curPath + (curPath=="" ? "" : "/") + dirInfo.path, dirInfo.id);
    }
    for (let i = 0; i < files.length; i++) {
        let service = files[i];
        res.services.push(service);
    }
    this.end(res);
};