var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs')
/**
 * 钉钉 企业微信 生成json文件
 */
var Get = function () {
    Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process = function (req, res) {
    var self = this;
    if (!req.filepath) {
        this.onLogicError(1, '请提供文件路径！', req, res);
        return;
    }

    let packageFilePath = utils.getPath('/app/' + req.filepath + "/package.json");
    if(fs.existsSync(packageFilePath)) {
        fs.readFile(packageFilePath,"utf-8",function(err, data) {
            let pkInfo = JSON.parse(data);
            res.projInfo = {
                name: pkInfo.name,
                comment: pkInfo.comment,
                createTime: pkInfo.createTime,
                createUser: pkInfo.createUser,
                lastUpdateTime: pkInfo.lastUpdateTime,
                lastUpdateUser: pkInfo.lastUpdateUser
            };
            self.getSetting(req, res);
        });
    } else {
        self.getSetting(req, res);
    }
};

Get.prototype.getSetting = function (req, res) {
    var self = this;
    res.data = {};
    let settingPath = utils.getPath('/app/' + req.filepath + '/setting.json');
    if(fs.existsSync(settingPath)) {
        fs.readFile('./app/' + req.filepath + '/setting.json', 'utf-8', function (err, data) {
            if (err) console.log(err);
            if (!data) {
                return self.end(res);
            }
            // 获取单个数据  getAny格式：  {wx:"corpid,agentid",dd:"corpid"}
            if (req.getAny) {
                data = JSON.parse(data);
                res.data = {};
                if (req.getAny.wx) {
                    res.data.wx = {}
                    req.getAny.wx = req.getAny.wx.split(',');
                    for (var x = 0; x < req.getAny.wx.length; x++) {
                        res.data.wx[req.getAny.wx[x]] = data.wx[req.getAny.wx[x]];
                    }
                }
                if (req.getAny.dd) {
                    res.data.dd = {}
                    req.getAny.dd = req.getAny.dd.split(',');
                    for (var x = 0; x < req.getAny.dd.length; x++) {
                        res.data.dd[req.getAny.dd[x]] = data.dd[req.getAny.dd[x]];
                    }
                }
            } else {
                res.data = data;
            }
            return self.end(res);
        });
    } else {
        this.end(res);
    }
};
