var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获得NPM模块列表
 */
var GetNpmModuleList = function() { 
  Service.call(this);
};

util.inherits(GetNpmModuleList, Service);

module.exports = GetNpmModuleList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetNpmModuleList.prototype.process =  function(req, res) {
  var dirPath = utils.getPath("/node_modules");

  var self = this;
  res.modules = [];
	fs.readdir(dirPath, function(err, list) {
    if(err) {
      self.onLogicError(1, '读取目录信息出错：'+err.message);
      return;
    }
    var pending = list.length;
    if (list.length==0) {
      self.end(res);
      return;
    }
    list.forEach(function(fileName) {
      var dir = path.resolve(dirPath, fileName);
      fs.stat(dir, function(err, stat) {
        if (stat) {
          if(stat.isDirectory()) {
            res.modules.push(fileName);
          } else {
            //
          }
        }
        if (!--pending) {
          self.end(res);
          return;
        }
      });
    });
  });
};