var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获得指定项目的所有数据模型列表
 */
var GetModels = function () {
  Service.call(this);
};

util.inherits(GetModels, Service);

module.exports = GetModels;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetModels.prototype.process = function (req, res) {
  if (!req.projCode) {
    this.onLogicError(1, '请提供项目代码！');
    return;
  }
  
  const rootPath = utils.getPath("/app/"+req.projCode+"/model");
  
  if(!fs.existsSync(rootPath)) {
    this.onLogicError(1, '请提供正确的项目代码！');
    return;
  }
  
  let projInfo = {
    models: {}
  };
  res.models = [];

  this.modelId = 0;

  let pkPath = utils.getPath("/app/"+req.projCode+"/package.json");
  if(fs.existsSync(pkPath)) {
    var self = this;
    fs.readFile(pkPath,"utf-8",function(err, data) {
      projInfo = JSON.parse(data);
      self.getModels(req, res, projInfo, rootPath, "", 0);
      self.end(res);
    });
  } else {
    this.getModels(req, res, projInfo, rootPath, "", 0);
    this.end(res);
  }
};

GetModels.prototype.getModels = function (req, res, projInfo, rootPath, curPath, pid) {
    let dirPath = rootPath;
    if(curPath!="") dirPath = rootPath+"/"+curPath;
    if(!fs.existsSync(dirPath)) return;
    let list = fs.readdirSync(dirPath);
    let dirs = [];
    let files = [];
    for (let i = 0; i < list.length; i++) {
        const fileName = list[i];
        let filePath = dirPath+"/"+fileName;
        let stat = fs.statSync(filePath);
        if (!stat) continue;
        if (stat.isDirectory()) {
            let dirInfo = {
                pid: pid,
                path: fileName,
                dir: 1
            };
            dirs.push(dirInfo);
        }
        if (stat.isFile()) {
            let model = {
                pid: pid,
                path: fileName
            };
            let modelPath = curPath + (curPath=="" ? "" : "/") + model.path;
            let modelInfo = projInfo.models[modelPath];
            if(modelInfo) {
                if(modelInfo.type) model.type = modelInfo.type;
                if(modelInfo.table) model.table = modelInfo.table;
                if(modelInfo.dbType) model.dbType = modelInfo.dbType;
                if(modelInfo.version) model.version = modelInfo.version;
                if(modelInfo.comment) model.comment = modelInfo.comment;
            }
            files.push(model);
        }
    }
    for (let i = 0; i < dirs.length; i++) {
        this.modelId++;
        let dirInfo = dirs[i];
        dirInfo.id = this.modelId;
        res.models.push(dirInfo);
        this.getModels(req, res, projInfo, rootPath, curPath + (curPath=="" ? "" : "/") + dirInfo.path, dirInfo.id);
    }
    for (let i = 0; i < files.length; i++) {
        this.modelId++;
        let model = files[i];
        model.id = this.modelId;
        res.models.push(model);
    }
};