var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获得文件和目录列表
 */
var GetFileList = function () {
  Service.call(this);
  this.sqlInject = {check: false};
  this.xssInject.exclude = ['dir'];
};

util.inherits(GetFileList, Service);

module.exports = GetFileList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetFileList.prototype.process = function (req, res) {
  if (!req.dir) {
    this.onLogicError(1, '请提供目录路径！');
    return;
  }
  res.sqlType = server.config.Database.type;

  req.dir = req.dir.replace(/\.\.\//g, '').replace(/\.\//g, '');

  let projCode = "";
  let fileType = "";
  let filePath = "";
  if(req.dir.indexOf("/model")>=0) {
    fileType = "model";
    filePath = req.dir.substring(5);
    projCode = filePath.substring(0, filePath.indexOf("/"));
    if(filePath.length>(projCode.length+7)) {
      filePath = filePath.substring(projCode.length+7);
    } else {
      filePath = "";
    }
  } else if(req.dir.indexOf("/service")>=0) {
    fileType = "service";
    filePath = req.dir.substring(5);
    projCode = filePath.substring(0, filePath.indexOf("/"));
    if(filePath.length>(projCode.length+9)) {
      filePath = filePath.substring(projCode.length+9);
    } else {
      filePath = "";
    }
  } else if(req.dir.indexOf("/web/app/")>=0) {
    fileType = "page";
    filePath = req.dir.substring(9);
    if(filePath.indexOf("/")>=0) {
      projCode = filePath.substring(0, filePath.indexOf("/"));
      filePath = filePath.substring(filePath.indexOf("/")+1);
    } else {
      projCode = filePath;
      filePath = "";
    }
  } else {
    this.getFiles(req, res, "", "", null);
    return;
  }

  const self = this;
  let packageFilePath = utils.getPath('/app/' + projCode + "/package.json");
  if(fs.existsSync(packageFilePath)) {
    fs.readFile(packageFilePath, "utf-8", function(err, data) {
      let pkInfo = JSON.parse(data);
      self.getFiles(req, res, filePath, fileType, pkInfo);
    });
  } else {
    let pkInfo = {
      name: projCode,
      models: {},
      services: {},
      pages: {}
    };
    self.getFiles(req, res, filePath, fileType, pkInfo);
  }
};

GetFileList.prototype.getFiles = function (req, res, filePath, fileType, pkInfo) {
  const self = this;
  res.dirs = [];
  res.files = [];
  let list = null;

  const dirPath = utils.getPath(req.dir);
  try {
    list = fs.readdirSync(dirPath);
  } catch (err) {
    // self.onLogicError(1, '读取目录信息出错：' + err.message);
    self.end(res);
    return;
  }

  for (let i = 0; i < list.length; i++) {
    const fileName = list[i];
    const dir = path.resolve(dirPath, fileName);
    const stat = fs.statSync(dir);
    if (!stat) continue;
    if (stat.isDirectory()) {
      res.dirs.push({ type: 'dir', name: fileName});
    }
    if (stat.isFile()) {
      if (req.exts){
        if(req.exts.contains(path.extname(fileName))) {
          res.files.push({ type: 'file', name: fileName});
        }
      } else {
        res.files.push({ type: 'file', name: fileName});
      }
    }
  }

  res.dirs.sort(utils.compare("name"));
  res.files.sort(utils.compare("name"));

  if(pkInfo) {
    for(let i=0;i<res.files.length;i++) {
      let fileInfo = res.files[i];
      let settingObj = pkInfo[fileType+"s"];
      let fileInfoPath = filePath+((filePath=="") ? "" : "/")+fileInfo.name;
      let fileSetting = settingObj[fileInfoPath];
      if(fileSetting) {
        if(fileType=="page") {
          if(fileSetting.title) fileInfo.comment = fileSetting.title;
        } else {
          if(fileSetting.comment) fileInfo.comment = fileSetting.comment;
        }
      }
    }
  }
  this.end(res);
};