var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获得文件内容
 */
var GetFileContent = function() { 
  Service.call(this);
  this.sqlInject = {check: false};
  this.xssInject.exclude = ['filePath'];
};

util.inherits(GetFileContent, Service);

module.exports = GetFileContent;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetFileContent.prototype.process =  function(req, res) {
  if(!req.filePath) {
    this.onLogicError(1, '请提供文件路径！');
    return;
  }

  req.filePath = req.filePath.replace(/\.\.\//g,'').replace(/\.\//g,'');
  //****************************************************** */
  //TODO  这里只能访问tasgine目录有关的文件，不能随意访问其他文件
  //****************************************************** */
  var filePath = utils.getPath(req.filePath);
  if(!fs.existsSync(filePath)) {
    this.onLogicError(2, '文件不存在！');
    return;
  }
  var self = this;
  fs.readFile(filePath,"utf-8",function(err, data) {
    res.data = data;
    if(filePath.endWith(".tfp") || filePath.endWith(".tbs") || filePath.endWith(".tdm")) {
      //res.data = JSON.stringify(JSON.parse(res.data));
    }
    self.end(res);
  });
};