var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获得指定项目的所有数据表单列表
 */
var GetDataForms = function () {
  Service.call(this);
};

util.inherits(GetDataForms, Service);

module.exports = GetDataForms;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetDataForms.prototype.process = function (req, res) {
  if (!req.projCode) {
    this.onLogicError(1, '请提供项目代码！');
    return;
  }

  res.forms = [];
  
  const rootPath = utils.getPath("/app/"+req.projCode+"/tdf");
  
  if(!fs.existsSync(rootPath)) {
    this.end(res);
    return;
  }
  
  let projInfo = {
    forms: {}
  };

  this.tdfId = 0;

  let pkPath = utils.getPath("/app/"+req.projCode+"/package.json");
  if(fs.existsSync(pkPath)) {
    var self = this;
    fs.readFile(pkPath,"utf-8",function(err, data) {
      projInfo = JSON.parse(data);
      if(!projInfo.forms) projInfo.forms = {};
      self.getForms(req, res, projInfo, rootPath, "", 0);
      self.end(res);
    });
  } else {
    this.getForms(req, res, projInfo, rootPath, "", 0);
    this.end(res);
  }
};

GetDataForms.prototype.getForms = function (req, res, projInfo, rootPath, curPath, pid) {
    let dirPath = rootPath;
    if(curPath!="") dirPath = rootPath+"/"+curPath;
    if(!fs.existsSync(dirPath)) return;
    let list = fs.readdirSync(dirPath);
    let dirs = [];
    let files = [];
    for (let i = 0; i < list.length; i++) {
        const fileName = list[i];
        let filePath = dirPath+"/"+fileName;
        let stat = fs.statSync(filePath);
        if (!stat) continue;
        if (stat.isDirectory()) {
            let dirInfo = {
                pid: pid,
                path: fileName,
                dir: 1
            };
            dirs.push(dirInfo);
        }
        if (stat.isFile()) {
            let tdf = {
                pid: pid,
                path: fileName
            };
            let tdfPath = curPath + (curPath=="" ? "" : "/") + tdf.path;
            let tdfInfo = projInfo.forms[tdfPath];
            if(tdfInfo) {
                if(tdfInfo.name) tdf.name = tdfInfo.name;
                if(tdfInfo.createTime) tdf.createTime = tdfInfo.createTime;
                if(tdfInfo.title) tdf.title = tdfInfo.title;
            }
            files.push(tdf);
        }
    }
    for (let i = 0; i < dirs.length; i++) {
        this.tdfId++;
        let dirInfo = dirs[i];
        dirInfo.id = this.tdfId;
        res.forms.push(dirInfo);
        this.getForms(req, res, projInfo, rootPath, curPath + (curPath=="" ? "" : "/") + dirInfo.path, dirInfo.id);
    }
    for (let i = 0; i < files.length; i++) {
        this.tdfId++;
        let tdf = files[i];
        tdf.id = this.tdfId;
        res.forms.push(tdf);
    }
};