var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 删除文件
 */
var DeleteFile = function() { 
  Service.call(this);
};

util.inherits(DeleteFile, Service);

module.exports = DeleteFile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DeleteFile.prototype.process =  function(req, res) {
	if(!req.path) {
    this.onLogicError(1, "请提供文件路径！");
    return;
  }

  var self = this;
  var filePath = utils.getPath(req.path);
  if(fs.existsSync(filePath)) {
    fs.unlinkSync(filePath);
  }

  let projCode = "";
  let fileType = "";
  filePath = "";
  if(req.path.indexOf("/model")>=0) {
    fileType = "model";
    filePath = req.path.substring(5);
    projCode = filePath.substring(0, filePath.indexOf("/"));
    filePath = filePath.substring(projCode.length+7);
  } else if(req.path.indexOf("/service")>=0) {
    fileType = "service";
    filePath = req.path.substring(5);
    projCode = filePath.substring(0, filePath.indexOf("/"));
    filePath = filePath.substring(projCode.length+9);
  } else if(req.path.indexOf("/tga")>=0) {
    fileType = "tga";
    filePath = req.path.substring(5);
    projCode = filePath.substring(0, filePath.indexOf("/"));
    filePath = filePath.substring(projCode.length+5);
  } else if(req.path.indexOf("/web/app/")>=0) {
    fileType = "page";
    filePath = req.path.substring(9);
    projCode = filePath.substring(0, filePath.indexOf("/"));
    filePath = filePath.substring(filePath.indexOf("/")+1);
  } else {
    this.end(res);
    return;
  }
  this.getPackageInfo(req, res, projCode, filePath, fileType);
};

DeleteFile.prototype.getPackageInfo = function (req, res, projCode, filePath, fileType) {
  var self = this;
  let packageFilePath = utils.getPath('/app/' + projCode + "/package.json");
  if(fs.existsSync(packageFilePath)) {
    fs.readFile(packageFilePath, "utf-8", function(err, data) {
      let pkInfo = JSON.parse(data);
      self.updatePackageInfo(req, res, filePath, fileType, pkInfo, packageFilePath);
    });
  } else {
    this.end(res);
  }
};

DeleteFile.prototype.updatePackageInfo = function (req, res, filePath, fileType, pkInfo, packageFilePath) {
  let settingObj = pkInfo[fileType+"s"];
  if(!settingObj) {
    this.end(res);
    return;
  }
  let fileSetting = settingObj[filePath];
  if(fileSetting) {
    delete settingObj[filePath];
    pkInfo.lastUpdateTime = new Date();
    pkInfo.lastUpdateUser = req.session.userName;
    utils.saveJSONToFile(packageFilePath, pkInfo);
  }
  this.end(res);
};