var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 删除项目
 */
var Delete = function () {
  Service.call(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Delete.prototype.process = function (req, res) {
  if (!req.code) {
    this.onLogicError(1, "请提供项目编码！");
    return;
  }

  var self = this;
  if (req.code.indexOf("/web/") >= 0 || req.code.indexOf("/app/") >= 0) {
    var dirPath = utils.getPath(req.code);
    if (fs.existsSync(dirPath)) {
      rmdir(dirPath, function () {
        // self.delServerDir(serverDir, res);
        self.end(res);
      });
    }
    else {
      //self.delServerDir(serverDir, res);
      self.end(res);
    }
  }
  else if (req.code.indexOf("/minisrc/") >= 0) {
    var miniDir = utils.getPath(req.code);
    var serverDir = utils.getPath(req.code.replace("/minisrc/", "/"));
    if (fs.existsSync(miniDir)) {
      rmdir(miniDir, function () {
        // self.delServerDir(serverDir, res);
        self.end(res);
      });
    }
    else {
      // self.delServerDir(serverDir, res);
      self.end(res);
    }
  }
  else {
    self.delServiceDir(req, res);
  }
};

Delete.prototype.delServiceDir = function (req, res) {
  var self = this;
  var dirPath = utils.getPath("/app/"+req.code);
  if (fs.existsSync(dirPath)) {
    rmdir(dirPath, function () {
      self.delWebDir(req, res);
    });
  }
  else {
    self.delWebDir(req, res);
  }
};

Delete.prototype.delWebDir = function (req, res) {
  var self = this;
  var dirPath = utils.getPath("/web/app/"+req.code);
  if (fs.existsSync(dirPath)) {
    rmdir(dirPath, function () {
      self.setProjectsFile(req, res);
    });
  }
  else {
    self.setProjectsFile(req, res);
  }
};

Delete.prototype.setProjectsFile = function (req, res) {
  var self = this;
  var projectsFilePath = utils.getPath("/app/projects.json");
  if (fs.existsSync(projectsFilePath)) {
      fs.readFile(projectsFilePath,"utf-8",function(err, data) {
          let projects = JSON.parse(data);
          if(projects[req.code]) {
            delete projects[req.code];
            fs.writeFileSync(projectsFilePath, JSON.stringify(projects, null, 2));
          }
          self.end(res);
      });
  } else {
    this.end(res);
  }
};

function rmdir(dir, callback) {
  fs.readdir(dir, (err, files) => {
    /**
     * @desc 内部循环遍历使用的工具函数
     * @param {Number} index 表示读取files的下标
     */
    function next(index) {
      // 如果index 等于当前files的时候说明循环遍历已经完毕，可以删除dir，并且调用callback
      if (index == files.length) return fs.rmdir(dir, callback)
      // 如果文件还没有遍历结束的话，继续拼接新路径，使用fs.stat读取该路径
      let newPath = path.join(dir, files[index])
      // 读取文件，判断是文件还是文件目录

      fs.stat(newPath, (err, stat) => {
        if (stat.isDirectory()) {
          // 因为我们这里是深度循环，也就是说遍历玩files[index]的目录以后，才会去遍历files[index+1]
          // 所以在这里直接继续调用rmdir，然后把循环下一个文件的调用放在当前调用的callback中
          rmdir(newPath, () => next(index + 1))
        } else {
          // 如果是文件，则直接删除该文件，然后在回调函数中调用遍历nextf方法，并且index+1传进去
          fs.unlink(newPath, () => next(index + 1))
        }
      })
    }
    next(0)
  })
}
