var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 添加后台资源
 */
var CreateServerRes = function() { 
  Service.call(this);
};

util.inherits(CreateServerRes, Service);

module.exports = CreateServerRes;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateServerRes.prototype.process =  function(req, res) {
  if(!req.type) {
    this.onLogicError(1, "请选择类型！");
    return;
  }
	if(!req.name) {
    this.onLogicError(2, "请提供名称！");
    return;
  }
  if(!req.path) {
    this.onLogicError(3, "请提供路径！");
    return;
  }
  if(req.type=="dir") {
    var dir = utils.getPath(req.path+"/"+req.name);
    dir =  dir.replace(/\\/g, '/');
    if(fs.existsSync(dir)) {
      this.onLogicError(4, "文件夹已存在！");
      return;
    }
    fs.mkdirSync(dir);
    this.end(res);
    return;
  }

	if(req.type=="null") {

    let fileName = req.name;
    let filePath = utils.getPath(req.path);
    if(fs.existsSync(filePath)) {
      this.onLogicError(4, "文件已存在！");
      return;
    }

    if(req.editType=="js") {
      this.createNullJs(req, res, fileName, filePath);
    } else {
      this.createNullTbs(req, res, fileName, filePath);
    }
  }
};

CreateServerRes.prototype.createNullTbs =  function(req, res, fileName, filePath) {
    var tbsName = fileName.substr(0, fileName.lastIndexOf("."));
    tbsName = tbsName.substr(0,1).toUpperCase()+tbsName.substr(1, tbsName.length-1);
    var tbs = {
      name: tbsName,
      reqArgs: [],
      retArgs: [],
      methods: [{
        name: "process",
        comment: "处理服务请求",
        args: [{
          name: "req",
          type: "object",
          comment: "服务请求对象"
        },{
          name: "res",
          type: "object",
          comment: "服务响应对象"
        }],
        statements: [{
          category: "common",
          type: "end"
        }]
      }]
    };

    fs.writeFileSync(filePath, JSON.stringify(tbs, null, "  "));

    this.end(res);
};

CreateServerRes.prototype.createNullJs =  function(req, res, fileName, filePath) {
  var name = fileName.substr(0, fileName.lastIndexOf("."));
  name = name.substr(0,1).toUpperCase()+name.substr(1, name.length-1);
  var str = 'var util = require(\'util\');\r\n'
    +'var Service = require(\'Service\');\r\n'
    +'var utils = require(\'utils\');\r\n'
    +'\r\n'
    +'var '+name+' = function() {\r\n'
    +'  Service.call(this);\r\n'
    +'};\r\n'
    +'\r\n'
    +'util.inherits('+name+', Service);\r\n'
    +'\r\n'
    +'module.exports = '+name+';\r\n'
    +'\r\n'
    +name+'.prototype.process =  function(req, res) {\r\n';
  str += '  if(!req.arg1) {\r\n';
  str += '    this.onLogicError(1, \'请提供参数1！\');\r\n';
  str += '    return;\r\n';
  str += '  }\r\n';
  str += '  this.end(res);\r\n';
  str += '};';

  fs.writeFileSync(filePath, str);

  this.end(res);
};