var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 创建空白报表文件
 */
var CreateReport = function() { 
  Service.call(this);
};

util.inherits(CreateReport, Service);

module.exports = CreateReport;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateReport.prototype.process =  function(req, res) {
  if(!req.path) {
    this.onLogicError(1, "请提供路径！");
    return;
  }
  if(!req.filename) {
    this.onLogicError(2, "请提供文件名称！");
    return;
  }
  if(req.filename.match(/[^\w]/g)) {
    this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
    return;
  }
  if(!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  
  let fileName = req.filename.endWith(".tpr") ? req.filename : req.filename+".tpr";
  let filePath = utils.getPath(req.path+"/"+fileName);
  if(fs.existsSync(filePath)) {
    this.onLogicError(11, "文件已存在！");
    return;
  }

	var tpr = {
    "pageSetting": {
      "row": {
        "len": parseInt(req.rowLen),
        "height": parseInt(req.rowHeight)
      },
      "col": {
        "len": parseInt(req.colLen),
        "width": parseInt(req.colWidth),
        "indexWidth": 60
      },
      "pageSize": parseInt(req.pageSize),
      "orientation": req.orientation,
      "paddingTop": parseInt(req.paddingTop),
      "paddingLeft": parseInt(req.paddingLeft)
    },
    "data": [
      {
        "name": "sheet1",
        "styles": [],
        "rows": {
          "len": parseInt(req.rowLen)
        },
        "cols": {
          "len": parseInt(req.colLen)
        },
        "validations": [],
        "autofilter": {}
      }
    ],
    "dataSources": [],
    "dataBindCells": {}
  };
  fs.writeFileSync(filePath, JSON.stringify(tpr, null, "\t"));

  this.end(res);
};