var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 创建空白打印报表文件
 */
var CreatePrintReport = function () {
    Service.call(this);
};

util.inherits(CreatePrintReport, Service);

module.exports = CreatePrintReport;

const PAGER_SIZES = {
    "A3": {
        "width": 297,
        "height": 420
    },
    "A4": {
        "width": 210,
        "height": 297
    },
    "A5": {
        "width": 148,
        "height": 210
    },
    "B4": {
        "width": 250,
        "height": 352
    },
    "B5": {
        "width": 176,
        "height": 250
    }
};

CreatePrintReport.prototype.mmToPx = function (mm, dpi = 96) {
    // 1 inch = 25.4 millimeters
    const inchPerMillimeter = 1 / 25.4;
    // 1 inch = dpi pixels
    const pixelsPerInch = dpi;
    // 转换为英寸
    const inches = mm * inchPerMillimeter;
    // 转换为像素
    const pixels = inches * pixelsPerInch;
    return parseInt(pixels);
}

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreatePrintReport.prototype.process = function (req, res) {
    if (!req.path) {
        this.onLogicError(1, "请提供路径！");
        return;
    }
    if (!req.filename) {
        this.onLogicError(2, "请提供文件名称！");
        return;
    }
    if (req.filename.match(/[^\w]/g)) {
        this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
        return;
    }
    if (!req.pageSize) {
        this.onLogicError(4, "请提供纸张大小！");
        return;
    }
    if (!req.orientation) {
        this.onLogicError(4, "请提供打印方向！");
        return;
    }
    if (req.pageSize == "Custom") {
        if (!req.pageWidth) {
            this.onLogicError(4, "请设置纸张宽度！");
            return;
        }
        if (!req.pageHeight) {
            this.onLogicError(4, "请设置纸张高度！");
            return;
        }
    }

    let fileName = req.filename.endWith(".tpr") ? req.filename : req.filename + ".tpr";
    let filePath = utils.getPath(req.path + "/" + fileName);
    if (fs.existsSync(filePath)) {
        this.onLogicError(11, "文件已存在！");
        return;
    }

    let pageWidth = 793;
    let pageHeight = 1122;
    if(req.pageSize=="Custom") {
        pageWidth = this.mmToPx(req.pageWidth);
        pageHeight = this.mmToPx(req.pageHeight);
    } else {
        let pageSize = PAGER_SIZES[req.pageSize];
        if(req.orientation=="portrait") {
            pageWidth = this.mmToPx(pageSize.width);
            pageHeight = this.mmToPx(pageSize.height);
        } else {
            pageWidth = this.mmToPx(pageSize.height);
            pageHeight = this.mmToPx(pageSize.width);
        }
    }
    let paddingTop = 0;
    let paddingLeft = 0;
    let paddingBottom = 0;
    let paddingRight = 0;
    if(req.paddingTop) paddingTop = this.mmToPx(req.paddingTop);
    if(req.paddingLeft) paddingLeft = this.mmToPx(req.paddingLeft);
    if(req.paddingBottom) paddingBottom = this.mmToPx(req.paddingBottom);
    if(req.paddingRight) paddingRight = this.mmToPx(req.paddingRight);
    let pageHeaderDisplay = "none";
    if(req.pageHeaderDisplay) pageHeaderDisplay = "flex";
    let pageFooterDisplay = "none";
    if(req.pageFooterDisplay) pageFooterDisplay = "flex";
    let pageHeaderHeight = 56;
    if(req.pageHeaderHeight) pageHeaderHeight = this.mmToPx(req.pageHeaderHeight);
    let pageFooterHeight = 56;
    if(req.pageFooterHeight) pageFooterHeight = this.mmToPx(req.pageFooterHeight);
    let reportHeaderHeight = 75;
    if(req.reportHeaderHeight) reportHeaderHeight = this.mmToPx(req.reportHeaderHeight);
    let reportFooterHeight = 75;
    if(req.reportFooterHeight) reportFooterHeight = this.mmToPx(req.reportFooterHeight);

    var tpr = {
        "client": "pc",
        "framework": "tfp",
        "positionType": "absolute",
        "pageType": "print-report",
        "bgColorMode": "light",
        "title": "打印报表",
        "type": "Page",
        "docType": "HTML5",
        "styles": {
            "background-color": "#CCCCCC"
        },
        "components": [
            {
                "type": "PrintReportPage",
                "id": "reportPage1",
                "styles": {
                    "display": "flex",
                    "width": pageWidth+"px",
                    "height": pageHeight+"px",
                    "font-size": "0",
                    "background-color": "#FFFFFF",
                    "box-shadow": "5px 5px 3px #999999",
                    "flex-direction": "column",
                    "justify-content": "flex-start",
                    "align-items": "flex-start",
                    "padding-bottom": paddingTop+"px",
                    "padding-left": paddingLeft+"px",
                    "padding-right": paddingBottom+"px",
                    "padding-top": paddingRight+"px",
                    "margin-top": "50px",
                    "margin-bottom": "50px",
                    "flex-grow": "0",
                    "flex-shrink": "0",
                    "flex-basis": "auto"
                },
                "components": [
                    {
                        "type": "FlexBox",
                        "id": "reportPage1_page_header",
                        "styles": {
                            "display": pageHeaderDisplay,
                            "width": "100%",
                            "-moz-box-sizing": "border-box",
                            "-webkit-box-sizing": "border-box",
                            "box-sizing": "border-box",
                            "padding-top": "0",
                            "padding-bottom": "0",
                            "padding-left": "0",
                            "padding-right": "0",
                            "flex-direction": "row",
                            "flex-grow": "0",
                            "flex-shrink": "0",
                            "flex-basis": "auto"
                        },
                        "class": "tfp-printreport-page-header",
                        "components": [
                            {
                                "id": "reportPage1_page_header_panel1",
                                "type": "FlexPanel",
                                "isAttached": true,
                                "styles": {
                                    "height": pageHeaderHeight+"px",
                                    "-moz-box-sizing": "border-box",
                                    "-webkit-box-sizing": "border-box",
                                    "box-sizing": "border-box",
                                    "display": "flex",
                                    "flex-wrap": "wrap",
                                    "align-items": "center",
                                    "flex-grow": "0",
                                    "flex-shrink": "0",
                                    "flex-basis": "33.3%",
                                    "justify-content": "flex-start"
                                },
                                "components": []
                            },
                            {
                                "id": "reportPage1_page_header_panel2",
                                "type": "FlexPanel",
                                "isAttached": true,
                                "styles": {
                                    "height": pageHeaderHeight+"px",
                                    "-moz-box-sizing": "border-box",
                                    "-webkit-box-sizing": "border-box",
                                    "box-sizing": "border-box",
                                    "display": "flex",
                                    "flex-wrap": "wrap",
                                    "align-items": "center",
                                    "flex-grow": "0",
                                    "flex-shrink": "0",
                                    "flex-basis": "33.4%",
                                    "justify-content": "center"
                                },
                                "components": []
                            },
                            {
                                "id": "reportPage1_page_header_panel3",
                                "type": "FlexPanel",
                                "isAttached": true,
                                "styles": {
                                    "height": pageHeaderHeight+"px",
                                    "flex-grow": "0",
                                    "flex-shrink": "0",
                                    "flex-basis": "33.3%",
                                    "display": "flex",
                                    "flex-wrap": "wrap",
                                    "align-items": "center",
                                    "justify-content": "flex-end"
                                },
                                "components": []
                            }
                        ]
                    },
                    {
                        "type": "Panel",
                        "id": "reportPage1_report_header",
                        "reportHeaderDisplay": "first",
                        "styles": {
                            "display": req.reportHeaderDisplay=="none" ? "none" : "",
                            "width": "100%",
                            "font-size": "0",
                            "flex-grow": "0",
                            "flex-shrink": "0",
                            "flex-basis": "auto",
                            "height": reportHeaderHeight+"px",
                            "position": "relative"
                        },
                        "class": "tfp-printreport-report-header",
                        "components": [],
                        "title": "表头"
                    },
                    {
                        "type": "Panel",
                        "id": "reportPage1_report_body",
                        "styles": {
                            "width": "100%",
                            "font-size": "0",
                            "flex-grow": "1",
                            "flex-shrink": "1",
                            "flex-basis": "auto",
                            "position": "relative"
                        },
                        "class": "tfp-printreport-report-body",
                        "components": [
                        ],
                        "title": "表体"
                    },
                    {
                        "type": "Panel",
                        "id": "reportPage1_report_footer",
                        "reportFooterDisplay": "first",
                        "styles": {
                            "display": req.reportFooterDisplay=="none" ? "none" : "",
                            "width": "100%",
                            "font-size": "0",
                            "flex-grow": "0",
                            "flex-shrink": "0",
                            "flex-basis": "auto",
                            "height": reportFooterHeight+"px",
                            "position": "relative"
                        },
                        "class": "tfp-printreport-report-footer",
                        "components": [],
                        "title": "表尾"
                    },
                    {
                        "type": "FlexBox",
                        "id": "reportPage1_page_footer",
                        "styles": {
                            "display": pageFooterDisplay,
                            "width": "100%",
                            "-moz-box-sizing": "border-box",
                            "-webkit-box-sizing": "border-box",
                            "box-sizing": "border-box",
                            "padding-top": "0",
                            "padding-bottom": "0",
                            "padding-left": "0",
                            "padding-right": "0",
                            "flex-direction": "row",
                            "flex-grow": "0",
                            "flex-shrink": "0",
                            "flex-basis": "auto"
                        },
                        "class": "tfp-printreport-page-footer",
                        "components": [
                            {
                                "id": "reportPage1_page_footer_panel1",
                                "type": "FlexPanel",
                                "isAttached": true,
                                "styles": {
                                    "height": pageFooterHeight+"px",
                                    "-moz-box-sizing": "border-box",
                                    "-webkit-box-sizing": "border-box",
                                    "box-sizing": "border-box",
                                    "display": "flex",
                                    "flex-wrap": "wrap",
                                    "align-items": "center",
                                    "flex-grow": "0",
                                    "flex-shrink": "0",
                                    "flex-basis": "33.3%",
                                    "justify-content": "flex-start"
                                },
                                "components": []
                            },
                            {
                                "id": "reportPage1_page_footer_panel2",
                                "type": "FlexPanel",
                                "isAttached": true,
                                "styles": {
                                    "height": pageFooterHeight+"px",
                                    "-moz-box-sizing": "border-box",
                                    "-webkit-box-sizing": "border-box",
                                    "box-sizing": "border-box",
                                    "display": "flex",
                                    "flex-wrap": "wrap",
                                    "align-items": "center",
                                    "flex-grow": "0",
                                    "flex-shrink": "0",
                                    "flex-basis": "33.4%",
                                    "justify-content": "center"
                                },
                                "components": [
                                    {
                                        "id": "printReportPageNumber1",
                                        "type": "PrintReportPageNumber",
                                        "styles": {
                                            "margin-left": "10px",
                                            "margin-right": "10px"
                                        },
                                        "value": "{页码}"
                                    },
                                    {
                                        "id": "label9",
                                        "type": "Label",
                                        "value": "/",
                                        "iconSize": 20,
                                        "iconRadius": 4,
                                        "styles": {
                                            "line-height": "30px"
                                        }
                                    },
                                    {
                                        "id": "printReportPageCount1",
                                        "type": "PrintReportPageCount",
                                        "styles": {
                                            "margin-left": "10px",
                                            "margin-right": "10px"
                                        },
                                        "value": "{页数}"
                                    }
                                ]
                            },
                            {
                                "id": "reportPage1_page_footer_panel3",
                                "type": "FlexPanel",
                                "isAttached": true,
                                "styles": {
                                    "height": pageFooterHeight+"px",
                                    "flex-grow": "0",
                                    "flex-shrink": "0",
                                    "flex-basis": "33.3%",
                                    "display": "flex",
                                    "flex-wrap": "wrap",
                                    "align-items": "center",
                                    "justify-content": "flex-end"
                                },
                                "components": []
                            }
                        ]
                    }
                ],
                "pageHeaderHidden": pageHeaderDisplay=="none" ? true : false,
                "pageHeaderHeight": req.pageHeaderHeight ? req.pageHeaderHeight : 10,
                "reportHeaderDisplay": req.reportHeaderDisplay,
                "reportHeaderHeight": req.reportHeaderHeight ? req.reportHeaderHeight : 20,
                "reportFooterDisplay": req.reportFooterDisplay,
                "reportFooterHeight": req.reportFooterHeight ? req.reportFooterHeight : 20,
                "pageFooterHidden": pageFooterDisplay=="none" ? true : false,
                "pageFooterHeight": req.pageFooterHeight ? req.pageFooterHeight : 10,
                "pageSize": req.pageSize,
                "orientation": req.orientation,
                "paddingTop": req.paddingTop,
                "paddingBottom": req.paddingBottom,
                "paddingLeft": req.paddingLeft,
                "paddingRight": req.paddingRight
            }
        ],
        "id": "page1",
        "cptDataBindSetting": {}
    };
    fs.writeFileSync(filePath, JSON.stringify(tpr, null, "\t"));

    this.end(res);
};