var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 添加
 */
var CreateDir = function () {
    Service.call(this);
};

util.inherits(CreateDir, Service);

module.exports = CreateDir;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDir.prototype.process = function (req, res) {
    if (!req.name) {
        this.onLogicError(2, "请提供文件夹名称！");
        return;
    }
    if (!req.path) {
        this.onLogicError(3, "请提供文件夹路径！");
        return;
    }
    var dir = utils.getPath(req.path);
    dir = dir.replace(/\\/g, '/');
    if (!fs.existsSync(dir)) fs.mkdirSync(dir);
    dir += "/" + req.name;
    if (fs.existsSync(dir)) {
        this.onLogicError(4, "文件夹已存在！");
        return;
    }
    fs.mkdirSync(dir);
    this.end(res);
};