var utils = require('utils');
var TFPHandler = require('TFPHandler');
var Module = require('module');
var Tasgine = require('Tasgine');
var fs = require('fs');
var path = require('path');
var UglifyJS = require("../../../../node_modules/uglify-js/tools/node.js");

var CompressJS = function () {
    this.projCode = "";
    this.fileList = [];
};

module.exports = CompressJS;

CompressJS.prototype.process = function (projCode) {
    if (process.argv.length < 3) {
        console.log("请提供项目代码，示例：");
        console.log("tasgine compressjs jxc");
        return;
    }
    this.projCode = process.argv[2];
    global.server = new Tasgine();
    global.server.config = require('../../../../config/Tasgine.json');
    global.server.moduleLoader = new Module('Tasgine');

    var Logger = require('Logger');
    global.logger = new Logger();
    global.logger.serverType = 'JSCompress';
    global.logger.setConfig(server.config.Logger);
    global.logger.start();

    console.log("正在分析项目文件结构...");
    this.getFileList(utils.getPath("/app/" + this.projCode + "/service_src"));
    if (this.fileList.length == 0) {
        console.log("未找到js文件。");
        return;
    }
    console.log("共找到 " + this.fileList.length + " 个js文件，开始压缩...");
    this.startTime = new Date();
    this.compressJS(0);
}

CompressJS.prototype.getFileList = function (dirPath, cb) {
    let list = fs.readdirSync(dirPath);
    if (list.length == 0) return;
    for (var i = 0; i < list.length; i++) {
        let pathName = path.join(dirPath, "/" + list[i]);
        let stat = fs.statSync(pathName);
        if (stat.isFile()) {
            if (path.extname(pathName) == ".js") this.fileList.push(pathName);
        } else {
            this.getFileList(pathName);
        }
    }
}

function formatDuring(mss) {
    if (mss < 1000) return mss + " 毫秒";
    var days = parseInt(mss / (1000 * 60 * 60 * 24));
    var hours = parseInt((mss % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = parseInt((mss % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = ((mss % (1000 * 60)) / 1000).toFixed(0);
    let ret = "";
    if (days > 0) ret = days + " 天 ";
    if (hours > 0 || days > 0) ret += hours + " 小时 ";
    if (minutes > 0 || hours > 0 || days > 0) ret += minutes + " 分钟 ";
    ret += seconds + " 秒 ";
    return ret;
}

CompressJS.prototype.compressJS = function (index) {
    if (index >= this.fileList.length) {
        console.log("项目[" + this.projCode + "]的所有js文件都已压缩完毕！");
        this.endTime = new Date();
        console.log("共压缩 " + this.fileList.length + " 个js文件，总用时：" + formatDuring(this.endTime - this.startTime));
        logger.isRunning = false;
        return;
    }
    let filePath = this.fileList[index];
    let urlPath = filePath.substr(filePath.indexOf("\\app")).replace(/\\/g, '/');
    console.log('正在压缩文件：' + urlPath);
    var self = this;
    fs.readFile(filePath, "utf-8", function (err, data) {
        if (err) {
            logger.log(err);
            return;
        }

        let result = "";
        try {
            result = UglifyJS.minify(data);
        } catch (e) {
            logger.log(e);
            return;
        }

        self.createJsFile(filePath, result.code, index);
    });
}

CompressJS.prototype.createJsFile = function (filePath, js, index) {
    logger.log("正在保存" + filePath + "...");

    //创建目录结构
    let srcRootDir = utils.getPath("/app/" + this.projCode + "/service_src");
    let desDir = utils.getPath("/app/" + this.projCode + "/service");
    let desFile = filePath.replace(/\\/g, "/").replace("service_src", "service");
    let dirDist = path.dirname(desFile).replace(desDir, "");
    var arrDir = dirDist.split("/");
    try {
        for (let i = 0; i < arrDir.length; i++) {
            if (arrDir[i] == "") continue;
            desDir += "/" + arrDir[i];
            if (!fs.existsSync(desDir)) fs.mkdirSync(desDir);
        }
    } catch (err) {
        logger.log(err);
        return;
    }

    var self = this;
    fs.open(desFile, 'w+', (err, fd) => {
        if (err) {
            logger.log(err);
            fs.closeSync(fd);
            return;
        }
        fs.write(fd, js, (err2) => {
            fs.closeSync(fd);
            if (err2) {
                logger.log(err2);
                return;
            }
            logger.log(desFile + "保存完毕。");
            self.compressJS(index + 1);
        });
    });
};