/**
 * TFP编译器
 */
var TaskFrontPageCompiler = function () {
  //
};

/**
 * 设置扩展控制器
 * @param {[type]} taskUI  [description]
 * @param {[type]} extCtls [description]
 * @param {[type]} cdm      [description]
 */
TaskFrontPageCompiler.prototype.setTfpIncludeFiles = function (_taskUI, tfp, cdm, cssFiles, jsFiles) {
  if (!cdm.type) return;
  let cptTypeInfo = _taskUI.type(cdm.type);
  if (!cptTypeInfo) return;

  if (cptTypeInfo.cssFile) {
    if (typeof (cptTypeInfo.cssFile) === "string") {
      let cssFile = cptTypeInfo.cssFile.replace("{clientType}", tfp.client);
      if (!cssFiles.contains(cssFile)) cssFiles.push(cssFile);
    } else if (Array.isArray(cptTypeInfo.cssFile)) {
      for (var i = 0; i < cptTypeInfo.cssFile.length; i++) {
        let cssFile = cptTypeInfo.cssFile[i].replace("{clientType}", tfp.client);
        if (!cssFiles.contains(cssFile)) cssFiles.push(cssFile);
      }
    }
  }
  if (cptTypeInfo.jsFile) {
    if (typeof (cptTypeInfo.jsFile) === "string") {
      let jsFile = cptTypeInfo.jsFile.replace("{clientType}", tfp.client);
      if (!jsFiles.contains(jsFile)) jsFiles.push(jsFile);
    } else if (Array.isArray(cptTypeInfo.jsFile)) {
      for (var i = 0; i < cptTypeInfo.jsFile.length; i++) {
        let jsFile = cptTypeInfo.jsFile[i].replace("{clientType}", tfp.client);
        if (!jsFiles.contains(jsFile)) jsFiles.push(jsFile);
      }
    }
  }
  if (cptTypeInfo.controllerFile) {
    if (!jsFiles.contains(cptTypeInfo.controllerFile)) jsFiles.push(cptTypeInfo.controllerFile);
  }
  if (!cdm.components) return;
  for (var i = 0; i < cdm.components.length; i++) {
    this.setTfpIncludeFiles(_taskUI, tfp, cdm.components[i], cssFiles, jsFiles);
  }
};

TaskFrontPageCompiler.prototype.getTfpIncludeFiles = function (_taskUI, tfp) {
  let cssFiles = [];
  let jsFiles = [];
  this.setTfpIncludeFiles(_taskUI, tfp, tfp, cssFiles, jsFiles);
  return { cssFiles: cssFiles, jsFiles: jsFiles };
};

/**
 * 获得TFP页面HTML代码
 * @param  {[type]} tfp [description]
 * @param  {[type]} url [description]
 * @return {[type]}     [description]
 */
TaskFrontPageCompiler.prototype.compile = function (_taskUI, tfp, url) {
  let htmlDoc = {
    url: url,
    head: "",
    body: ""
  };
  htmlDoc.head = "\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\r\n";
  if (tfp.client == "phone") htmlDoc.head += "\t<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\" />\r\n";
  if (tfp.title) {
    htmlDoc.head += "\t<title>" + tfp.title + "</title>\r\n";
  } else {
    htmlDoc.head += "\t<title></title>\r\n";
  }
  //添加taskUI公共样式
  htmlDoc.head += "\t<link href=\"/inc/taskui/taskui.css\" rel=\"stylesheet\" type=\"text/css\" />\r\n";
  if (tfp.client == "phone") {
    htmlDoc.head += "\t<link href=\"/inc/taskui/taskui_phone.css\" rel=\"stylesheet\" type=\"text/css\" />\r\n";
  } else if (tfp.client == "pc") {
    //htmlDoc.head += "\t<link href=\"/inc/taskui/taskui_pc.css\" rel=\"stylesheet\" type=\"text/css\" />\r\n";
  }

  //获得组件的扩展css文件和js文件
  let includeFiles = this.getTfpIncludeFiles(_taskUI, tfp);

  for (var i = 0; i < includeFiles.cssFiles.length; i++) {
    htmlDoc.head += "\t<link href=\"" + includeFiles.cssFiles[i] + "\" rel=\"stylesheet\" type=\"text/css\" />\r\n";
  }
  //添加当前页面引用的外部CSS样式文件
  if (tfp.cssFiles) {
    for (var i = 0; i < tfp.cssFiles.length; i++) {
      htmlDoc.head += "\t<link href=\"" + tfp.cssFiles[i] + "\" rel=\"stylesheet\" type=\"text/css\" />\r\n";
    }
  }
  //添加公共JS文件
  htmlDoc.head += "\t<script src=\"/inc/jquery-1.11.2.min.js\" type=\"text/javascript\"></script>\r\n";
  htmlDoc.head += "\t<script src=\"/inc/taskui/components.js\" type=\"text/javascript\"></script>\r\n";
  htmlDoc.head += "\t<script src=\"/inc/taskui/controller.js\" type=\"text/javascript\"></script>\r\n";
  htmlDoc.head += "\t<script src=\"/inc/taskui/taskui.js\" type=\"text/javascript\"></script>\r\n";
  if (tfp.client == "phone") {
    htmlDoc.head += "\t<script src=\"/inc/taskui/taskmsg_mobile.js\" type=\"text/javascript\"></script>\r\n";
    htmlDoc.head += "\t<script src=\"/inc/taskui/components_phone.js\" type=\"text/javascript\"></script>\r\n";
    htmlDoc.head += "\t<script src=\"/inc/taskui/controller_phone.js\" type=\"text/javascript\"></script>\r\n";
  } else if (tfp.client == "pc") {
    htmlDoc.head += "\t<script src=\"/inc/taskui/components_pc.js\" type=\"text/javascript\"></script>\r\n";
    htmlDoc.head += "\t<script src=\"/inc/taskui/controller_pc.js\" type=\"text/javascript\"></script>\r\n";
  }
  //添加组件扩展的JS文件
  for (var i = 0; i < includeFiles.jsFiles.length; i++) {
    htmlDoc.head += "\t<script src=\"" + includeFiles.jsFiles[i] + "\" type=\"text/javascript\"></script>\r\n";
  }
  //添加当前页面引用的外部JS文件
  if (tfp.jsFiles) {
    for (var i = 0; i < tfp.jsFiles.length; i++) {
      htmlDoc.head += "\t<script src=\"" + tfp.jsFiles[i] + "\" type=\"text/javascript\"></script>\r\n";
    }
  }
  //设置当前页面的CSS样式
  htmlDoc.head += "\t<style>\r\n";
  if (tfp.styleSheets) {
    for (var i = 0; i < tfp.styleSheets.length; i++) {
      let ss = tfp.styleSheets[i];
      htmlDoc.head += "\t\t" + ss.id + " {\r\n";
      if (ss.styles) {
        for (var j = 0; j < ss.styles.length; j++) {
          let s = ss.styles[j];
          htmlDoc.head += "\t\t\t" + s.name + ": " + s.value + ";\r\n";
        }
      }
      htmlDoc.head += "\t\t}\r\n";
    }
  }
  htmlDoc.cptStyles = [];
  //获得页面主体部分的html代码，并将各个组件的css样式保存在htmlDoc.cptStyles中
  htmlDoc.body = _taskUI.components[tfp.id].getHtml(true, htmlDoc);
  if (htmlDoc.cptStyles.length > 0) {
    for (var i = 0; i < htmlDoc.cptStyles.length; i++) {
      let ss = htmlDoc.cptStyles[i];
      htmlDoc.head += "\t\t" + ss.id + " {" + ss.value + "}\r\n";
    }
  }
  htmlDoc.head += "\t</style>\r\n";
  htmlDoc.head += "\t<script type=\"text/javascript\">\r\n";
  htmlDoc.head += "\t\tvar __tfpDataModel = " + JSON.stringify(tfp, function (key, value) {
    if (["cssFiles", "jsFiles", "jsGlobalVars", "jsFuncs",
      'styles', "styleSheets", '_pid', '_level'].contains(key)) {
      return undefined;
    }
    return value;
  }, "") + ";\r\n";
  if (tfp.jsGlobalVars || tfp.jsFuncs) {
    if (tfp.jsGlobalVars) {
      for (var i = 0; i < tfp.jsGlobalVars.length; i++) {
        let v = tfp.jsGlobalVars[i];
        htmlDoc.head += "\t\tvar " + v.name;
        if (v.value) htmlDoc.head += " = " + v.value;
        htmlDoc.head += ";\r\n";
      }
    }
    if (tfp.jsFuncs) {
      for (var i = 0; i < tfp.jsFuncs.length; i++) {
        let func = tfp.jsFuncs[i];
        htmlDoc.head += "\t\tfunction " + func.name + "(";
        for (var j = 0; j < func.args.length; j++) {
          if (j > 0) htmlDoc.head += " , ";
          htmlDoc.head += func.args[j].name;
        }
        htmlDoc.head += ") {\r\n";
        if (func.code) htmlDoc.head += "\t\t" + func.code.replace(/\n/g, "\n\t\t");
        htmlDoc.head += "}\r\n";
      }
    }
  }
  htmlDoc.head += "\t</script>\r\n";

  var html = "<html>\r\n<head>\r\n" + htmlDoc.head + "</head>\r\n<body class=\"taskui-page";
  if (tfp.class) html += " " + tfp.class;
  html += "\"";
  if (tfp.style || tfp.styles) {
    html += " style=\"";
    if (tfp.styles) {
      for (style in tfp.styles) {
        html += style + ": " + tfp.styles[style] + "; ";
      }
    }
    if (tfp.style) html += tfp.style;
    html += "\"";
  }
  let pageInfo = _taskUI.type("page");
  for (var i = 0; i < pageInfo.events.length; i++) {
    let eventName = pageInfo.events[i].name;
    if (tfp[eventName] && eventName != "onload")
      html += " " + eventName + "=\"" + tfp[eventName] + "\"";
  }
  html += ">\r\n" + htmlDoc.body + "</body>\r\n</html>";
  htmlDoc.head = null;
  htmlDoc.body = null;

  return html;
};

if (typeof (ipcRenderer) == 'undefined' && typeof (module) != 'undefined' && module.exports) {
  module.exports = TaskFrontPageCompiler;
}