var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 添加项目
 */
var AddProduct = function () {
  Service.call(this);
};

util.inherits(AddProduct, Service);

module.exports = AddProduct;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
AddProduct.prototype.process = function (req, res) {
  if (!req.code) {
    this.onLogicError(1, "请提供产品代码！");
    return;
  }
  if(req.code.match(/[^\w]/g)) {
    this.onLogicError(2, "产品代码只能包含字母、数字或下划线！");
    return;
  }
  if (!req.name) {
    this.onLogicError(3, "请提供产品名称！");
    return;
  }
  if (!req.version) {
    this.onLogicError(4, "请提供产品版本！");
    return;
  }
  if (!req.description) {
    this.onLogicError(5, "请提供产品描述！");
    return;
  }

  //TODO 创建产品所需要的其他业务校验
  //...
  
  var self = this;
  //连接任讯应用市场服务器，创建应用
  this.createAppPackage(req, res);
};

//用HTTP请求连接运营服务器，判断该组织是否已存在同名或相同code的产品
AddProduct.prototype.createAppPackage = function (req, res) {
  var self = this;
  //向运营服务器发送请求
  this.sendHttpRequest({
    "urlPath": "http://market.taskmsg.com/Service",
    "method": "post",
    "retToJson": true,
    "headers": {
      "Content-Type": "application/json"
    },
    "postdata": {
        "service": "om/service/createApp",
        "code": req.code,
        "name": req.name,
        "version": req.version,
        "description": req.description
    }
  },
  function(reqHttp, resHttp, errHttp, retHttp) {
    let ret = JSON.parse(retHttp);
    if(ret.code!=0) {
      self.onLogicError(6, ret.message);
      return;
    }
    //如果已经存在，则终止服务
    //如果不存在，则创建产品相应的目录
    self.createDir(req, res);
  });
    
};

AddProduct.prototype.createDir = function (req, res) {
  let orgCode = req.session.orgCode;
  
  //创建当前组织的后台服务目录
  var orgDir = utils.getPath("/app/" + orgCode);
  //判断后台服务目录有没有当前组织的目录，如果没有，则创建
  if (!fs.existsSync(orgDir)) fs.mkdirSync(orgDir);
  var productDir = orgDir+"/"+req.code;
  //判断后台服务目录的当前组织目录中是否已经存在相同code的目录，如果已经存在，则退出
  if (fs.existsSync(productDir))  {
    this.onLogicError(11, "产品目录["+req.code+"]已存在！");
    return;
  }
  fs.mkdirSync(productDir);

  //创建产品包文件
  var configFile = productDir + "/package.json";
  fs.writeFileSync(configFile, JSON.stringify({
    code: req.code,
    name: req.name,
    version: req.version,
    description: req.description,
    org: {
        code: req.session.orgCode
    }
  }, null, 2));

  //创建数据模型目录
  var modelDir = productDir + "/model";
  if (!fs.existsSync(modelDir)) fs.mkdirSync(modelDir);

  //创建业务服务目录
  var serviceDir = productDir + "/service";
  if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);

  //创建前端web目录
  var webOrgDir = utils.getPath("/web/app/" +orgCode);
  if (!fs.existsSync(webOrgDir)) fs.mkdirSync(webOrgDir);
  var webDir = webOrgDir+"/"+ req.code;
  if (!fs.existsSync(webDir)) fs.mkdirSync(webDir);

  //创建小程序目录
  var miniDir = utils.getPath("/minisrc/" + req.code);
  if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);
  var miniprogramDir = utils.getPath("/miniprogram/" + req.code);
  if (!fs.existsSync(miniprogramDir)) fs.mkdirSync(miniprogramDir);

  this.end(res);
};