var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 添加项目
 */
var Add = function () {
  Service.call(this);
};

util.inherits(Add, Service);

module.exports = Add;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Add.prototype.process = function (req, res) {
  if (!req.code) {
    this.onLogicError(1, "请提供项目代码！");
    return;
  }
  req.code = req.code.trim();
  if (req.code.length<2) {
    this.onLogicError(1, "项目代码至少需要两个字符！");
    return;
  }
  if(req.code.match(/[^\w]/g)) {
    this.onLogicError(2, "项目代码只能包含字母、数字或下划线！");
    return;
  }
  if(["sys","system","dev","im","netdisk","demo","om"].contains(req.code)) {
    this.onLogicError(1, req.code+"为系统项目代码，不能使用！");
    return;
  }
  if (!req.comment) {
    this.onLogicError(1, "请提供项目说明！");
    return;
  }
  req.comment = req.comment.trim();
  var webDir = utils.getPath("/web/app/" + req.code);
  if (!fs.existsSync(webDir)) fs.mkdirSync(webDir);
  var serverDir = utils.getPath("/app/" + req.code);
  if (!fs.existsSync(serverDir)) fs.mkdirSync(serverDir);
  var modelDir = utils.getPath("/app/" + req.code + "/model");
  if (!fs.existsSync(modelDir)) fs.mkdirSync(modelDir);
  var daoDir = utils.getPath("/app/" + req.code + "/dao");
  if (!fs.existsSync(daoDir)) fs.mkdirSync(daoDir);
  var serviceDir = utils.getPath("/app/" + req.code + "/service");
  if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
  var configFile = utils.getPath("/app/" + req.code + "/config.json");
  fs.writeFileSync(configFile, JSON.stringify({}, null, 2));
  let pkInfo = {
    name: req.code,
    comment: req.comment,
    serviceLanguage: "js",
    createTime: new Date(),
    createUser: req.session.userName,
    models: {},
    services: {},
    pages: {}
  };
  if(req.serviceLanguage=="java") pkInfo.serviceLanguage = "java";
  var pkFile = utils.getPath("/app/" + req.code + "/package.json");
  fs.writeFileSync(pkFile, JSON.stringify(pkInfo, null, 2));

  var miniDir = utils.getPath("/minisrc/" + req.code);
  if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);
  var miniprogramDir = utils.getPath("/miniprogram/" + req.code);
  if (!fs.existsSync(miniprogramDir)) fs.mkdirSync(miniprogramDir);
  
  var projects = {};
  var self = this;
  var projectsFilePath = utils.getPath("/app/projects.json");
  if (fs.existsSync(projectsFilePath)) {
    fs.readFile(projectsFilePath,"utf-8",function(err, data) {
      projects = JSON.parse(data);
      self.setProjectsFile(req, res, projectsFilePath, projects);
    });
  } else {
    self.setProjectsFile(req, res, projectsFilePath, projects);
  }
};

Add.prototype.setProjectsFile = function (req, res, projectsFilePath, projects) {
  projects[req.code] = {
    name: req.code,
    comment: req.comment,
    createTime: new Date(),
    createUser: req.session.userName
  };
  fs.writeFileSync(projectsFilePath, JSON.stringify(projects, null, 2));
  this.end(res);
};