var fs= require('fs');
var fsex = require("fs-extra");//替代fs
var path = require('path');
var crypto = require('crypto');
const uuid = require('./uuid.js');

var utilExt = module.exports;

Array.prototype.getAppRootDir = function (obj) {
};

/**
 * 判断数组中是否存在指定的元素
 * @param  {[type]} obj [description]
 * @return {[type]}     [description]
 */
Array.prototype.contains = function (obj) {
  var i = this.length;
  while (i--) {
    if (this[i] === obj) {
        return true;
    }
  }
  return false;
};

/**
 * 删除数组中指定的元素
 * @param  {[type]} obj [description]
 * @return {[type]}     [description]
 */
Array.prototype.remove = Array.prototype.deleteMember = function (obj) {
  for(var i=0;i<this.length;i++) {
    if (this[i] === obj) {
        this.splice(i,1);
        return;
    }
  }
};

Date.prototype.format = function (style) { 
  return utilExt.formatDate(this, style); 
};

Date.prototype.diff = function (endTime, diffType) { 
  return utilExt.dateDiff(this, endTime, diffType); 
};

Date.prototype.toJSON = function () { 
  return utilExt.formatDate(this, 'yyyy-MM-dd hh:mm:ss'); 
};

String.prototype.trim = function () { 
  return this.replace(/(^\s*)|(\s*$)/g,""); 
};

String.prototype.toDate = function () { 
  return new Date(this.replace(/-/g, '/'));
};

String.prototype.toIntArray = function (exclude) { 
  return utilExt.strToIntArray(this, exclude);
};

String.prototype.endWith = function (strSub) { 
  return utilExt.endWith(this, strSub);
};

String.prototype.startWith = function (strSub) { 
  return utilExt.startWith(this, strSub);
};

String.prototype.haveEmoji = function () { 
  return utilExt.isExistEmoji(this);
};

String.prototype.haveEspecialChar = function () { 
  return utilExt.haveEspecialChar(this);
};

//计算字符串长度(英文占1个字符，中文汉字占2个字符)
String.prototype.gblen = function() {  
  var len = 0;  
  for (var i=0; i<this.length; i++) {  
    if (this.charCodeAt(i)>127 || this.charCodeAt(i)==94) {  
      len += 2;  
    } else {  
      len ++;  
    }  
  }  
  return len;  
};

/**
 * 记录日志
 * @param  {String} type 日志类型
 * @param  {String} msg  日志信息
 */
utilExt.log =  function(type, msg) {
  console.log('['+type+'] ['+this.formatDate((new Date()),'yyyy-MM-dd hh:mm:ss')+'] '+msg);
};

/**
 * 记录错误日志
 * @param  {String} type 日志类型
 * @param  {String} msg  日志信息
 * @param  {Error}  err  错误对象
 */
utilExt.logError =  function(type, msg, err) {
  utilExt.log(type, msg+'\r\n'+err.stack);
};

/**
 * 记录Socket日志
 * @param  {String} type   日志类型
 * @param  {Object} socket Socket对象
 * @param  {String} msg    日志信息
 */
utilExt.logSocket =  function(type, socket, msg) {
  try {
    utilExt.log(type, '['+socket.remoteAddress+':'+socket.remotePort+'] '+msg);
  } catch(e) {
    console.log(e.message);
  }
};

/**
 * 格式化日期
 * @param  {Date}   date  日期对象
 * @param  {String} style 日期格式，例如：yyyy-MM-dd hh:mm:ss
 * @return {String}       格式化之后的字符串
 */
utilExt.formatDate = function(date, style) {   
  var y = date.getFullYear();    
  var M = "0" + (date.getMonth() + 1);    
  M = M.substring(M.length - 2);   
  var d = "0" + date.getDate();   
  d = d.substring(d.length - 2);    
  var h = "0" + date.getHours();    
  h = h.substring(h.length - 2);    
  var m = "0" + date.getMinutes();    
  m = m.substring(m.length - 2);   
  var s = "0" + date.getSeconds();    
  s = s.substring(s.length - 2);   
  return style.replace('yyyy', y).replace('MM', M).replace('dd', d).replace('hh', h).replace('mm', m).replace('ss', s).replace('S', date.getMilliseconds());   
};

/**
 * 字符串转换为日期
 * @param  {[type]} str [description]
 * @return {[type]}     [description]
 */
utilExt.strToDate = function(str) {
  return new Date(str.replace(/-/g, '/'));
};

/**
 * 出掉字符串首尾的空格
 * @param  {String} str 处理前的字符串
 * @return {String}     处理后的字符串
 */
utilExt.trimStr = function(str) {
  return str.replace(/(^\s*)|(\s*$)/g,"");
};

/**
 * 判断是否是整数
 * @param  {[type]}  i [description]
 * @return {Boolean}   [description]
 */
utilExt.isInt = function(i) {
  return i == parseInt(i);
};

/**
 * 判断是否是有效的手机号
 * @param  {String}  num 手机号字符串
 * @return {Boolean}     判断结果
 */
utilExt.isPhone = function(num) {
  var partten = /^1\d{10}$/;
  if(partten.test(num)) return true;
  return false;
};

/**
 * 判断是否是有效的邮箱地址
 * @param  {String}  mail 邮箱地址字符串
 * @return {Boolean}      判断结果
 */
utilExt.isEmail = function(mail) {
  var partten = /^[a-z0-9]+([._\\-]*[a-z0-9])*@([a-z0-9]+[-a-z0-9]*[a-z0-9]+.){1,63}[a-z0-9]+$/;
  if(partten.test(mail)) return true;
  return false;
};

/**
 * 将对象保存到文件
 * @param  {String} path 文件路径
 * @param  {Object} obj  JSON对象
 */
utilExt.saveDataToFile = function(path, data) {
  //fs.writeFile(path, JSON.stringify(obj,null,2), function (err) {
  //  if (err) throw err;
  //});
  fs.open(path,'w',function(err,fd){
    var buf = new Buffer(data);
    fs.write(fd,buf,0,buf.length,null,function(err,written){
      fs.close(fd, function() {
        //
      });
    });
  });
};

/**
 * 字符串是否以指定的子字符串结尾
 * @param  {String} strSrc 源字符串
 * @param  {String} strSub 子字符串
 * @return {bool}          判断结果
 */
utilExt.endWith = function(strSrc, strSub){
  if(strSub==null||strSub==""||strSrc.length==0||strSub.length>strSrc.length)
    return false;
  if(strSrc.substring(strSrc.length-strSub.length)==strSub)
    return true;
  else
    return false;
  return true;
};

/**
 * 字符串是否以指定的子字符串开头
 * @param  {String} strSrc 源字符串
 * @param  {String} strSub 子字符串
 * @return {bool}          判断结果
 */
utilExt.startWith = function(strSrc, strSub){
  if(strSub==null||strSub==""||strSrc.length==0||strSub.length>strSrc.length)
    return false;
  if(strSrc.substr(0,strSub.length)==strSub)
    return true;
  else
    return false;
  return true;
};

/**
 * 将字符串转换成二进制数组
 * @param str
 * @returns {Array}
 */
utilExt.strToBinArr = function(str){
  var rs = [];
  ([].slice.call(str)).forEach(function(char){
      rs.push(char.charCodeAt(0).toString(2));
  });
  return rs;
};

/**
 * 将二进制数组转换成字符串
 * @param bin
 * @returns {number}
 */
utilExt.binArrToStr = function(bin){
  var ds = 0;
  for(var i = bin.length - 1; i >= 0; --i){
     ds += parseInt(bin[i], 10) * Math.pow(2, bin.length - 1 - i);
  }
  return ds;
};

/**
 * 将已逗号分隔的字符串拆分为整数数组，并去掉重复项
 * @param  {[type]} str     [description]
 * @param  {[type]} exclude [description]
 * @return {[type]}         [description]
 */
utilExt.strToIntArray = function(str, exclude) {
  var ret = [];
  if(!str || utilExt.trimStr(str)=='') return ret;
  if((''+str).indexOf(',')<0) return [parseInt(str)];
  var arr = (''+str).split(',');
  for(var i=0;i<arr.length;i++) {
    if(!utilExt.isInt(arr[i])) continue;
    var value = parseInt(arr[i]);
    if(exclude && value==exclude) continue;
    var isExist = false;
    for(var j=0;j<ret.length;j++) {
      if(value==ret[j]) {
        isExist = true;
        break;
      }
    }
    if(isExist) continue;
    ret.push(value);
  }
  return ret;
};

/**
 * 对象属性比较，用来进行数组排序
 * @param  {[type]} propertyName [description]
 * @return {[type]}              [description]
 */
utilExt.compare = function(propertyName) { 
  return function (object1, object2) { 
    var value1 = object1[propertyName]; 
    var value2 = object2[propertyName]; 
    if (value2 < value1) { 
      return 1; 
    } 
    else if (value2 > value1) { 
      return -1; 
    } 
    else { 
      return 0; 
    } 
  } 
};

//字符中是否存在Emoji表情字符
utilExt.isExistEmoji = function(str) {
  for (var i=0; i<str.length; i++) { 
    var c = str.charCodeAt(i); 
    if ((c >= 0xE001 && c <= 0xE05A) || (0xE101<=c && c<=0xE15A) 
      || (c >= 0xE201 && c <= 0xE253) || (0xE301<=c && c<=0xE34D)
      || (c >= 0xE401 && c <= 0xE44C) || (0xE501<=c && c<=0xE537)) { 
      return true; 
    }
  } 
  return false;
};

/**
 * 获得时间差,时间格式为 年-月-日 小时:分钟:秒 或者 年/月/日 小时：分钟：秒
 * 返回精度为：second，minute，hour，day
 */
utilExt.dateDiff = function(startTime, endTime, diffType) {
    //将计算间隔类性字符转换为小写
    diffType = diffType.toLowerCase();
    var sTime = new Date(startTime); //开始时间
    var eTime = new Date(endTime); //结束时间
    //作为除数的数字
    var divNum = 1;
    switch (diffType) {
        case "second":
            divNum = 1000;
            break;
        case "minute":
            divNum = 1000 * 60;
            break;
        case "hour":
            divNum = 1000 * 3600;
            break;
        case "day":
            divNum = 1000 * 3600 * 24;
            break;
        default:
            break;
    }
    return parseInt((eTime.getTime() - sTime.getTime()) / parseInt(divNum));
};

utilExt.createVerifyCode = function(codeLength, isOnlyNumber) {  
    var code = "";   
    var random;
    if(isOnlyNumber) {
      random = new Array(0,1,2,3,4,5,6,7,8,9);//随机数  
    } else {
      random = new Array(0,1,2,3,4,5,6,7,8,9,'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');//随机数  
    } 
    for(var i = 0; i < codeLength; i++) {//循环操作  
      var index = Math.floor(Math.random()*random.length);//取得随机数的索引（0~35）  
      code += random[index];//根据索引取得随机数加到code上  
    } 
    return code;//把code值赋给验证码  
};

//是否包含特殊字符
utilExt.haveEspecialChar = function(str) {
  if(str.indexOf('*')>0||str.indexOf('%')>0||str.indexOf('~')>0||str.indexOf('!')>0
    ||str.indexOf('@')>0||str.indexOf('#')>0||str.indexOf('$')>0||str.indexOf('^')>0
    ||str.indexOf('&')>0||str.indexOf('(')>0||str.indexOf(')')>0||str.indexOf('`')>0
    ||str.indexOf('{')>0||str.indexOf('}')>0||str.indexOf('[')>0||str.indexOf(']')>0
    ||str.indexOf(':')>0||str.indexOf('"')>0||str.indexOf(';')>0||str.indexOf('\'')>0
    ||str.indexOf('<')>0||str.indexOf('>')>0||str.indexOf('?')>0||str.indexOf(',')>0
    ||str.indexOf('.')>0||str.indexOf('/')>0||str.indexOf('|')>0||str.indexOf('\\')>0
    ||str.indexOf('  ')>0) return true;
  return false;
};

utilExt.md5 = function(str) {
  var md5 = crypto.createHash('md5');
  md5.update(str, 'utf8');
  return md5.digest('hex');
};

//DES加密
utilExt.encryptDES = utilExt.EncryptDES = function (data, key) {
  var cipher = crypto.createCipheriv('des-ecb', key, new Buffer(0));
  cipher.setAutoPadding(true);
  var ciph = cipher.update(data, 'utf8', 'hex');  
  ciph += cipher.final('hex');
  return ciph.toUpperCase();
};

//DES解密
utilExt.decryptDES = utilExt.DecryptDES = function (data, key) {    
  var decipher = crypto.createDecipheriv('des-ecb', key, new Buffer(0)); 
  var txt = decipher.update(data, 'hex', 'utf8');  
  txt += decipher.final('utf8');                
  return txt;
};

/**
 * AES加密
 * @param {[type]} dataStr [description]
 * @param {[type]} key     [description]
 * @param {[type]} iv      [description]
 */
utilExt.encryptAES = function(dataStr, key, iv) {
  let cipherChunks = [];
  let cipher = crypto.createCipheriv('aes-256-cbc', key, iv);
  cipher.setAutoPadding(true);
  cipherChunks.push(cipher.update(dataStr, 'utf8', 'base64'));
  cipherChunks.push(cipher.final('base64'));
  return cipherChunks.join('');
};

/**
 * AES解密
 * @param {[type]} dataStr [description]
 * @param {[type]} key     [description]
 * @param {[type]} iv      [description]
 */
utilExt.decryptAES = function(dataStr, key, iv) {
  let cipherChunks = [];
  let decipher = crypto.createDecipheriv('aes-256-cbc', key, iv);
  decipher.setAutoPadding(true);
  cipherChunks.push(decipher.update(dataStr, 'base64', 'utf8'));
  cipherChunks.push(decipher.final('utf8'));
  return cipherChunks.join('');
};

utilExt.Base64Binary = {
  _keyStr : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
  
  /* will return a  Uint8Array type */
  decodeArrayBuffer: function(input) {
    var bytes = (input.length/4) * 3;
    var ab = new ArrayBuffer(bytes);
    this.decode(input, ab);
    
    return ab;
  },

  removePaddingChars: function(input){
    var lkey = this._keyStr.indexOf(input.charAt(input.length - 1));
    if(lkey == 64){
      return input.substring(0,input.length - 1);
    }
    return input;
  },

  decode: function (input, arrayBuffer) {
    //get last chars to see if are valid
    input = this.removePaddingChars(input);
    input = this.removePaddingChars(input);

    var bytes = parseInt((input.length / 4) * 3, 10);
    
    var uarray;
    var chr1, chr2, chr3;
    var enc1, enc2, enc3, enc4;
    var i = 0;
    var j = 0;
    
    if (arrayBuffer)
      uarray = new Uint8Array(arrayBuffer);
    else
      uarray = new Uint8Array(bytes);
    
    input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
    
    for (i=0; i<bytes; i+=3) {  
      //get the 3 octects in 4 ascii chars
      enc1 = this._keyStr.indexOf(input.charAt(j++));
      enc2 = this._keyStr.indexOf(input.charAt(j++));
      enc3 = this._keyStr.indexOf(input.charAt(j++));
      enc4 = this._keyStr.indexOf(input.charAt(j++));
  
      chr1 = (enc1 << 2) | (enc2 >> 4);
      chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
      chr3 = ((enc3 & 3) << 6) | enc4;
  
      uarray[i] = chr1;     
      if (enc3 != 64) uarray[i+1] = chr2;
      if (enc4 != 64) uarray[i+2] = chr3;
    }
  
    return uarray;  
  }
}

utilExt.saveJSONToFile = function(jsonObj, filePath, cb) {
  try {
    if(fs.existsSync(filePath)) fs.unlinkSync(filePath);
    var writeStream = fs.createWriteStream(filePath, {flags: 'a'});
    try {
      writeStream.write(JSON.stringify(jsonObj, null, "\t"));
    } catch(err) {
      global.logger.logError(err);
    }
    writeStream.end();
    writeStream = null;
  } catch(e) {
    global.logger.logError(e);
    if(cb) cb(e);
    return;
  }
  if(cb) cb();
};

/**
 * 获得物理路径
 * @param {*} _path 
 * @returns 
 */
utilExt.getPath = function (_path) {
  var physicalPath = _path;
  if (_path.substr(0, 1) != '/' && _path.substr(0, 1) != '\\') physicalPath = '/' + _path;
  physicalPath = path.join(process.cwd(), physicalPath);
  physicalPath = physicalPath.replace(/\\/g, '/');
  return physicalPath;
};


/** ******************************以下为新增**************************** */
/**
 * 递归创建目录(异步)
 * @param {*} dirname 
 * @param {*} callback 
 */  
utilExt.mkdirs = function (dirname, callback) {
  var self = this;
  fs.exists(dirname, function (exists) {  
      if (exists) {  
          callback();  
      } else {  
          // console.log(path.dirname(dirname));  
          self.mkdirs(path.dirname(dirname), function () {  
              fs.mkdir(dirname, callback);  
              console.log('在' + path.dirname(dirname) + '目录创建好' + dirname  +'目录');
          });  
      }  
  });  
}  

/**
 * 递归创建目录(同步)
 * @param {*} dirname 
 * @returns 
 */
utilExt.mkdirsSync = function (dirname) {
  var self = this;
  if (fs.existsSync(dirname)) {
    return true;
  } else {
    if (self.mkdirsSync(path.dirname(dirname))) {
      fs.mkdirSync(dirname);
      return true;
    }
  }
}

/**
 * 读取json文件,返回json对象
 * @param {*} path 路径
 * @param {*} truefalse 可选,是否相对路径,默认true
 * @returns jsonObj
 */
utilExt.loadFileToJson = function (path,isRelative=true){
  try {
    if(isRelative || path.indexOf(':')==-1){
      path = utilExt.getPath(path);
    }
    return JSON.parse(fs.readFileSync(path,'utf8'));
  } catch (e) {
    console.log(e);
    return null;
  }
};

/**
 * 复制文件或文件夹to目标文件夹
 * @param {*} source_dirOrFile 源文件夹或文件(物理路径)
 * @param {*} target_dir 目标文件夹(物理路径)
 */
utilExt.copyFilesSync = function(source_dirOrFile,target_dir){
  if(!fs.existsSync(source_dirOrFile)){
    return;
  }
  let stats = fsex.statSync(source_dirOrFile);
  if(stats.isDirectory()){
    fsex.copySync(source_dirOrFile,target_dir);
  }else{
    var fileName = path.basename(source_dirOrFile);
    fsex.copySync(source_dirOrFile,target_dir + fileName);
  }
}
/**
 * 生成uuid
 * @returns uuid
 */
utilExt.getUuid = function () {
  return uuid.v1().replace(/-/g, '');
};

/**
 * 删除文件
 * @param {*} dirOrFilePath 目录或文件的路径(物理路径)
 * @param {*} isRmDir 是否删除当前目录,参数dirOrFilePath为目录时生效 (默认false,只删除目录内的所有文件; 当为true时, 删除整个目录及文件)
 */
utilExt.removeFilesSync = function (dirOrFilePath, isRmDir=false){
  if(!fs.existsSync(dirOrFilePath)){
    return;
  }
  let stats = fs.statSync(dirOrFilePath);
  if(stats.isDirectory()){
    if(isRmDir){
      //删除整个目录及目录下的所有文件
      fs.rmdirSync(dirOrFilePath, {recursive: true});
    }else{
      //删除目录下所有文件, 不删除目录
      var files = fs.readdirSync(dirOrFilePath);
      files.forEach(function (file){
        if(fs.statSync(dirOrFilePath+"/"+file).isDirectory()){
          fs.rmdirSync(dirOrFilePath+"/"+file, {recursive: true});
        }else{
          fs.unlinkSync(dirOrFilePath+"/"+file);
        }
      });
    }
  }else{
    //删除指定的文件
    fs.unlinkSync(dirOrFilePath);
  }
};