const net = require('net');
const EventEmitter = require('events').EventEmitter;
const util = require('util');
const fs = require('fs');
const path = require('path');
const uuid = require('./uuid.js');
const TcpSocket = require('TcpSocket');
const { getMarketTcpAddress } = server.loadModule("/app/dev/service/requestUtils");

var Uploader = function () {
  this.uploadedSize = 0;
  this.isRunning = true;
  this.fileCode;
  this.filePath;
  this.fileSize;
  this.socket;
  this.res;
  this.upSize = null;
  this.tcp = getMarketTcpAddress();
};

util.inherits(Uploader, EventEmitter);

module.exports = Uploader;

Uploader.prototype.upload = function (args) {
  if (!fs.existsSync(args.filePath)) {
    this.emit('uploadError', '文件[' + args.filePath + ']不存在！');
    return;
  }
  this.filePath = args.filePath;
  var self = this;
  fs.stat(args.filePath, function (err, stats) {
    if (err) {
      self.onError(err);
      return;
    }
    if (stats.size == 0) {
      self.onError("文件没有任何内容，无法上传。");
      return;
    }
    self.fileSize = stats.size;
    self.socket = new net.Socket();
    var tcpSocket = new TcpSocket(self.socket);
    self.socket.connect(self.tcp.port, self.tcp.url, function (err) {
      if (err) {
        self.onError(err);
        return;
      }
      logger.log("TCP连接成功！");
      self.socket.on('error', function (err) {
        if (err.code == "ECONNRESET") {
          //传输出现错误，需要断点续传【记录fd，记录当前传递位置bytesRead】
          err.uploadedSize = self.uploadedSize;
        }
        self.onError(err);
      });

      self.socket.on('end', function () {
        if (self.uploadedSize < self.fileSize) {
          self.onError('文件还未发送完毕网络连接就断开了。');
        }
      });

      self.socket.setTimeout(60000, function () {
        self.onError('连接超时。');
      });
      tcpSocket.on('push', function (res) {
        console.log('接收到服务器响应数据：' + JSON.stringify(res));
        if (res.code == 0) {
          if (res.start) {
            fs.open(self.filePath, 'r', function (err, fd) {
              if (err) {
                self.onError(err);
                return;
              }
              if (args.uploadedSize) {
                self.uploadedSize = parseInt(args.uploadedSize);
                self.upSize = parseInt(args.uploadedSize);
              }
              self.sendFileData(fd);
            });
          } else {
            self.isRunning = false;
            self.socket.destroy();
            console.log('文件发送完毕。');
            self.emit('uploadFinish', res);
          }
        } else {
          self.onError(res.message);
          return;
        }
      });

      //发送消息
      var msg = {};
      msg.fileSize = stats.size;
      for (p in args) {
        if (p == "fileSize") continue;
        msg[p] = args[p];
      }
      msg.service = 'dp/service/tpm/upload.js';
      logger.log('准备上传文件，参数值：' + JSON.stringify(msg));
      tcpSocket.push(msg, function (err) {
        if (err) {
          self.onError(err);
          return;
        }
      });
    });
  });
};

Uploader.prototype.sendFileData = function (fd) {
  if (!this.isRunning) {
    console.log('已取消上传。');
    this.socket.destroy();
    return;
  }

  var self = this;
  var buf = new Buffer(10240);
  fs.read(fd, buf, 0, 10240, null, function (err, bytesRead, buffer) {
    if (err) {
      self.onError(err);
      return;
    }
    if (buffer.length != bytesRead) buffer = buffer.slice(0, bytesRead);

    self.socket.write(buffer, null, function (err) {
      if (err) {
        return;
      }
      self.uploadedSize += bytesRead;
      self.emit('uploadProgress', parseInt(self.uploadedSize * 100 / self.fileSize), parseInt(self.uploadedSize));
      if (self.uploadedSize >= self.fileSize) {
        self.isRunning = false;
        fs.closeSync(fd);
      } else {
        self.sendFileData(fd);
      }
    });
  });
};

Uploader.prototype.onError = function (err) {
  this.isRunning = false;
  if (this.socket) {
    try {
      this.socket.destroy();
    } catch (e) { }
  }
  var errMsg = err;
  if (typeof (errMsg) != 'string') errMsg = err.message;
  console.log('发送文件数据时发生意外错误：' + errMsg);
  this.emit('uploadError', '发送文件数据时发生意外错误：' + errMsg, err);
};