const fs = require('fs');
const path = require('path');
const utils = require('./utilExt');
const compressing = require('compressing');

var Tzip = function () {
  //源物理路径
  this.sourcePath;
  //目标物理路径
  this.targetPath = utils.getPath('/tpm/package/');
};

module.exports = Tzip;

/**
 * 压缩文件夹
 * @param {*} sourcePath 源物理路径
 * @param {*} targetPath 目标物理路径(含zip全文件名)
 * @param {*} callback 
 */
Tzip.prototype.zipDir = function (sourcePath,targetPath=null,callback=null)
{
  let self = this;
  self.sourcePath = sourcePath;
  if(targetPath){
    self.targetPath = targetPath;
  }
  compressing.zip.compressDir(self.sourcePath, self.targetPath, {ignoreBase:false})
    .then(() => {
      if(callback){
        callback(null);
      }else{
        console.log('tzip dir success ['+ self.sourcePath +']');
        console.log('zip file path ['+ self.targetPath +']');
      }
    })
    .catch(err => {
      if(err) {
        if(callback){
          callback(err);
        }else{
          console.log(err);
        }
      }
    });
}

/**
 * 解压zip到指定目录
 * @param {*} zipPath 
 * @param {*} savePath 
 * @param {*} callback 
 */
Tzip.prototype.unzip = function(zipPath,savePath,callback=null){
  let self = this;
  // this.zipPath = utils.getPath(zipPath);
  // this.savePath =  utils.getPath(savePath);
  compressing.zip.uncompress(zipPath, savePath)
    .then(() => {
      if(callback){
        callback(null);
      }else{
        console.log('unzip success ['+ savePath +']');
      }
    })
    .catch(err => {
      if(err) {
        if(callback){
          callback(err);
        }else{
          console.log(err);
        }
      }
    });
}

// function showHelp(){
//   console.log("参数说明：tasgine tpm tzip 路径");
//   console.log("例如：tasgine tpm tzip /web");
// }

//console.log('tpm-zip-参数:' + process.argv.length);

// if(process.argv.length<4){
//   showHelp();
//   return;
// }

//zipFile(utils.getPath(process.argv[3]),process.argv[2], false);
//zipFile(utils.getPath('/app'),'app', false);

// zipFile(path.join(__dirname,"res"),path.join(__dirname,"notignoreBase"),function(err)
// {

// },false)