var util = require('util');
var path = require('path');
var fs = require('fs');
var Service = require('Service');
var utils = require('./utilExt');
var Dao = require('Dao');
const Tzip = require('./tzip.js');
const Uploader = require('./uploader.js');
const { requestMarketSync } = server.loadModule("/app/dev/service/requestUtils");

/**
 * tb发布产品Service
 */
var PublishSourcecode = function () {
    Service.call(this);
    this.sqlInject.exclude = ["webFiles", "serviceFiles", "modelFiles", "sqlText"];
};

util.inherits(PublishSourcecode, Service);

module.exports = PublishSourcecode;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
PublishSourcecode.prototype.process = async function (req, res) {
    try {
        const {
            userId, systemId, systemCode, appCode, 
            webFiles = [], serviceFiles = [], modelFiles = [],
            upgradeDescribe, sqlText, dataDic = [], enList = []
        } = req;

        if (!userId) return this.onLogicError(1, "请先登录开发者账号！");
        if (!systemId) return this.onLogicError(1, "请提供系统编号！");
        if (!systemCode) return this.onLogicError(1, "请提供系统编码！");
        if (!appCode) return this.onLogicError(1, "请提供应用编码！");
        if (webFiles.length + serviceFiles.length + modelFiles.length <= 0) return this.onLogicError(1, "请提供应用文件！");

        const self = this;
        const dao = new Dao(this);

        this.runInBackground(res);
        dao.onError = function (err) {
            throw err;
        };
        this.serviceInfo = server.tmpBGServices[this.id];
        this.serviceInfo.status = 1;
        this.serviceInfo.process = 0;

        // 校验应用信息
        this.serviceInfo.message = `正在校验应用信息...`;
        const verifyResult = await verifySourcecode();
        const appId = verifyResult.appId;
        const appCurVersion = verifyResult.appCurVersion;
        const sourcecodeVersion = verifyResult.sourcecodeVersion;
        const sourcecodeFileCode = utils.getUuid();

        // 打包源码
        this.serviceInfo.message = `正在打包源码...`;
        const zipFilePath = await createSourcecodeZip();

        // 上传源码
        this.serviceInfo.message = `正在上传源码...`;
        const uploadResult = await uploadSourcecodeZip();
        const fileCode = uploadResult.fileCode;
        const fileName = uploadResult.fileName;
        const fileSize = uploadResult.fileSize;
        const savePath = uploadResult.savePath;

        // 上传源码调用服务器服务
        await publishSourcecode();

        // 更新本地文件
        this.serviceInfo.message = `正在修改本地配置...`;
        await updateRootFiles();

        // 上传完成
        this.serviceInfo.status = 2;
        this.serviceInfo.message = `上传完成`;
        this.end(res);

        // 校验应用信息
        async function verifySourcecode() {
            const result = await requestMarketSync(self, {
                service: "dp/service/tpm/publishSourcecodeVerify",
                userId, systemId, appCode
            });
            if (result.code != 0) throw new Error(result.message);
            return result;
        }

        // 打包源码
        async function createSourcecodeZip() {
            const _root = process.cwd();

            // 打包源码文件夹路径
            const publishPath = path.join(_root, 'tpm', 'package', systemCode, 'sourcecode', appCode);
            if (!fs.existsSync(publishPath)) {
                utils.mkdirsSync(publishPath);
                fs.mkdirSync(path.join(publishPath, 'app'));
                fs.mkdirSync(path.join(publishPath, 'app', 'db'));
                fs.mkdirSync(path.join(publishPath, 'app', 'model'));
                fs.mkdirSync(path.join(publishPath, 'app', 'service'));
                fs.mkdirSync(path.join(publishPath, 'db'));
                fs.mkdirSync(path.join(publishPath, 'web'));
            }

            // 复制前端文件
            if (webFiles.length > 0) for (const webFile of webFiles) {
                const relativePath = path.join(webFile);
                const rootPath = path.join(_root, relativePath);
                const filePath = path.join(publishPath, 'web', relativePath.replace(path.join('web', 'app', systemCode, appCode), ''));
                utils.mkdirsSync(path.dirname(filePath));
                fs.copyFileSync(rootPath, filePath);
            }

            // 复制后端文件
            if (serviceFiles.length > 0) for (const serviceFile of serviceFiles) {
                const relativePath = path.join(serviceFile);
                const rootPath = path.join(_root, relativePath);
                const filePath = path.join(publishPath, 'app', relativePath.replace(path.join('app', systemCode, appCode), ''));
                utils.mkdirsSync(path.dirname(filePath));
                fs.copyFileSync(rootPath, filePath);
            }

            // 复制数据库文件
            if (modelFiles.length > 0) for (const modelFile of modelFiles) {
                const modelRelativePath = path.join(modelFile);
                const modelRootPath = path.join(_root, modelRelativePath);
                const modelFilePath = path.join(publishPath, 'app', modelRelativePath.replace(path.join('app', systemCode, appCode), ''));
                const modelName = path.parse(modelFilePath).name;
                utils.mkdirsSync(path.dirname(modelFilePath));
                fs.copyFileSync(modelRootPath, modelFilePath);

                // 复制sql文件并重命名[modelName]_tmp.sql文件为[modelName]_[sourcecodeVersion].sql
                const sqlFile = path.join(path.dirname(modelRelativePath), modelName, modelName + '_tmp.sql').replace('model', 'db');
                const sqlRootPath = path.join(_root, sqlFile);
                const sqlFilePath = path.join(publishPath, 'app', path.join(sqlFile).replace(path.join('app', systemCode, appCode), ''));
                if (!fs.existsSync(sqlRootPath)) continue;
                utils.mkdirsSync(path.dirname(sqlFilePath));
                fs.copyFileSync(sqlRootPath, sqlFilePath);
                fs.renameSync(sqlFilePath, path.resolve(sqlFilePath, '../', modelName + '_' + sourcecodeVersion + '.sql'));
            }

            // 将填写的sql语句生成sql文件
            if (sqlText) {
                const sqlTextFilePath = path.join(publishPath, 'db', 'update_' + sourcecodeVersion + '.sql');
                utils.mkdirsSync(path.dirname(sqlTextFilePath));
                fs.writeFileSync(sqlTextFilePath, sqlText);
            }

            // 数据字典
            if (dataDic.length > 0) {
                const dataDicFilePath = path.join(publishPath, 'db', 'dataDic_' + sourcecodeVersion + '.sql');

                // 查询数据字典类型
                const dataDicTypeList = await dao.executeSync('select code,name,(select code from sys_data_dictype as b where a.parent_id=b.id) as parent_code from sys_data_dictype as a where id in (?)', [dataDic]);
                // 查询数据字典数据
                const dataDicList = await dao.executeSync('select type_code,code,name from sys_data_dic where type_id in (?)', [dataDic]);

                const dataDicTypeStr = dataDicTypeList.map(dataDicType => {
                    return `
    set d_id=0;
    set d_code='${dataDicType.code || ''}';
    set d_name='${dataDicType.name || ''}';
    set d_parent_id=0;
    set d_parent_code='${dataDicType.parent_code || ''}';
    set d_id_full_path='';
    select id into d_id from sys_data_dictype where code=d_code;
    select id into d_parent_id from sys_data_dictype where code=d_parent_code;
    select id_full_path into d_id_full_path from sys_data_dictype where code=d_parent_code;
    if(d_id>0)
	then
        set d_id_full_path=concat(d_id_full_path, d_id, '/'); 
        update sys_data_dictype set code=d_code,name=d_name,parent_id=d_parent_id,id_full_path=d_id_full_path where id=d_id;
    else 
        insert into sys_data_dictype(org_id,code,name,parent_id,status) values (1,d_code,d_name,d_parent_id,0);
        select id into d_id from sys_data_dictype where code=d_code;
        set d_id_full_path=concat(d_id_full_path, d_id, '/');
        update sys_data_dictype set id_full_path=d_id_full_path where code=d_code;
    end if;`}).join('\n');
                const dataDicStr = dataDicList.map(dataDic => {
                    return `
    set d_id=0;
    set d_code='${dataDic.code || ''}';
    set d_name='${dataDic.name || ''}';
    set d_parent_id=0;
    set d_parent_code='${dataDic.type_code || ''}';
    select id into d_parent_id from sys_data_dictype where code=d_parent_code;
    if(d_parent_id>0)
    then 
        select id into d_id from sys_data_dic where code=d_code and type_code=d_parent_code;
        if(d_id>0)
        then update sys_data_dic set code=d_code,name=d_name,type_id=d_parent_id,type_code=d_parent_code where id=d_id;
        else insert into sys_data_dic(org_id,code,name,type_id,type_code,status) values (1,d_code,d_name,d_parent_id,d_parent_code,0);
        end if;
    end if;`}).join('\n');
                const dataDicFileContent = `
DROP PROCEDURE IF EXISTS \`PAlterSysDataDic_I\`;

CREATE PROCEDURE \`PAlterSysDataDic_I\`()

BEGIN 
    declare d_id int(11);
    declare d_code varchar(45);
    declare d_name varchar(20);
    declare d_parent_code varchar(45);
    declare d_parent_id int(11);
    declare d_id_full_path varchar(100);
    ${dataDicTypeStr}
    ${dataDicStr}
END;

CALL \`PAlterSysDataDic_I\`;

DROP PROCEDURE IF EXISTS \`PAlterSysDataDic_I\`;`;
                utils.mkdirsSync(path.dirname(dataDicFilePath));
                fs.writeFileSync(dataDicFilePath, dataDicFileContent);
            }

            // 编码规则
            if (enList.length > 0) {
                const enFilePath = path.join(publishPath, 'db', 'en_' + sourcecodeVersion + '.sql');

                // 查询数据字典类型
                const enRuleList = await dao.executeSync('select pk_type,pk_code,clear_mode,update_mode,sn_type from sys_encodingrule as a where id in (?)', [enList]);
                // 查询数据字典数据
                const enRuleItemList = await dao.executeSync('select encodingrule_id,(select pk_code from sys_encodingrule as b where a.encodingrule_id=b.id) as encodingrule_code,order_number,encoding_type,encoding_count,encoding_content from sys_encodingrule_item as a where encodingrule_id in (?)', [enList]);

                const enStr = enRuleList.map(en => {
                    return `
    set d_id=0;
    set d_pk_code='${en.pk_code || ''}';
    set d_pk_type='${en.pk_type || ''}';
    set d_clear_mode='${en.clear_mode || ''}';
    set d_update_mode='${en.update_mode || ''}';
    set d_sn_type='${en.sn_type || ''}';
    select id into d_id from sys_encodingrule where pk_code=d_pk_code;
    if(d_id>0)
	then update sys_encodingrule set pk_code=d_pk_code,pk_type=d_pk_type,clear_mode=d_clear_mode,update_mode=d_update_mode,sn_type=d_sn_type where id=d_id;
    else 
        insert into sys_encodingrule(org_id,pk_code,pk_type,clear_mode,update_mode,sn_type) values (1,d_pk_code,d_pk_type,d_clear_mode,d_update_mode,d_sn_type);
        select id into d_id from sys_encodingrule where pk_code=d_pk_code;
    end if;
    delete from sys_encodingrule_item where encodingrule_id=d_id;`}).join('\n');
                const enItemStr = enRuleItemList.map(enItem => {
                    return `
    set d_encodingrule_id=0;
    set d_encodingrule_code='${enItem.encodingrule_code || ''}';
    set d_order_number=${enItem.order_number || ''};
    set d_encoding_type='${enItem.encoding_type || ''}';
    set d_encoding_count=${enItem.encoding_count || 'null'};
    set d_encoding_content=${enItem.encoding_content ? `'${enItem.encoding_content}'` : 'null'};
    select id into d_encodingrule_id from sys_encodingrule where pk_code=d_encodingrule_code;
    if(d_encodingrule_id>0)
    then 
        insert into sys_encodingrule_item(org_id,encodingrule_id,order_number,encoding_type,encoding_count,encoding_content) 
        values (1,d_encodingrule_id,d_order_number,d_encoding_type,d_encoding_count,d_encoding_content);
    end if;`}).join('\n');
                const enFileContent = `
DROP PROCEDURE IF EXISTS \`PAlterSysEncodingrule_I\`;

CREATE PROCEDURE \`PAlterSysEncodingrule_I\`()

BEGIN 
    declare d_id int(11);
    declare d_pk_type varchar(50);
    declare d_pk_code varchar(50);
    declare d_clear_mode varchar(2);
    declare d_update_mode varchar(2);
    declare d_sn_type varchar(2);
    declare d_encodingrule_id int(11);
    declare d_encodingrule_code varchar(50);
    declare d_order_number int(11);
    declare d_encoding_type varchar(20);
    declare d_encoding_count int(11);
    declare d_encoding_content varchar(50);
    ${enStr}
    ${enItemStr}
END;

CALL \`PAlterSysEncodingrule_I\`;

DROP PROCEDURE IF EXISTS \`PAlterSysEncodingrule_I\`;`;
                utils.mkdirsSync(path.dirname(enFilePath));
                fs.writeFileSync(enFilePath, enFileContent);
            }

            // 打包zip文件
            const zipFilePath = path.resolve(publishPath, '../', sourcecodeFileCode + '.zip')
            await zipDirSync(publishPath, zipFilePath);

            // 删除打包源码文件夹
            utils.removeFilesSync(publishPath, true);

            return zipFilePath;
        }

        // 上传源码
        async function uploadSourcecodeZip() {
            const uploader = new Uploader();
            uploader.fileCode = sourcecodeFileCode;
            return new Promise((resolve, reject) => {
                uploader.on('uploadProgress', function (progress, fileSize) {
                    self.serviceInfo.process = progress;
                });
                uploader.on('uploadError', function (msg, msgObj) {
                    throw new Error(msg);
                });
                uploader.on('uploadFinish', function (result) {
                    resolve(result);
                });
                uploader.upload({
                    filePath: zipFilePath,
                    fileCode: sourcecodeFileCode,
                    fileName: path.basename(zipFilePath),
                    systemCode: systemCode,
                    appCode: appCode,
                    userId: userId
                });
            });
        }

        // 上传源码调用服务器服务
        async function publishSourcecode() {
            const result = await requestMarketSync(self, {
                service: "dp/service/tpm/publishSourcecode",
                userId, systemId, appCode, fileCode, fileName, fileSize, savePath, upgradeDescribe
            });
            if (result.code != 0) throw new Error(result.message);
            return result;
        }


        // 更新本地文件
        async function updateRootFiles() {
            const _root = process.cwd();
            const publishPath = path.join(_root, 'tpm', 'package', systemCode, 'sourcecode', appCode);

            // 重命名[modelName]_tmp.sql文件为[modelName]_[sourcecodeVersion].sql
            if (modelFiles.length > 0) for (const modelFile of modelFiles) {
                const modelRelativePath = path.join(modelFile);
                const modelFilePath = path.join(publishPath, 'app', modelRelativePath.replace(path.join('app', systemCode, appCode), ''));
                const modelName = path.parse(modelFilePath).name;
                const sqlFile = path.join(path.dirname(modelRelativePath), modelName, modelName + '_tmp.sql').replace('model', 'db');
                const sqlRootPath = path.join(_root, sqlFile);
                if (!fs.existsSync(sqlRootPath)) continue;
                fs.renameSync(sqlRootPath, path.resolve(sqlRootPath, '../', modelName + '_' + sourcecodeVersion + '.sql'));
            }

            const appJsonFilePath = path.join(_root, 'app', systemCode, appCode, 'app.json');
            if (!fs.existsSync(appJsonFilePath)) throw new Error('app.json文件不存在！');
            const jsonString = fs.readFileSync(appJsonFilePath, 'utf8');
            const json = JSON.parse(jsonString);
            json.sourcecodeVersion = sourcecodeVersion;
            fs.writeFileSync(appJsonFilePath, JSON.stringify(json, null, '\t'));
        }

    } catch (error) {
        console.log(error);
        this.onImportError(req, error.message);
    }
};

PublishSourcecode.prototype.onImportError = function (req, err) {
    this._importFields = null;
    this._pkFields = null;
    this._keys = null;
    var res = { code: 500, message: err };
    var tmpBGService = server.tmpBGServices[this.id];
    tmpBGService.status = -1;
    tmpBGService.endTime = new Date();
    tmpBGService.error = res;
    this.end(res);
};

function zipDirSync(sourcePath, targetPath) {
    return new Promise((resolve, reject) => {
        const tzip = new Tzip();
        tzip.zipDir(sourcePath, targetPath, function () { resolve(); });
    });
};