var util = require('util');
var path = require('path');
var fs = require('fs');
var Service = require('Service');
var utils = require('./utilExt');

//发布前查询明细
var PublishProductPre = function () {
  Service.call(this);
  this.sqlInject.exclude = ["webFiles","serviceFiles","modelFiles","sqlText"];
};

util.inherits(PublishProductPre, Service);

module.exports = PublishProductPre;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
PublishProductPre.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(1, "请先登录开发者账号！");
    return;
  }
  if (!req.systemId) {
    this.onLogicError(1, "请提供系统编号！");
    return;
  }
  if (!req.systemCode) {
    this.onLogicError(1, "请提供系统编码！");
    return;
  }
  if (!req.appCode) {
    this.onLogicError(1, "请提供应用编码！");
    return;
  }
  if (!req.appVersion) {
    this.onLogicError(1, "请提供应用编码！");
    return;
  }
  if ((!req.webFiles || req.webFiles.length == 0) && (!req.serviceFiles || req.serviceFiles.length == 0) && (!req.modelFiles || req.modelFiles.length == 0)) {
    this.onLogicError(1, "请提供应用文件！");
    return;
  }
  var self = this;
  self.pipe(server.loadModule('/app/dev/service/product/publishProduct'),
  req, { code: 0 }, function (req0, res) {
      self.end(res);
  });
};