var util = require('util');
var path = require('path');
var fs = require('fs');
var Service = require('Service');
var utils = require('./utilExt');
var Dao = require('Dao');
const Tzip = require('./tzip.js');
const Uploader = require('./uploader.js');
const { requestMarketSync } = server.loadModule("/app/dev/service/requestUtils");

/**
 * tb发布产品Service
 */
var PublishProduct = function () {
    Service.call(this);
    this.sqlInject.exclude = ["webFiles", "serviceFiles", "modelFiles", "sqlText"];
};

util.inherits(PublishProduct, Service);

module.exports = PublishProduct;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
PublishProduct.prototype.process = async function (req, res) {
    try {
        const {
            userId, systemId, systemCode, appCode, appName, appVersion, compiler,
            webFiles = [], serviceFiles = [], modelFiles = [],
            upgrade_describe, brief, introduce, sqlText, dataDic = [], enList = []
        } = req;
        if (!userId) return this.onLogicError(1, "请先登录开发者账号！");
        if (!systemId) return this.onLogicError(1, "请提供系统编号！");
        if (!systemCode) return this.onLogicError(1, "请提供系统编码！");
        if (!appCode) return this.onLogicError(1, "请提供应用编码！");
        if (!appVersion) return this.onLogicError(1, "请提供应用版本！");
        if (webFiles.length + serviceFiles.length + modelFiles.length <= 0) return this.onLogicError(1, "请提供应用文件！");

        const self = this;
        const dao = new Dao(this);

        this.runInBackground(res);
        dao.onError = function (err) {
            throw err;
        };
        this.serviceInfo = server.tmpBGServices[this.id];
        this.serviceInfo.status = 1;
        this.serviceInfo.process = 0;

        // 校验应用信息
        this.serviceInfo.message = `正在校验应用信息...`;
        const verifyResult = await verifyAppPackage();
        const appId = verifyResult.app_id;
        const versionId = verifyResult.version_id;
        const appCurVersion = verifyResult.cur_version;
        const sourcecodeStatus = verifyResult.sourcecode_status;
        const appVersionFileCode = utils.getUuid();

        // 编译应用
        if (compiler == 2) {
            this.serviceInfo.message = `正在编译应用...`;
            await compilerAppVersion();
        }

        // 打包用
        this.serviceInfo.message = `正在打包应用...`;
        const zipFilePath = await createAppVersionZip();

        // 上传应用
        this.serviceInfo.message = `正在上传应用...`;
        const uploadResult = await uploadAppVersionZip();
        const fileCode = uploadResult.fileCode;
        const fileName = uploadResult.fileName;
        const fileSize = uploadResult.fileSize;
        const savePath = uploadResult.savePath;

        // 上传应用调用服务器服务
        await publishAppVersion();

        // 更新本地文件
        this.serviceInfo.message = `正在修改本地配置...`;
        await updateRootFiles();

        // 上传完成
        this.serviceInfo.status = 2;
        this.serviceInfo.message = `上传完成`;
        this.end(res);

        // 校验应用信息
        async function verifyAppPackage() {
            const result = await requestMarketSync(self, {
                service: "dp/service/tpm/publishPackageVerify",
                systemId, appCode, appName, appVersion, userId, upgrade_describe, brief, introduce, compiler
            });
            if (result.code != 0) throw new Error(result.message);
            return result;
        }

        // 编译应用
        async function compilerAppVersion() {
            const compilerResult = await self.pipeSync('../pub/compiler.js', {
                src: '/app/' + systemCode + '/' + appCode,
                type: 'all',
                proj: systemCode + '/' + appCode,
            }, res);
            if (compilerResult.code != 0) throw new Error(compilerResult.message);
        }

        // 打包应用
        async function createAppVersionZip() {
            const _root = process.cwd();
            const sep = path.sep;

            // 打包应用文件夹路径
            const publishPath = path.join(_root, 'tpm', 'package', systemCode, 'publish', appCode);
            if (!fs.existsSync(publishPath)) {
                utils.mkdirsSync(publishPath);
                fs.mkdirSync(path.join(publishPath, 'app'));
                fs.mkdirSync(path.join(publishPath, 'app', 'model'));
                fs.mkdirSync(path.join(publishPath, 'app', 'service'));
                fs.mkdirSync(path.join(publishPath, 'db'));
                fs.mkdirSync(path.join(publishPath, 'web'));
            }

            // 复制前端文件
            if (webFiles.length > 0) for (const webFile of webFiles) {
                let relativePath = path.join(webFile);
                if (compiler == 2) {
                    relativePath = relativePath.replace(`${sep}app${sep}`, `${sep}dist${sep}`);
                    if (path.extname(relativePath) == '.tfp') relativePath += '.html';
                }
                const rootPath = path.join(_root, relativePath);
                const filePath = path.join(publishPath, 'web', relativePath.replace(path.join('web', compiler == 2 ? 'dist' : 'app', systemCode, appCode), ''));
                utils.mkdirsSync(path.dirname(filePath));
                fs.copyFileSync(rootPath, filePath);
            }

            // 复制后端文件
            if (serviceFiles.length > 0) for (const serviceFile of serviceFiles) {
                let relativePath = path.join(serviceFile);
                if (compiler == 2) {
                    relativePath = relativePath.replace(`${sep}app${sep}`, `${sep}dist${sep}`);
                    if (path.extname(relativePath) == '.tbs') relativePath += '.js';
                }
                const rootPath = path.join(_root, relativePath);
                const filePath = path.join(publishPath, 'app', relativePath.replace(path.join(compiler == 2 ? 'dist' : 'app', systemCode, appCode), ''));
                utils.mkdirsSync(path.dirname(filePath));
                fs.copyFileSync(rootPath, filePath);
            }

            // 复制数据库文件
            if (modelFiles.length > 0) for (const modelFile of modelFiles) {
                let modelRelativePath = path.join(modelFile);
                if (compiler == 2) {
                    modelRelativePath = modelRelativePath.replace(`${sep}app${sep}`, `${sep}dist${sep}`);
                    if (path.extname(modelRelativePath) == '.tdm') modelRelativePath += '.json';
                }
                const modelRootPath = path.join(_root, modelRelativePath);
                const modelFilePath = path.join(publishPath, 'app', modelRelativePath.replace(path.join(compiler == 2 ? 'dist' : 'app', systemCode, appCode), ''));
                const modelName = path.parse(modelFile).name;
                utils.mkdirsSync(path.dirname(modelFilePath));
                fs.copyFileSync(modelRootPath, modelFilePath);

                if (sourcecodeStatus == 2) {
                    // 复制应用为当前版本的sql文件
                    const sqlRootDir = path.join(path.dirname(modelFile), modelName).replace(`${sep}model${sep}`, `${sep}db${sep}`);
                    const sqlFileDir = path.join(publishPath, 'db');
                    utils.mkdirsSync(sqlFileDir);
                    const reg = new RegExp(`^${modelName}_${appCurVersion}\\.\\d+\\.sql$`);
                    if (fs.existsSync(sqlRootDir)) fs.readdirSync(sqlRootDir).forEach((sqlFilePath) => {
                        if (reg.test(sqlFilePath)) fs.copyFileSync(
                            path.join(sqlRootDir, sqlFilePath),
                            path.join(sqlFileDir, sqlFilePath)
                        );
                    });
                }
                else {
                    // 如果存在[modelName]_[appVersion].sql文件则将[modelName]_tmp.sql内容追加到文件中
                    // 复制sql文件并重命名[modelName]_tmp.sql文件为[modelName]_[appVersion].sql
                    const tmpSqlFile = path.join(path.dirname(modelFile), modelName, modelName + '_tmp.sql').replace(`${sep}model${sep}`, `${sep}db${sep}`);
                    const tmpSqlRootPath = path.join(_root, tmpSqlFile);
                    const versionSqlRootFile = path.resolve(tmpSqlRootPath, '../', modelName + '_' + appVersion + '.sql');
                    const tmpSqlFilePath = path.join(publishPath, 'db', path.basename(tmpSqlRootPath));
                    const versionSqlFilePath = path.join(publishPath, 'db', path.basename(versionSqlRootFile));

                    // 如果有当前版本sql文件则将tmp.sql追加到文件中
                    if (fs.existsSync(versionSqlRootFile)) {
                        fs.copyFileSync(versionSqlRootFile, versionSqlFilePath);
                        if (fs.existsSync(tmpSqlRootPath)) {
                            const tmpSqlContent = fs.readFileSync(tmpSqlRootPath, 'utf8');
                            const versionSqlContent = fs.readFileSync(versionSqlFilePath, 'utf8');
                            fs.writeFileSync(versionSqlFilePath, versionSqlContent + '\n\n' + tmpSqlContent);
                        }
                    }
                    else {
                        if (!fs.existsSync(tmpSqlRootPath)) continue;
                        utils.mkdirsSync(path.dirname(tmpSqlFilePath));
                        fs.copyFileSync(tmpSqlRootPath, tmpSqlFilePath);
                        fs.renameSync(tmpSqlFilePath, versionSqlFilePath);
                    }
                }
            }

            // 将填写的sql语句生成sql文件
            if (sqlText) {
                const sqlTextFilePath = path.join(publishPath, 'db', 'update_' + appVersion + '.sql');
                utils.mkdirsSync(path.dirname(sqlTextFilePath));
                fs.writeFileSync(sqlTextFilePath, sqlText);
            }

            // 数据字典
            if (dataDic.length > 0) {
                const dataDicFilePath = path.join(publishPath, 'db', 'dataDic_' + appVersion + '.sql');

                // 查询数据字典类型
                const dataDicTypeList = await dao.executeSync('select code,name,(select code from sys_data_dictype as b where a.parent_id=b.id) as parent_code from sys_data_dictype as a where id in (?)', [dataDic]);
                // 查询数据字典数据
                const dataDicList = await dao.executeSync('select type_code,code,name from sys_data_dic where type_id in (?)', [dataDic]);

                const dataDicTypeStr = dataDicTypeList.map(dataDicType => {
                    return `
    set d_id=0;
    set d_code='${dataDicType.code || ''}';
    set d_name='${dataDicType.name || ''}';
    set d_parent_id=0;
    set d_parent_code='${dataDicType.parent_code || ''}';
    set d_id_full_path='';
    select id into d_id from sys_data_dictype where code=d_code;
    select id into d_parent_id from sys_data_dictype where code=d_parent_code;
    select id_full_path into d_id_full_path from sys_data_dictype where code=d_parent_code;
    if(d_id>0)
	then
        set d_id_full_path=concat(d_id_full_path, d_id, '/'); 
        update sys_data_dictype set code=d_code,name=d_name,parent_id=d_parent_id,id_full_path=d_id_full_path where id=d_id;
    else 
        insert into sys_data_dictype(org_id,code,name,parent_id,status) values (1,d_code,d_name,d_parent_id,0);
        select id into d_id from sys_data_dictype where code=d_code;
        set d_id_full_path=concat(d_id_full_path, d_id, '/');
        update sys_data_dictype set id_full_path=d_id_full_path where code=d_code;
    end if;`}).join('\n');
                const dataDicStr = dataDicList.map(dataDic => {
                    return `
    set d_id=0;
    set d_code='${dataDic.code || ''}';
    set d_name='${dataDic.name || ''}';
    set d_parent_id=0;
    set d_parent_code='${dataDic.type_code || ''}';
    select id into d_parent_id from sys_data_dictype where code=d_parent_code;
    if(d_parent_id>0)
    then 
        select id into d_id from sys_data_dic where code=d_code and type_code=d_parent_code;
        if(d_id>0)
        then update sys_data_dic set code=d_code,name=d_name,type_id=d_parent_id,type_code=d_parent_code where id=d_id;
        else insert into sys_data_dic(org_id,code,name,type_id,type_code,status) values (1,d_code,d_name,d_parent_id,d_parent_code,0);
        end if;
    end if;`}).join('\n');
                const dataDicFileContent = `
DROP PROCEDURE IF EXISTS \`PAlterSysDataDic_I\`;

CREATE PROCEDURE \`PAlterSysDataDic_I\`()

BEGIN 
    declare d_id int(11);
    declare d_code varchar(45);
    declare d_name varchar(20);
    declare d_parent_code varchar(45);
    declare d_parent_id int(11);
    declare d_id_full_path varchar(100);
    ${dataDicTypeStr}
    ${dataDicStr}
END;

CALL \`PAlterSysDataDic_I\`;

DROP PROCEDURE IF EXISTS \`PAlterSysDataDic_I\`;`;
                utils.mkdirsSync(path.dirname(dataDicFilePath));
                fs.writeFileSync(dataDicFilePath, dataDicFileContent);
            }

            // 编码规则
            if (enList.length > 0) {
                const enFilePath = path.join(publishPath, 'db', 'en_' + appVersion + '.sql');

                // 查询数据字典类型
                const enRuleList = await dao.executeSync('select pk_type,pk_code,clear_mode,update_mode,sn_type from sys_encodingrule as a where id in (?)', [enList]);
                // 查询数据字典数据
                const enRuleItemList = await dao.executeSync('select encodingrule_id,(select pk_code from sys_encodingrule as b where a.encodingrule_id=b.id) as encodingrule_code,order_number,encoding_type,encoding_count,encoding_content from sys_encodingrule_item as a where encodingrule_id in (?)', [enList]);

                const enStr = enRuleList.map(en => {
                    return `
    set d_id=0;
    set d_pk_code='${en.pk_code || ''}';
    set d_pk_type='${en.pk_type || ''}';
    set d_clear_mode='${en.clear_mode || ''}';
    set d_update_mode='${en.update_mode || ''}';
    set d_sn_type='${en.sn_type || ''}';
    select id into d_id from sys_encodingrule where pk_code=d_pk_code;
    if(d_id>0)
	then update sys_encodingrule set pk_code=d_pk_code,pk_type=d_pk_type,clear_mode=d_clear_mode,update_mode=d_update_mode,sn_type=d_sn_type where id=d_id;
    else 
        insert into sys_encodingrule(org_id,pk_code,pk_type,clear_mode,update_mode,sn_type) values (1,d_pk_code,d_pk_type,d_clear_mode,d_update_mode,d_sn_type);
        select id into d_id from sys_encodingrule where pk_code=d_pk_code;
    end if;
    delete from sys_encodingrule_item where encodingrule_id=d_id;`}).join('\n');
                const enItemStr = enRuleItemList.map(enItem => {
                    return `
    set d_encodingrule_id=0;
    set d_encodingrule_code='${enItem.encodingrule_code || ''}';
    set d_order_number=${enItem.order_number || ''};
    set d_encoding_type='${enItem.encoding_type || ''}';
    set d_encoding_count=${enItem.encoding_count || 'null'};
    set d_encoding_content=${enItem.encoding_content ? `'${enItem.encoding_content}'` : 'null'};
    select id into d_encodingrule_id from sys_encodingrule where pk_code=d_encodingrule_code;
    if(d_encodingrule_id>0)
    then 
        insert into sys_encodingrule_item(org_id,encodingrule_id,order_number,encoding_type,encoding_count,encoding_content) 
        values (1,d_encodingrule_id,d_order_number,d_encoding_type,d_encoding_count,d_encoding_content);
    end if;`}).join('\n');
                const enFileContent = `
DROP PROCEDURE IF EXISTS \`PAlterSysEncodingrule_I\`;

CREATE PROCEDURE \`PAlterSysEncodingrule_I\`()

BEGIN 
    declare d_id int(11);
    declare d_pk_type varchar(50);
    declare d_pk_code varchar(50);
    declare d_clear_mode varchar(2);
    declare d_update_mode varchar(2);
    declare d_sn_type varchar(2);
    declare d_encodingrule_id int(11);
    declare d_encodingrule_code varchar(50);
    declare d_order_number int(11);
    declare d_encoding_type varchar(20);
    declare d_encoding_count int(11);
    declare d_encoding_content varchar(50);
    ${enStr}
    ${enItemStr}
END;

CALL \`PAlterSysEncodingrule_I\`;

DROP PROCEDURE IF EXISTS \`PAlterSysEncodingrule_I\`;`;
                utils.mkdirsSync(path.dirname(enFilePath));
                fs.writeFileSync(enFilePath, enFileContent);
            }


            // 复制app.json
            const appJsonRootPath = path.join(_root, 'app', systemCode, appCode, 'app.json');
            const appJsonFilePath = path.join(publishPath, 'app.json');
            if (!fs.existsSync(appJsonRootPath)) throw new Error('app.json文件不存在！');
            fs.copyFileSync(appJsonRootPath, appJsonFilePath);
            const jsonString = fs.readFileSync(appJsonFilePath, 'utf8');
            const json = JSON.parse(jsonString);
            json.version = appVersion;
            json.name = appName;
            json.compiler = compiler;
            fs.writeFileSync(appJsonFilePath, JSON.stringify(json, null, '\t'));

            // 打包zip文件
            const zipFilePath = path.resolve(publishPath, '../', appVersionFileCode + '.zip');
            await zipDirSync(publishPath, zipFilePath);

            // 删除打包应用文件夹
            utils.removeFilesSync(publishPath, true);

            return zipFilePath;
        }

        // 上传应用
        async function uploadAppVersionZip() {
            const uploader = new Uploader();
            uploader.fileCode = appVersionFileCode;
            return new Promise((resolve, reject) => {
                uploader.on('uploadProgress', function (progress, fileSize) {
                    self.serviceInfo.process = progress;
                });
                uploader.on('uploadError', function (msg, msgObj) {
                    throw new Error(msg);
                });
                uploader.on('uploadFinish', function (result) {
                    resolve(result);
                });
                uploader.upload({
                    filePath: zipFilePath,
                    fileCode: appVersionFileCode,
                    fileName: path.basename(zipFilePath),
                    systemCode: systemCode,
                    appCode: appCode,
                    userId: userId
                });
            });
        }

        // 上传应用调用服务器服务
        async function publishAppVersion() {
            const result = await requestMarketSync(self, {
                service: "dp/service/tpm/publishPackage",
                userId, systemId, appCode, versionId, fileCode, fileName, fileSize, savePath
            });
            if (result.code != 0) throw new Error(result.message);
            return result;
        }

        // 更新本地文件
        async function updateRootFiles() {
            const _root = process.cwd();
            const publishPath = path.join(_root, 'tpm', 'package', systemCode, 'sourcecode', appCode);

            // 重命名[modelName]_tmp.sql文件为[modelName]_[appVersion].sql
            if (modelFiles.length > 0 && sourcecodeStatus != 2) for (const modelFile of modelFiles) {
                const modelRelativePath = path.join(modelFile);
                const modelFilePath = path.join(publishPath, 'app', modelRelativePath.replace(path.join(compiler == 2 ? 'dist' : 'app', systemCode, appCode), ''));
                const modelName = path.parse(modelFilePath).name;
                const tmpSqlFile = path.join(path.dirname(modelRelativePath), modelName, modelName + '_tmp.sql').replace(`${path.sep}model${path.sep}`, `${path.sep}db${path.sep}`);
                const tmpSqlRootPath = path.join(_root, tmpSqlFile);
                const versionSqlRootFile = path.resolve(tmpSqlRootPath, '../', modelName + '_' + appVersion + '.sql');

                // 如果有当前版本sql文件则将tmp.sql追加到文件中
                if (fs.existsSync(versionSqlRootFile)) {
                    if (fs.existsSync(tmpSqlRootPath)) {
                        const tmpSqlContent = fs.readFileSync(tmpSqlRootPath, 'utf8');
                        const versionSqlContent = fs.readFileSync(versionSqlRootFile, 'utf8');
                        fs.writeFileSync(versionSqlRootFile, versionSqlContent + '\n\n' + tmpSqlContent);
                        fs.rmSync(tmpSqlRootPath);
                    }
                }
                else {
                    if (!fs.existsSync(tmpSqlRootPath)) continue;
                    fs.renameSync(tmpSqlRootPath, path.resolve(tmpSqlRootPath, '../', modelName + '_' + appVersion + '.sql'));
                }
            }

            const appJsonFilePath = path.join(_root, 'app', systemCode, appCode, 'app.json');
            if (!fs.existsSync(appJsonFilePath)) throw new Error('app.json文件不存在！');
            const jsonString = fs.readFileSync(appJsonFilePath, 'utf8');
            const json = JSON.parse(jsonString);
            json.version = appVersion;
            json.name = appName;
            json.compiler = compiler;
            fs.writeFileSync(appJsonFilePath, JSON.stringify(json, null, '\t'));
        }

    } catch (error) {
        console.log(error);
        this.onImportError(req, error.message);
    }
};

PublishProduct.prototype.onImportError = function (req, err) {
    this._importFields = null;
    this._pkFields = null;
    this._keys = null;
    var res = { code: 500, message: err };
    var tmpBGService = server.tmpBGServices[this.id];
    tmpBGService.status = -1;
    tmpBGService.endTime = new Date();
    tmpBGService.error = res;
    this.end(res);
};

PublishProduct.prototype.pipeSync = function (servicePath, req, res = { code: 0 }) {
    return new Promise((resolve, reject) => {
        this.pipe(require(servicePath), req, res, (resU) => {
            resolve(resU);
        });
    });
};

function zipDirSync(sourcePath, targetPath) {
    return new Promise((resolve, reject) => {
        const tzip = new Tzip();
        tzip.zipDir(sourcePath, targetPath, function () { resolve(); });
    });
};