var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('./utilExt');
var Service = require('Service');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

/**
 * 获得产品列表
 */
var GetList = function () {
  Service.call(this);
};

util.inherits(GetList, Service);

module.exports = GetList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetList.prototype.process = function (req, res) {
  if (!req.orgCode) {
    this.onLogicError(1, "请提供组织代码！");
    return;
  }
  var self = this;
  if (req.developerId) {
    requestMarket(this, {
      "service": "dp/service/tpm/getPackageList",
      "developerId": req.developerId,
      "systemCode": req.orgCode
    }, function (retHttp) {
      if (retHttp.code != 0) {
        self.onLogicError(2, retHttp.message);
        return;
      }
      res.sourcecode_status = {};
      for (const item of retHttp.rows) {
        res.sourcecode_status[item.code] = item.sourcecode_status;
      }
      var dirRoot = utils.getPath("/app/" + req.orgCode);
      fs.readdir(dirRoot, function (err, list) {
        if (err) {
          self.onLogicError(1, '读取目录信息出错：' + err.message);
          return;
        }
        var apps = [];
        res.rows = [];
        apps = retHttp.rows;
        if (list.length == 0 && apps.length == 0) {
          self.end(res);
          return;
        }
        if (apps.length > 0) {
          var pending = list.length;
          list.forEach(function (projName) {
            self.checkOmApp(req, projName, apps, function (app) {
              if (app) {
                res.rows.push(app);
              }
              if (!--pending) {
                if (apps.length > 0) {
                  self.createLocalAppDir(req, res, apps, 0, function () {
                    res.rows.sort(function (a, b) {
                      return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
                    });
                    self.end(res);
                  });
                } else {
                  res.rows.sort(function (a, b) {
                    return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
                  });
                  self.end(res);
                }
              }
            });
          });
        } else {
          self.getLocalAppList(req, list, function (rows) {
            res.rows = rows;
            self.end(res);
          });
        }
      });
    });
  } else {
    var dirRoot = utils.getPath("/app/" + req.orgCode);
    fs.readdir(dirRoot, function (err, list) {
      if (err) {
        self.onLogicError(1, '读取目录信息出错：' + err.message);
        return;
      }
      res.rows = [];
      if (list.length == 0) {
        self.end(res);
        return;
      }
      self.getLocalAppList(req, list, function (rows) {
        res.rows = rows;
        self.end(res);
      });
    });
  }
};

GetList.prototype.checkOmApp = function (req, productCode, apps, cb) {
  var self = this;
  var dirRoot = utils.getPath("/app/" + req.orgCode);
  var isContain = false;
  var appInfo = null;
  for (var i = 0; i < apps.length; i++) {
    if (apps[i].code == productCode) {
      isContain = true;
      appInfo = apps[i];
      apps.splice(i, 1);
      break;
    }
  }
  if (isContain) {
    var dir = path.resolve(dirRoot, productCode);
    fs.stat(dir, function (err, stat) {
      if (stat && stat.isDirectory()) {
        if (fs.existsSync(dir + "/app.json")) {
          var app = {
            id: appInfo.id,
            name: appInfo.code,
            create_status: 1,
            publish_status: appInfo.app_status,
          }
          cb(app);
        } else {
          let obj = {};
          obj.id = appInfo.id;
          obj.code = appInfo.code;
          obj.name = appInfo.name;
          obj.system = {
            'id': appInfo.system_id,
            'code': appInfo.system_code,
            'name': appInfo.system_name
          };
          obj.version = appInfo.cur_version;
          var packageJsonString = JSON.stringify(obj, null, "\t");
          var configFile = dir + "/app.json";
          fs.writeFileSync(configFile, packageJsonString);
          var app = {
            id: appInfo.id,
            name: appInfo.code,
            create_status: 1,
            publish_status: appInfo.app_status
          }
          cb(app);
        }
      } else {
        cb(null);
      }
    });
  } else {
    var dir = path.resolve(dirRoot, productCode);
    fs.stat(dir, function (err, stat) {
      if (stat && stat.isDirectory()) {
        if (fs.existsSync(dir + "/app.json")) {
          var app = {
            id: 0,
            name: productCode,
            create_status: 0,
            publish_status: 3
          }
          cb(app);
        } else {
          cb(null);
        }
      } else {
        cb(null);
      }
    });
  }
}

GetList.prototype.createLocalAppDir = function (req, res, apps, index, cb) {
  var self = this;
  if (index >= apps.length) {
    cb();
    return;
  }
  var appInfo = apps[index];
  //创建当前组织的后台服务目录
  var orgDir = utils.getPath("/app/" + appInfo.system_code);
  //判断后台服务目录有没有当前组织的目 录，如果没有，则创建
  if (!fs.existsSync(orgDir)) fs.mkdirSync(orgDir);
  var productDir = orgDir + "/" + appInfo.code;
  if (!fs.existsSync(productDir)) fs.mkdirSync(productDir);

  //创建产品开发目录的包文件, 与临时上传目录中的相同
  var configFile = productDir + "/app.json";
  let obj = {};
  obj.id = appInfo.id;
  obj.code = appInfo.code;
  obj.name = appInfo.name;
  obj.system = {
    'id': appInfo.system_id,
    'code': appInfo.system_code,
    'name': appInfo.system_name
  };
  obj.version = appInfo.cur_version;
  var packageJsonString = JSON.stringify(obj, null, "\t");
  fs.writeFileSync(configFile, packageJsonString);

  //创建数据模型目录
  var modelDir = productDir + "/model";
  if (!fs.existsSync(modelDir)) fs.mkdirSync(modelDir);

  //创建业务服务目录
  var serviceDir = productDir + "/service";
  if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);

  //创建前端web目录
  var webOrgDir = utils.getPath("/web/app/" + appInfo.system_code);
  if (!fs.existsSync(webOrgDir)) fs.mkdirSync(webOrgDir);
  var webDir = webOrgDir + "/" + appInfo.code;
  if (!fs.existsSync(webDir)) fs.mkdirSync(webDir);

  //创建小程序目录
  // var miniDir = utils.getPath("/minisrc/" + appInfo.code);
  // if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);
  // var miniprogramDir = utils.getPath("/miniprogram/" + appInfo.code);
  // if (!fs.existsSync(miniprogramDir)) fs.mkdirSync(miniprogramDir);

  //创建包临时目录,用于发布时存放复制过来的文件
  let tmpFilePath = utils.getPath('/tpm/package/' + appInfo.system_code + '/publish/' + appInfo.code);
  //创建多级目录
  if (utils.mkdirsSync(tmpFilePath)) {
    utils.mkdirsSync(tmpFilePath + '/app');
    utils.mkdirsSync(tmpFilePath + '/web');
    // utils.mkdirsSync(tmpFilePath + '/minisrc');
    //创建package.json
    var tmpFile = tmpFilePath + '/app.json';
    fs.writeFileSync(tmpFile, packageJsonString);
  }
  res.rows.push({
    id: appInfo.id,
    name: appInfo.code,
    create_status: 1,
    publish_status: appInfo.app_status
  });
  index++;
  self.createLocalAppDir(req, res, apps, index, cb);
}

GetList.prototype.getLocalAppList = function (req, list, cb) {
  var rows = [];
  var dirRoot = utils.getPath("/app/" + req.orgCode);
  var pending = list.length;
  list.forEach(function (projName) {
    var dir = path.resolve(dirRoot, projName);
    fs.stat(dir, function (err, stat) {
      if (stat && stat.isDirectory()) {
        if (fs.existsSync(dir + "/app.json")) {
          var obj = {
            id: 0,
            name: projName,
            create_status: 0,
            publish_status: 3
          }
          rows.push(obj);
        }
      }
      if (!--pending) {
        rows.sort(function (a, b) {
          return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
        });
        cb(rows);
      }
    });
  });
}