var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

/**
 * 获得产品
 */
var Get = function () {
  Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process = function (req, res) {
  var self = this;
  if (!req.appCode) {
    this.onLogicError(2, '请提供应用代码！');
    return;
  }
  if (!req.systemCode) {
    this.onLogicError(3, '请提供组织代码！');
    return;
  }
  if (!req.userId) {
    this.onLogicError(3, '请提供开发者编号！');
    return;
  }

  var msg = {
    "service": "dp/service/tpm/getPackage",
    "appCode": req.appCode,
    "systemCode": req.systemCode,
    "userId": req.userId
  };
  //向运营服务器发送请求
  requestMarket(this, msg, function (retHttp) {
    if (retHttp.code != 0) {
      self.onLogicError(4, retHttp.message);
      return;
    }
    res.data = retHttp.data;
    res.fileList = getFileList(res.data.sys_code, res.data.code);

    var packageStr = fs.readFileSync(utils.getPath('/app/' + res.data.sys_code + '/' + res.data.code + '/app.json'), 'utf8');
    if (packageStr) res.packageConfig = JSON.parse(packageStr);
    self.end(res);
  });
};

function getFileList(systemCode, appCode) {
  const appPath = path.join(path.sep, 'app', systemCode, appCode);
  return {
    name: appCode,
    path: appPath.replace(/\\/g, '/'),
    parentPath: '',
    size: 0,
    isDirectory: true,
    level: 1,
    spread: true,
    request: true,
    type: 'app',
    checked: false,
    children: [{
      name: '数据模型',
      path: path.join(appPath, 'model').replace(/\\/g, '/'),
      parentPath: appPath.replace(/\\/g, '/'),
      size: 0,
      isDirectory: true,
      level: 2,
      spread: false,
      request: false,
      type: 'model',
      checked: false,
      children: getFilesInfo(path.join(appPath, 'model'), 3, 'model')
    }, {
      name: '后台服务',
      path: path.join(appPath, 'service').replace(/\\/g, '/'),
      parentPath: appPath.replace(/\\/g, '/'),
      size: 0,
      isDirectory: true,
      level: 2,
      spread: false,
      request: false,
      type: 'service',
      checked: false,
      children: getFilesInfo(path.join(appPath, 'service'), 3, 'service')
    }, {
      name: '前端文件',
      path: path.join(path.sep, 'web', 'app', systemCode, appCode).replace(/\\/g, '/'),
      parentPath: appPath.replace(/\\/g, '/'),
      size: 0,
      isDirectory: true,
      level: 2,
      spread: false,
      request: false,
      type: 'web',
      checked: false,
      children: getFilesInfo(path.join(path.sep, 'web', 'app', systemCode, appCode), 3, 'web')
    }]
  };
}

function getFilesInfo(filePath, level, mode) {
  const nodePath = path.join(process.cwd(), filePath);
  if (!fs.existsSync(nodePath)) return [];
  const items = fs.readdirSync(nodePath);
  const dirList = [];
  const fileList = [];
  for (const item of items) {
    const name = item;
    const itemPath = path.join(nodePath, item);
    const itemStat = fs.statSync(itemPath);
    const itemInfo = {
      name: name,
      path: path.join(filePath, name).replace(/\\/g, '/'),
      parentPath: filePath.replace(/\\/g, '/'),
      size: itemStat.size,
      isDirectory: itemStat.isDirectory(),
      level: level,
      spread: false,
      request: false,
      mode: mode,
      checked: false,
      indeterminate: false,
      children: []
    };
    if (itemInfo.isDirectory) {
      dirList.push(itemInfo);
      itemInfo.children = getFilesInfo(itemInfo.path, level + 1, mode);
    }
    else fileList.push(itemInfo);
  }

  return [...dirList, ...fileList];
}

