var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var utils = require('./utilExt');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

/**
 * 获得组织列表
 */
var GetList = function () {
  Service.call(this);
};

util.inherits(GetList, Service);

module.exports = GetList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetList.prototype.process = function (req, res) {
  var self = this;
  if (!req.developerId) {
    self.onLogicError(1, '请提供开发者编号！');
    return;
  }
  requestMarket(this, {
    "service": "dp/service/tpm/getSystem",
    "developerId": req.developerId,
  }, function (retHttp) {
    if (retHttp.code != 0) {
      self.onLogicError(2, retHttp.message);
      return;
    }
    var systems = retHttp.systems;
    res.mold = {};
    res.orgMold = {};
    res.ret = [];
    if (systems.length == 0) return self.end(res);
    for (const system of systems) {
      res.mold[system.code] = system.developer_mold;
      res.orgMold[system.code] = system.org_mold;
      self.getOrgList(req, res, system);
    }
  });
};

GetList.prototype.getOrgList = function (req, res, system) {
  var self = this;
  var dirRoot = utils.getPath("/app");
  fs.readdir(dirRoot, function (err, list) {
    if (err) {
      self.onLogicError(1, '读取目录信息出错：' + err.message);
      return;
    }
    
    if (list.length == 0 && !system) {
      self.end(res);
      return;
    }
    var isContain = false;
    for (var i = 0; i < list.length; i++) {
      if (system && list[i] == system.code) {
        isContain = true;
        res.ret.push(list[i]);
      }
    }
    if (!isContain && system) {
      // 创建组织文件夹，用于发布产品
      var webDir = utils.getPath("/web/app/" + system.code);
      if (!fs.existsSync(webDir)) fs.mkdirSync(webDir);
      var serverDir = utils.getPath("/app/" + system.code);
      if (!fs.existsSync(serverDir)) fs.mkdirSync(serverDir);
      //创建org.json
      var org = {
        'code': system.code,
        'name': system.name
      }
      var orgFile = utils.getPath("/app/" + system.code + "/org.json");
      fs.writeFileSync(orgFile, JSON.stringify(org));
      res.ret.push(system.code);
      list.push(system.code);
      var pending = list.length;
      list.forEach(function (projName) {
        var dir = path.resolve(dirRoot, projName);
        fs.stat(dir, function (err, stat) {
          if (stat && stat.isDirectory()) {
            if (!fs.existsSync(dir + "/org.json")) {
              res.ret.remove(projName);
            }
          } else {
            res.ret.remove(projName);
          }
          if (!--pending) {
            res.ret.sort(function (a, b) {
              return a.toLowerCase().localeCompare(b.toLowerCase());
            });
            self.end(res);
            return;
          }
        });
      });
    } else {
      var pending = list.length;
      list.forEach(function (projName) {
        var dir = path.resolve(dirRoot, projName);
        fs.stat(dir, function (err, stat) {
          if (stat && stat.isDirectory()) {
            if (!fs.existsSync(dir + "/org.json")) {
              if (system && system.code == projName) {
                // 创建组织文件夹，用于发布产品
                var webDir = utils.getPath("/web/app/" + system.code);
                if (!fs.existsSync(webDir)) fs.mkdirSync(webDir);
                var serverDir = utils.getPath("/app/" + system.code);
                if (!fs.existsSync(serverDir)) fs.mkdirSync(serverDir);
                //创建org.json
                var org = {
                  'code': system.code,
                  'name': system.name
                }
                var orgFile = utils.getPath("/app/" + system.code + "/org.json");
                fs.writeFileSync(orgFile, JSON.stringify(org));
              } else {
                res.ret.remove(projName);
              }
            }
          } else {
            res.ret.remove(projName);
          }
          if (!--pending) {
            res.ret.sort(function (a, b) {
              return a.toLowerCase().localeCompare(b.toLowerCase());
            });
            self.end(res);
            return;
          }
        });
      });
    }
  });
}