const net = require('net');
const EventEmitter = require('events').EventEmitter;
const util = require('util');
const fs = require('fs') ;
const path = require('path');
const TcpSocket = require('TcpSocket');
const uuid = require('./uuid.js');
// var devAuth = require('./devAuth');
const Package = TcpSocket.Package;
const { getMarketTcpAddress } = server.loadModule("/app/dev/service/requestUtils");

var Downloader = function () {
  this.fileSize = 0;
  this.downloadSize = 0;
  this.key;
  this.socket;
  this.buffers = [];
  this.isRunning = true;
  this.reConCount = 0;
  this.startTime = null;
  this.timeoutLength = 15000;
  this.reqArgs = null;
  this.isDownloading = false;
  this.writeStream = null;
  this.tcp = getMarketTcpAddress();
};

util.inherits(Downloader, EventEmitter);

module.exports = Downloader;

Downloader.prototype.start = function(args) {
  if(args.isReceiveChatFile) {
    this.key = args.msgId;
  } else {
    this.key = args.fileId;
    if(!this.key) this.key = args.fileCode;
    if(!this.key) this.key = args.appCode+"_"+args.appDataId;
  }
  if(!this.key || this.key=="_" || !args.savePath) {
    this.onError('请提供下载附件所需的必要参数！');
    return;
  }
  if(args.downloadSize){
    this.downloadSize = parseInt(args.downloadSize);
  }
  this.savePath = args.savePath;
  this.reqArgs = args;
  this.download();
};

Downloader.prototype.stop = function() {
  var self = this;
  this.isDownloading = false;
  if(this.writeStream) {
    try {
      this.writeStream.end();
    } catch(err) {
      //
    }
    this.writeStream = null;
  }
  if(this.socket) {
    try {
      this.socket.destroy();
    } catch(err) {
      //
    }
    this.socket = null;
  }
};

Downloader.prototype.checkTimeout = function() {
  if(!this.isRunning || !this.isDownloading) return;
  var self = this;
  setTimeout(function() {
    if(!self.isRunning || !self.isDownloading) return;
    if(((new Date())-self.startTime)>self.timeoutLength) {
      if(self.reConCount<3) {
        self.reConCount++;
        logger.log('第'+self.reConCount+'次下载失败，连接超时，准备重新下载...');
        self.stop();
        self.download();
        return;
      }
      self.onError('连接超时，请稍后再试！');
      return;
    }
    self.checkTimeout();
  }, 1000);
};

Downloader.prototype.download = function() {
  if(fs.existsSync(this.reqArgs.savePath)) {
    try {
      fs.unlinkSync(this.reqArgs.savePath);
    } catch(err) {
      this.onError('无法删除原有文件！');
      return;
    }
  }
  var self = this;
  this.buffers = [];
  this.startTime = new Date();
  this.isDownloading = true;
  this.checkTimeout();
  this.socket = new net.Socket();
  var tcpSocket = new TcpSocket(this.socket);
  this.socket.on('error', function(err) {
    self.onError(err);
  });
  //global.config.TcpFileServer.port, global.config.TcpFileServer.host
  this.socket.connect(self.tcp.port, self.tcp.url, function() {
    self.startTime = new Date();
    var tempFilePath = path.dirname(self.reqArgs.savePath);
    if(!fs.existsSync(tempFilePath)) fs.mkdirSync(tempFilePath);
    if(self.reqArgs.fileName){
      //追加时使用已有的文件名
      tempFilePath += '/'+self.reqArgs.fileName;
    }else{
      if(self.reqArgs.fileCode){
        //新建时生成临时文件名
        tempFilePath += '/'+self.reqArgs.fileCode+'.tmp';
      }else{
        //记录临时生成的code如果网络断开断点续传使用
        var fileCode = uuid.v1().replace(/-/g,'');
        self.reqArgs.fileCode = fileCode;
        //新建时生成临时文件名
        tempFilePath += '/'+fileCode+'.tmp';
      }
      //需要验证该文件是否存在，如果存在删除
      if(self.downloadSize == 0 && fs.existsSync(tempFilePath) && self.reqArgs.app != "netdisk"){
        fs.unlinkSync(tempFilePath);
      }
    }
    var isReadHead = false;

    tcpSocket.on('push', function(res) {
      logger.log('收到服务响应信息：');
      logger.log(res);

      if(!self.isRunning) {
        self.socket.destroy();
        return;
      }
      if(res.code!=0) {
        self.onError(res.message);
        return;
      }
      self.startTime = new Date();
      self.fileSize = res.fileSize;
      if(self.downloadSize){
        self.writeStream = fs.createWriteStream(tempFilePath, {flags: 'a', start: self.downloadSize}); 
      }else{
        self.writeStream = fs.createWriteStream(tempFilePath, {flags: 'w'});  
      }

      tcpSocket.stopListen();

      self.socket.on('data', function(chunk) {
        self.buffers.push(chunk);
      });

      self.socket.write(new Buffer('go'), null, function(err) {
        if(err) {
          self.onError('发送开始下载命令时发生意外错误：'+err.message);
        }
      });
      self.saveFileData(tempFilePath);
    });
    //发送消息
    var msgSend = {};
    for(p in self.reqArgs) {
      if(p != "savePath")
      msgSend[p] = self.reqArgs[p];
    }
    // var loginInfo = {
    //   orgCode: self.reqArgs.loginUser.orgCode,
    //   orgKey: self.reqArgs.loginUser.orgKey,
    //   loginname: self.reqArgs.loginUser.mobile,
    //   password: self.reqArgs.loginUser.password
    // };
    msgSend.service = 'dp/service/tpm/download';
    if(self.downloadSize>0) msgSend.start = self.downloadSize;
    // devAuth.setAuthInfo(msgSend, loginInfo, function (code, message) {
    // // global.tpm.setAuthInfo(msgSend);
    // // global.tpm.setAuthInfo(msgSend, function(code, message) {
    //   if(code!=0) {
    //     self.onError('生成身份验证信息时发生意外错误：' + message);
    //     return;
    //   }
      logger.log('准备下载文件，参数值：'+JSON.stringify(msgSend));
      tcpSocket.push(msgSend, function(err) {
        if(err) {
          self.onError('发送下载参数时发生意外错误：'+err.message);
          return;
        }
      });
    // });
  });
};

Downloader.prototype.saveFileData = function(tempFilePath) {
  if(!this.isRunning || this.downloadSize>=this.fileSize) {
    this.stop();
    return;
  }
  var self = this;
  if(this.buffers.length==0) {
    setTimeout(function() {self.saveFileData(tempFilePath);}, 100);
    return;
  }
  var chunk = this.buffers.shift();
  // 当文件传输到结尾时，删除buffer中的最后14字节，多出内容为[    {"code":0}]
  if(self.downloadSize + chunk.length >= self.fileSize) {
    chunk = chunk.subarray(0, chunk.length - 14);
  }
  self.writeStream.write(chunk, null, function(err) {
    if(err) {
      self.onError('写入文件数据时发生意外错误！');
      return;
    }
    self.downloadSize += chunk.length;
    if(self.isRunning) self.emit('downloadProgress', parseInt(self.downloadSize*100/self.fileSize), parseInt(self.downloadSize));
    if(self.downloadSize>=self.fileSize) {
      self.stop();
      if(!self.isRunning) return;
      try {
        logger.log('将临时文件['+tempFilePath+']重命名为['+self.savePath+']');
        fs.rename(tempFilePath, self.savePath, function(err) {
          if(err) {
            self.onError('将临时文件重命名为目标文件时发生意外错误：'+err.message);    
            return;
          }
          logger.log('下载完毕。');
          if(self.isRunning) self.emit('downloadFinish', self.fileSize);
          self.isRunning = false;
        });
      } catch(err) {
        self.onError('将临时文件重命名为目标文件时发生意外错误：'+err.message);
      }
      return;
    }
    if(self.isRunning) self.saveFileData(tempFilePath);
  });
};

Downloader.prototype.onError = function(err) {
  this.isRunning = false;
  this.stop(); 
  var errMsg = err;
  if(typeof(errMsg) != 'string') errMsg = err.message;
  logger.log('接收文件数据时发生意外错误：'+errMsg);
  this.emit('downloadError', '接收文件数据时发生意外错误：'+errMsg, this.downloadSize);
  //如果报错需要判断是否需要断点续传，如果需要断点续传则不删除临时文件
  //暂时只有网盘需要断点续传
  if(this.reqArgs.app != "netdisk"){
    var tempFilePath = path.dirname(this.savePath)+'/'+this.key+'.tmp';
    if(fs.existsSync(tempFilePath)){
      fs.unlinkSync(tempFilePath);
    }
  }
};